/*
 * Decompiled with CFR 0.152.
 */
package io.github.iamazy.elasticsearch.dsl.jdbc.elastic;

import io.github.iamazy.elasticsearch.dsl.jdbc.elastic.JdbcScrollSearchResponse;
import io.github.iamazy.elasticsearch.dsl.jdbc.elastic.JdbcSearchResponse;
import io.github.iamazy.elasticsearch.dsl.utils.FlatMapUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.composite.ParsedComposite;
import org.elasticsearch.search.aggregations.bucket.nested.Nested;
import org.elasticsearch.search.aggregations.bucket.nested.ParsedNested;
import org.elasticsearch.search.aggregations.bucket.range.ParsedRange;
import org.elasticsearch.search.aggregations.bucket.range.Range;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.Cardinality;
import org.elasticsearch.search.aggregations.metrics.GeoBounds;
import org.elasticsearch.search.aggregations.metrics.ParsedCardinality;
import org.elasticsearch.search.aggregations.metrics.ParsedGeoBounds;
import org.elasticsearch.search.aggregations.metrics.ParsedTopHits;
import org.elasticsearch.search.aggregations.metrics.TopHits;

public class JdbcResponseExtractor {
    private void parseTermsAggregation(Aggregation aggregation, Map<String, Object> aggMap, String parent) {
        Terms buckets = (Terms)aggregation;
        LinkedHashMap<String, Number> tmpSubAgg = new LinkedHashMap<String, Number>(0);
        LinkedHashMap<String, Object> subAggMap = new LinkedHashMap<String, Object>(0);
        int total = 0;
        for (Terms.Bucket bucket : buckets.getBuckets()) {
            total = (int)((long)total + bucket.getDocCount());
            if (!StringUtils.isNotBlank((CharSequence)bucket.getKeyAsString())) continue;
            if (bucket.getAggregations() != null && bucket.getAggregations().asList().size() > 0) {
                this.parseAggregations(bucket.getAggregations(), subAggMap, bucket.getKeyAsString());
                if (parent != null) {
                    aggMap.put(parent, subAggMap);
                    continue;
                }
                aggMap.put(buckets.getName(), subAggMap);
                continue;
            }
            tmpSubAgg.put(bucket.getKeyAsString(), bucket.getDocCount());
        }
        if (MapUtils.isNotEmpty(tmpSubAgg)) {
            tmpSubAgg.put("total", total);
            if (parent != null) {
                aggMap.put(parent, tmpSubAgg);
            } else {
                aggMap.put(buckets.getName(), tmpSubAgg);
            }
        } else if (!subAggMap.containsKey("total")) {
            subAggMap.put("total", total);
        }
    }

    private void parseCompositeAggregation(Aggregation aggregation, Map<String, Object> aggMap, String parent) {
        ParsedComposite composite = (ParsedComposite)aggregation;
        LinkedHashMap<String, Object> tmpSubAgg = new LinkedHashMap<String, Object>(0);
        for (ParsedComposite.ParsedBucket bucket : composite.getBuckets()) {
            if (!StringUtils.isNotBlank((CharSequence)bucket.getKeyAsString())) continue;
            String field = null;
            Object value = null;
            for (Map.Entry entry : bucket.getKey().entrySet()) {
                field = (String)entry.getKey();
                tmpSubAgg.put("field", field);
                value = entry.getValue();
            }
            if (value == null || !StringUtils.isNotBlank(field)) continue;
            tmpSubAgg.put(value.toString(), bucket.getDocCount());
        }
        if (MapUtils.isNotEmpty(tmpSubAgg)) {
            if (parent != null) {
                aggMap.put(parent, tmpSubAgg);
            } else {
                String field = tmpSubAgg.get("field").toString();
                tmpSubAgg.remove("field");
                aggMap.put(field, tmpSubAgg);
            }
        }
    }

    private void parseTopHitsAggregation(Aggregation aggregation, Map<String, Object> aggMap) {
        TopHits topHits = (TopHits)aggregation;
        SearchHit[] hits = topHits.getHits().getHits();
        ArrayList<Map> topHitList = new ArrayList<Map>(0);
        for (SearchHit hit : hits) {
            topHitList.add(hit.getSourceAsMap());
        }
        aggMap.put(aggregation.getName(), topHitList);
    }

    private void parseRangeAggregation(Aggregation aggregation, Map<String, Object> aggMap) {
        Range range = (Range)aggregation;
        ArrayList rangeList = new ArrayList(0);
        for (Range.Bucket bucket : range.getBuckets()) {
            HashMap<String, Long> rangeItem = new HashMap<String, Long>(0);
            rangeItem.put(bucket.getKeyAsString(), bucket.getDocCount());
            rangeList.add(rangeItem);
        }
        aggMap.put(range.getName(), rangeList);
    }

    private void parseGeoBoundAggregation(Aggregation aggregation, Map<String, Object> aggMap) {
        GeoBounds geoBounds = (GeoBounds)aggregation;
        LinkedHashMap coordinate = new LinkedHashMap(0);
        FlatMapUtils.flatPut((String)"leftTop.lat", (Object)geoBounds.topLeft().lat(), coordinate);
        FlatMapUtils.flatPut((String)"leftTop.lon", (Object)geoBounds.topLeft().lon(), coordinate);
        FlatMapUtils.flatPut((String)"rightBottom.lat", (Object)geoBounds.bottomRight().lat(), coordinate);
        FlatMapUtils.flatPut((String)"rightBottom.lon", (Object)geoBounds.bottomRight().lon(), coordinate);
        aggMap.put(aggregation.getName(), coordinate);
    }

    private void parseNestedAggregation(Aggregation aggregation, Map<String, Object> aggMap) {
        Nested nested = (Nested)aggregation;
        if (nested.getAggregations() != null && nested.getAggregations().asList().size() > 0) {
            this.parseAggregations(nested.getAggregations(), aggMap, null);
        }
    }

    private void parseCardinalityAggregation(Aggregation aggregation, Map<String, Object> aggMap) {
        Cardinality cardinality = (Cardinality)aggregation;
        aggMap.put(cardinality.getName(), cardinality.getValue());
    }

    private void parseAggregations(Aggregations aggregations, Map<String, Object> aggMap, String parent) {
        for (Aggregation aggregation : aggregations) {
            if (aggregation instanceof ParsedNested) {
                this.parseNestedAggregation(aggregation, aggMap);
                continue;
            }
            if (aggregation instanceof ParsedComposite) {
                this.parseCompositeAggregation(aggregation, aggMap, parent);
                continue;
            }
            if (aggregation instanceof ParsedTerms) {
                this.parseTermsAggregation(aggregation, aggMap, parent);
                continue;
            }
            if (aggregation instanceof ParsedTopHits) {
                this.parseTopHitsAggregation(aggregation, aggMap);
                continue;
            }
            if (aggregation instanceof ParsedCardinality) {
                this.parseCardinalityAggregation(aggregation, aggMap);
                continue;
            }
            if (aggregation instanceof ParsedRange) {
                this.parseRangeAggregation(aggregation, aggMap);
                continue;
            }
            if (!(aggregation instanceof ParsedGeoBounds)) continue;
            this.parseGeoBoundAggregation(aggregation, aggMap);
        }
    }

    public JdbcSearchResponse parseSearchResponse(SearchResponse response, Map<String, String> aliasMap) {
        SearchHit[] searchHits;
        JdbcSearchResponse jdbcSearchResponse = new JdbcSearchResponse();
        jdbcSearchResponse.setSize(response.getHits().getHits().length);
        jdbcSearchResponse.setTook(response.getTook().getMillis());
        if (response.getHits().getTotalHits() != null) {
            jdbcSearchResponse.setTotal(response.getHits().getTotalHits().value);
        }
        if ((searchHits = response.getHits().getHits()) != null && searchHits.length > 0) {
            ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(searchHits.length);
            for (SearchHit hit : response.getHits().getHits()) {
                hit.getSourceAsMap().put("_id", hit.getId());
                if (hit.field("_routing") != null) {
                    hit.getSourceAsMap().put("_routing", hit.field("_routing").getValue());
                }
                result.add(hit.getSourceAsMap());
            }
            jdbcSearchResponse.setResult(result);
            jdbcSearchResponse.setAliasMap(aliasMap);
        }
        return jdbcSearchResponse;
    }

    public JdbcSearchResponse parseScrollSearchResponse(SearchResponse response, Map<String, String> aliasMap) {
        JdbcSearchResponse searchResponse = this.parseSearchResponse(response, aliasMap);
        String scrollId = response.getScrollId();
        return new JdbcScrollSearchResponse(searchResponse, scrollId);
    }
}

