/*
 * Decompiled with CFR 0.152.
 */
package io.github.iamazy.elasticsearch.dsl.jdbc.result;

import io.github.iamazy.elasticsearch.dsl.jdbc.result.AbstractFeatureNotSupportedResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public abstract class AbstractResultSet
extends AbstractFeatureNotSupportedResultSet {
    protected boolean isClosed = false;
    protected Statement statement;

    public AbstractResultSet(Statement statement) {
        this.statement = statement;
    }

    @Override
    public void close() throws SQLException {
        this.isClosed = true;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        return 1;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return false;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public Statement getStatement() {
        return this.statement;
    }

    @Override
    public int getHoldability() throws SQLException {
        return 2;
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getString(columnLabel);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw new SQLException(String.format("[%s] cannot be unwrapped as [%s]", this.getClass().getName(), iface.getName()));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }
}

