/*
 * Decompiled with CFR 0.152.
 */
package io.github.iamazy.elasticsearch.dsl.jdbc.result;

import io.github.iamazy.elasticsearch.dsl.jdbc.elastic.JdbcScrollSearchResponse;
import io.github.iamazy.elasticsearch.dsl.jdbc.elastic.JdbcSearchResponse;
import io.github.iamazy.elasticsearch.dsl.jdbc.result.AbstractResultSet;
import io.github.iamazy.elasticsearch.dsl.jdbc.result.ElasticResultSetMetaData;
import io.github.iamazy.elasticsearch.dsl.jdbc.statement.ElasticStatement;
import io.github.iamazy.elasticsearch.dsl.utils.FlatMapUtils;
import java.io.IOException;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Objects;

public class ElasticResultSet
extends AbstractResultSet {
    private static final ElasticResultSetMetaData RESULT_SET_META_DATA = new ElasticResultSetMetaData();
    private JdbcSearchResponse response;
    private int rowCursor = -1;

    public ElasticResultSet(Statement statement, JdbcSearchResponse response) {
        super(statement);
        this.response = response;
    }

    @Override
    public boolean next() throws SQLException {
        ++this.rowCursor;
        if (this.response instanceof JdbcScrollSearchResponse && this.rowCursor == this.getFetchSize()) {
            ElasticStatement elasticStatement = (ElasticStatement)this.statement;
            try {
                ElasticResultSet resultSet = (ElasticResultSet)elasticStatement.executeScrollQuery(this.response.getSql(), ((JdbcScrollSearchResponse)this.response).getScrollId());
                this.response = resultSet.response;
                this.rowCursor = 0;
            }
            catch (IOException e) {
                throw new SQLException(e.getMessage());
            }
        }
        return this.rowCursor + 1 <= this.getFetchSize();
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        String fieldName = columnLabel;
        if (this.response.getAliasMap().containsKey(columnLabel)) {
            fieldName = this.response.getAliasMap().get(fieldName);
        }
        Object result = FlatMapUtils.flatGet((String)fieldName, this.response.getResult().get(this.rowCursor));
        Objects.requireNonNull(result);
        return result.toString();
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return Boolean.parseBoolean(this.getString(columnLabel));
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return FlatMapUtils.flatGet((String)columnLabel, this.response.getResult().get(this.rowCursor));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return new Date(this.getLong(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return new Time(this.getLong(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return new Timestamp(this.getLong(columnLabel));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return Long.parseLong(this.getString(columnLabel));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return Integer.parseInt(this.getString(columnLabel));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return Double.parseDouble(this.getString(columnLabel));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return Short.parseShort(this.getString(columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return Float.parseFloat(this.getString(columnLabel));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return RESULT_SET_META_DATA;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.rowCursor = 0;
    }

    @Override
    public void afterLast() throws SQLException {
        this.rowCursor = 1;
    }

    @Override
    public int getRow() throws SQLException {
        return this.rowCursor;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.response.getSize();
    }
}

