/*
 * Decompiled with CFR 0.152.
 */
package io.github.iamazy.elasticsearch.dsl.jdbc.statement;

import io.github.iamazy.elasticsearch.dsl.jdbc.ElasticConnection;
import io.github.iamazy.elasticsearch.dsl.jdbc.cons.JdbcConstants;
import io.github.iamazy.elasticsearch.dsl.jdbc.elastic.JdbcResponseExtractor;
import io.github.iamazy.elasticsearch.dsl.jdbc.elastic.JdbcSearchResponse;
import io.github.iamazy.elasticsearch.dsl.jdbc.result.ElasticResultSet;
import io.github.iamazy.elasticsearch.dsl.jdbc.statement.AbstractStatement;
import io.github.iamazy.elasticsearch.dsl.sql.ElasticSql2DslParser;
import io.github.iamazy.elasticsearch.dsl.sql.enums.SqlOperation;
import io.github.iamazy.elasticsearch.dsl.sql.model.ElasticSqlParseResult;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.index.reindex.BulkByScrollResponse;

public class ElasticStatement
extends AbstractStatement {
    protected ElasticConnection connection;
    private ResultSet resultSet;
    private ElasticSql2DslParser elasticSql2DslParser;
    private Map<String, String> aliasMap;

    public ElasticStatement(ElasticConnection connection) {
        this.connection = connection;
        this.elasticSql2DslParser = new ElasticSql2DslParser();
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        ElasticSqlParseResult parseResult = this.elasticSql2DslParser.parse(sql);
        this.checkDatabase(parseResult.getIndices());
        assert (parseResult.getSqlOperation() == SqlOperation.SELECT);
        try {
            SearchResponse searchResponse = this.connection.getRestClient().search(parseResult.getSearchRequest(), RequestOptions.DEFAULT);
            JdbcResponseExtractor jdbcResponseExtractor = new JdbcResponseExtractor();
            this.aliasMap = parseResult.getAliasMap();
            this.resultSet = new ElasticResultSet(this, jdbcResponseExtractor.parseSearchResponse(searchResponse, parseResult.getAliasMap()));
            return this.resultSet;
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
    }

    public ResultSet executeScrollQuery(String sql, String scrollId) throws SQLException, IOException {
        SearchResponse searchResponse;
        JdbcResponseExtractor jdbcResponseExtractor = new JdbcResponseExtractor();
        if (StringUtils.isBlank((CharSequence)scrollId)) {
            ElasticSqlParseResult parseResult = this.elasticSql2DslParser.parse(sql);
            this.checkDatabase(parseResult.getIndices());
            assert (parseResult.getSqlOperation() == SqlOperation.SELECT);
            parseResult.getSearchRequest().scroll(JdbcConstants.SCROLL);
            parseResult.getSearchRequest().source().size(3000);
            parseResult.getSearchRequest().source().trackTotalHits(true);
            this.aliasMap = parseResult.getAliasMap();
            searchResponse = this.connection.getRestClient().search(parseResult.getSearchRequest(), RequestOptions.DEFAULT);
        } else {
            SearchScrollRequest scrollRequest = new SearchScrollRequest(scrollId);
            scrollRequest.scroll(JdbcConstants.SCROLL);
            searchResponse = this.connection.getRestClient().scroll(scrollRequest, RequestOptions.DEFAULT);
        }
        JdbcSearchResponse jdbcSearchResponse = jdbcResponseExtractor.parseScrollSearchResponse(searchResponse, this.aliasMap);
        if (StringUtils.isBlank((CharSequence)jdbcSearchResponse.getSql())) {
            jdbcSearchResponse.setSql(sql);
        }
        this.resultSet = new ElasticResultSet(this, jdbcSearchResponse);
        return this.resultSet;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        ElasticSqlParseResult parseResult = this.elasticSql2DslParser.parse(sql);
        this.checkDatabase(parseResult.getIndices());
        try {
            switch (parseResult.getSqlOperation()) {
                case INSERT: {
                    this.connection.getRestClient().index(parseResult.getIndexRequest(), RequestOptions.DEFAULT);
                    return 1;
                }
                case UPDATE: {
                    this.connection.getRestClient().update(parseResult.getUpdateRequest(), RequestOptions.DEFAULT);
                    return 1;
                }
                case UPDATE_BY_QUERY: {
                    BulkByScrollResponse response = this.connection.getRestClient().updateByQuery(parseResult.getUpdateByQueryRequest(), RequestOptions.DEFAULT);
                    return (int)response.getUpdated();
                }
                case DELETE: {
                    this.connection.getRestClient().delete(parseResult.getDeleteRequest(), RequestOptions.DEFAULT);
                    return 1;
                }
                case DELETE_BY_QUERY: {
                    BulkByScrollResponse response = this.connection.getRestClient().deleteByQuery(parseResult.getDeleteByQueryRequest(), RequestOptions.DEFAULT);
                    return (int)response.getDeleted();
                }
            }
            throw new SQLException("only support [insert,update,delete] operation");
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return super.execute(sql, columnNames);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.executeQuery(sql);
        return true;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.resultSet;
    }

    public Map<String, String> getAliasMap() {
        return this.aliasMap;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    protected ResultSet executeQuery(String sql, Object[] args) throws SQLException {
        sql = this.prepareExecute(sql, args);
        return this.executeQuery(sql);
    }

    @Override
    public void close() throws SQLException {
        this.connection.close();
    }

    @Override
    public boolean isClosed() {
        return this.connection.isClosed();
    }

    String prepareExecute(String sql, Object[] args) {
        int count = StringUtils.countMatches((CharSequence)sql, (CharSequence)"?");
        assert (count == args.length);
        for (Object item : args) {
            sql = sql.replaceFirst("\\?", item.toString());
        }
        return sql;
    }

    private void checkDatabase(List<String> indices) throws SQLException {
        if (!this.connection.getDatabaseNames().containsAll(indices)) {
            throw new SQLException("[invalid] database queried must be contained in " + this.connection.getDatabaseNames());
        }
    }
}

