/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.redis.config;

import java.time.Duration;
import net.dreamlu.mica.core.utils.INetUtil;
import net.dreamlu.mica.core.utils.StringUtil;
import net.dreamlu.mica.redis.config.MicaRedisProperties;
import net.dreamlu.mica.redis.stream.DefaultRStreamTemplate;
import net.dreamlu.mica.redis.stream.RStreamListenerDetector;
import net.dreamlu.mica.redis.stream.RStreamTemplate;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.util.ErrorHandler;

@AutoConfiguration
@ConditionalOnProperty(prefix="mica.redis.stream", name={"enable"}, havingValue="true")
public class RedisStreamConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public StreamMessageListenerContainer.StreamMessageListenerContainerOptions<String, MapRecord<String, String, byte[]>> streamMessageListenerContainerOptions(MicaRedisProperties properties, ObjectProvider<ErrorHandler> errorHandlerObjectProvider) {
        Duration pollTimeout;
        StreamMessageListenerContainer.StreamMessageListenerContainerOptionsBuilder builder = StreamMessageListenerContainer.StreamMessageListenerContainerOptions.builder().keySerializer(RedisSerializer.string()).hashKeySerializer(RedisSerializer.string()).hashValueSerializer(RedisSerializer.byteArray());
        MicaRedisProperties.Stream streamProperties = properties.getStream();
        Integer pollBatchSize = streamProperties.getPollBatchSize();
        if (pollBatchSize != null && pollBatchSize > 0) {
            builder.batchSize(pollBatchSize.intValue());
        }
        if ((pollTimeout = streamProperties.getPollTimeout()) != null && !pollTimeout.isNegative()) {
            builder.pollTimeout(pollTimeout);
        }
        errorHandlerObjectProvider.ifAvailable(arg_0 -> ((StreamMessageListenerContainer.StreamMessageListenerContainerOptionsBuilder)builder).errorHandler(arg_0));
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public StreamMessageListenerContainer<String, MapRecord<String, String, byte[]>> streamMessageListenerContainer(RedisConnectionFactory redisConnectionFactory, StreamMessageListenerContainer.StreamMessageListenerContainerOptions<String, MapRecord<String, String, byte[]>> streamMessageListenerContainerOptions) {
        return StreamMessageListenerContainer.create((RedisConnectionFactory)redisConnectionFactory, streamMessageListenerContainerOptions);
    }

    @Bean
    @ConditionalOnMissingBean
    public RStreamListenerDetector streamListenerDetector(StreamMessageListenerContainer<String, MapRecord<String, String, byte[]>> streamMessageListenerContainer, RedisTemplate<String, Object> redisTemplate, ObjectProvider<ServerProperties> serverPropertiesObjectProvider, MicaRedisProperties properties, Environment environment) {
        String consumerName;
        MicaRedisProperties.Stream streamProperties = properties.getStream();
        String consumerGroup = streamProperties.getConsumerGroup();
        if (StringUtil.isBlank((CharSequence)consumerGroup)) {
            String appName = environment.getRequiredProperty("spring.application.name");
            String profile = environment.getProperty("spring.profiles.active");
            String string = consumerGroup = StringUtil.isBlank((CharSequence)profile) ? appName : appName + ':' + profile;
        }
        if (StringUtil.isBlank((CharSequence)(consumerName = streamProperties.getConsumerName()))) {
            StringBuilder consumerNameBuilder = new StringBuilder(INetUtil.getHostIp());
            serverPropertiesObjectProvider.ifAvailable(serverProperties -> consumerNameBuilder.append(':').append(serverProperties.getPort()));
            consumerName = consumerNameBuilder.toString();
        }
        return new RStreamListenerDetector(streamMessageListenerContainer, redisTemplate, consumerGroup, consumerName);
    }

    @Bean
    public RStreamTemplate streamTemplate(RedisTemplate<String, Object> redisTemplate) {
        return new DefaultRStreamTemplate(redisTemplate);
    }
}

