/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.delete;

import java.util.List;
import org.flowable.batch.api.Batch;
import org.flowable.batch.api.BatchPart;
import org.flowable.batch.api.BatchPartQuery;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.calendar.BusinessCalendar;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.ManagementService;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.job.service.JobHandler;
import org.flowable.job.service.JobService;
import org.flowable.job.service.TimerJobService;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntity;
import org.flowable.variable.api.delegate.VariableScope;

public class ComputeDeleteHistoricProcessInstanceStatusJobHandler
implements JobHandler {
    public static final String TYPE = "compute-delete-historic-process-status";

    public String getType() {
        return TYPE;
    }

    public void execute(JobEntity job, String configuration, VariableScope variableScope, CommandContext commandContext) {
        long totalCompleted;
        ProcessEngineConfigurationImpl engineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        ManagementService managementService = engineConfiguration.getManagementService();
        Batch batch = (Batch)managementService.createBatchQuery().batchId(configuration).singleResult();
        if (batch == null) {
            throw new FlowableIllegalArgumentException("There is no batch with the id " + configuration);
        }
        long totalBatchParts = this.createStatusQuery(batch, managementService).count();
        if (totalBatchParts == (totalCompleted = this.createStatusQuery(batch, managementService).completed().count())) {
            long totalFailed = this.createStatusQuery(batch, managementService).status("failed").count();
            if (totalFailed == 0L) {
                List deleteBatchParts = managementService.createBatchPartQuery().batchId(batch.getId()).type("deleteProcess").status("waiting").list();
                JobService jobService = engineConfiguration.getJobServiceConfiguration().getJobService();
                for (BatchPart deleteBatchPart : deleteBatchParts) {
                    JobEntity deleteJob = jobService.createJob();
                    deleteJob.setJobHandlerType("delete-historic-process-ids");
                    deleteJob.setJobHandlerConfiguration(deleteBatchPart.getId());
                    jobService.createAsyncJob(deleteJob, false);
                    jobService.scheduleAsyncJob(deleteJob);
                }
                TimerJobService timerJobService = engineConfiguration.getJobServiceConfiguration().getTimerJobService();
                TimerJobEntity timerJob = timerJobService.createTimerJob();
                timerJob.setJobType("timer");
                timerJob.setRevision(1);
                timerJob.setJobHandlerType("delete-historic-process-status");
                timerJob.setJobHandlerConfiguration(batch.getId());
                BusinessCalendar businessCalendar = engineConfiguration.getBusinessCalendarManager().getBusinessCalendar("cycle");
                timerJob.setDuedate(businessCalendar.resolveDuedate(engineConfiguration.getBatchStatusTimeCycleConfig()));
                timerJob.setRepeat(engineConfiguration.getBatchStatusTimeCycleConfig());
                timerJobService.scheduleTimerJob(timerJob);
            } else {
                this.completeBatch(batch, "failed", engineConfiguration);
            }
            job.setRepeat(null);
        } else if (totalBatchParts == 0L) {
            this.completeBatch(batch, "completed", engineConfiguration);
            job.setRepeat(null);
        }
    }

    protected BatchPartQuery createStatusQuery(Batch batch, ManagementService managementService) {
        return managementService.createBatchPartQuery().batchId(batch.getId()).type("computeDeleteProcessInstanceIds");
    }

    protected void completeBatch(Batch batch, String status, ProcessEngineConfigurationImpl engineConfiguration) {
        engineConfiguration.getBatchServiceConfiguration().getBatchService().completeBatch(batch.getId(), status);
    }
}

