/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.history.async.json.transformer.AbstractHistoryJsonTransformer;
import org.flowable.job.service.impl.history.async.util.AsyncHistoryJsonUtil;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;
import org.flowable.variable.api.types.VariableType;
import org.flowable.variable.api.types.VariableTypes;
import org.flowable.variable.service.HistoricVariableService;
import org.flowable.variable.service.impl.persistence.entity.HistoricVariableInstanceEntity;

public class VariableCreatedHistoryJsonTransformer
extends AbstractHistoryJsonTransformer {
    public VariableCreatedHistoryJsonTransformer(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    public List<String> getTypes() {
        return Collections.singletonList("variable-created");
    }

    public boolean isApplicable(ObjectNode historicalData, CommandContext commandContext) {
        return true;
    }

    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        HistoricVariableService historicVariableService = this.processEngineConfiguration.getVariableServiceConfiguration().getHistoricVariableService();
        HistoricVariableInstanceEntity historicVariableInstanceEntity = historicVariableService.createHistoricVariableInstance();
        historicVariableInstanceEntity.setId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"id"));
        historicVariableInstanceEntity.setProcessInstanceId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"processInstanceId"));
        historicVariableInstanceEntity.setExecutionId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"executionId"));
        historicVariableInstanceEntity.setTaskId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"taskId"));
        historicVariableInstanceEntity.setRevision(AsyncHistoryJsonUtil.getIntegerFromJson((ObjectNode)historicalData, (String)"revision").intValue());
        historicVariableInstanceEntity.setName(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"name"));
        historicVariableInstanceEntity.setScopeId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"scopeId"));
        historicVariableInstanceEntity.setSubScopeId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"subScopeId"));
        historicVariableInstanceEntity.setScopeType(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"scopeType"));
        VariableTypes variableTypes = this.processEngineConfiguration.getVariableTypes();
        VariableType variableType = variableTypes.getVariableType(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"variableType"));
        historicVariableInstanceEntity.setVariableType(variableType);
        historicVariableInstanceEntity.setTextValue(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"variableTextValue"));
        historicVariableInstanceEntity.setTextValue2(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"variableTextValue2"));
        historicVariableInstanceEntity.setDoubleValue(AsyncHistoryJsonUtil.getDoubleFromJson((ObjectNode)historicalData, (String)"variableDoubleValue"));
        historicVariableInstanceEntity.setLongValue(AsyncHistoryJsonUtil.getLongFromJson((ObjectNode)historicalData, (String)"variableLongValue"));
        String variableBytes = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"variableBytesValue");
        if (StringUtils.isNotEmpty((CharSequence)variableBytes)) {
            historicVariableInstanceEntity.setBytes(Base64.getDecoder().decode(variableBytes));
        }
        Date time = AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"createTime");
        historicVariableInstanceEntity.setCreateTime(time);
        historicVariableInstanceEntity.setLastUpdatedTime(time);
        historicVariableService.insertHistoricVariableInstance(historicVariableInstanceEntity);
    }
}

