/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.tenantdetector;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.eventregistry.api.InboundEventTenantDetector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XpathBasedInboundEventTenantDetector
implements InboundEventTenantDetector<Document> {
    protected String xpathExpression;

    public XpathBasedInboundEventTenantDetector(String xpathExpression) {
        this.xpathExpression = xpathExpression;
    }

    public String detectTenantId(Document document) {
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            Node result = (Node)xPath.compile(this.xpathExpression).evaluate(document, XPathConstants.NODE);
            return result.getTextContent();
        }
        catch (Exception e) {
            throw new FlowableException("Could not evaluate xpath expression ", (Throwable)e);
        }
    }

    public String getXpathExpression() {
        return this.xpathExpression;
    }

    public void setXpathExpression(String xpathExpression) {
        this.xpathExpression = xpathExpression;
    }
}

