package org.openmetadata.client.api;

import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;

import org.openmetadata.client.model.AlertAction;
import org.openmetadata.client.model.AlertActionList;
import org.openmetadata.client.model.CreateAlertAction;
import org.openmetadata.client.model.EntityHistory;
import java.util.UUID;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")public interface AlertActionApi extends ApiClient.Api {

  /**
   * Create new alert Action with Bulk
   * Create new alert Action with Bulk
   * @param body  (optional)
   * @return CreateAlertAction
   */
  @RequestLine("POST /v1/alertAction/bulk")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  CreateAlertAction bulkCreateAlertAction(List<CreateAlertAction> body);
  /**
   * Create a new alert Action
   * Create a new Alert Action
   * @param body  (optional)
   * @return CreateAlertAction
   */
  @RequestLine("POST /v1/alertAction")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  CreateAlertAction createAlertAction(CreateAlertAction body);
  /**
   * Updated an existing or create a new Alert Action
   * Updated an existing or create a new alert Action
   * @param body  (optional)
   * @return CreateAlertAction
   */
  @RequestLine("PUT /v1/alertAction")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  CreateAlertAction createOrUpdateAlertAction(CreateAlertAction body);
  /**
   * Delete a Alert Action
   * Get a alert action by given Id
   * @param id alert Id (required)
   * @return AlertAction
   */
  @RequestLine("DELETE /v1/alertAction/{id}")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  AlertAction deleteAlertAction(@Param("id") UUID id);
  /**
   * Delete an Alert Action
   * Delete an alert action by given &#x60;name&#x60;.
   * @param name Name of the alert (required)
   */
  @RequestLine("DELETE /v1/alertAction/name/{name}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteAlertActionByName(@Param("name") String name);
  /**
   * Get a alert action by name
   * Get a alert action by name.
   * @param name Name of the alert action (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return AlertAction
   */
  @RequestLine("GET /v1/alertAction/name/{name}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  AlertAction getAlertActionByFQN(@Param("name") String name, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a alert action by name
   * Get a alert action by name.
   * Note, this is equivalent to the other <code>getAlertActionByFQN</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetAlertActionByFQNQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param name Name of the alert action (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return AlertAction

   */
  @RequestLine("GET /v1/alertAction/name/{name}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  AlertAction getAlertActionByFQN(@Param("name") String name, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getAlertActionByFQN</code> method in a fluent style.
   */
  public static class GetAlertActionByFQNQueryParams extends HashMap<String, Object> {
    public GetAlertActionByFQNQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetAlertActionByFQNQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a alert alert action
   * Get a alert action by given Id
   * @param id alert Id (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return AlertAction
   */
  @RequestLine("GET /v1/alertAction/{id}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  AlertAction getAlertActionByID(@Param("id") UUID id, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a alert alert action
   * Get a alert action by given Id
   * Note, this is equivalent to the other <code>getAlertActionByID</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetAlertActionByIDQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id alert Id (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return AlertAction

   */
  @RequestLine("GET /v1/alertAction/{id}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  AlertAction getAlertActionByID(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getAlertActionByID</code> method in a fluent style.
   */
  public static class GetAlertActionByIDQueryParams extends HashMap<String, Object> {
    public GetAlertActionByIDQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetAlertActionByIDQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a version of the alert action
   * Get a version of the alert action by given &#x60;id&#x60;
   * @param id alert Id (required)
   * @param version alert version number in the form &#x60;major&#x60;.&#x60;minor&#x60; (required)
   * @return AlertAction
   */
  @RequestLine("GET /v1/alertAction/{id}/versions/{version}")
  @Headers({
      "Accept: application/json",
  })
  AlertAction getSpecificAlertActionVersion(@Param("id") UUID id, @Param("version") String version);
  /**
   * List all alerts actions
   * Get a list of all alert actions
   * @param fields Fields requested in the returned resource (optional)
   * @param alertActionType Filter alerts action by type (optional)
   * @param limit Limit the number alerts returned. (1 to 1000000, default &#x3D; 10)  (optional)
   * @param before Returns list of alerts before this cursor (optional)
   * @param after Returns list of alerts after this cursor (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return AlertActionList
   */
  @RequestLine("GET /v1/alertAction?fields={fields}&alertActionType={alertActionType}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  AlertActionList listAlertActions(@Param("fields") String fields, @Param("alertActionType") String alertActionType, @Param("limit") Integer limit, @Param("before") String before, @Param("after") String after, @Param("include") String include);

  /**
   * List all alerts actions
   * Get a list of all alert actions
   * Note, this is equivalent to the other <code>listAlertActions</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListAlertActionsQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>alertActionType - Filter alerts action by type (optional)</li>
   *   <li>limit - Limit the number alerts returned. (1 to 1000000, default &#x3D; 10)  (optional)</li>
   *   <li>before - Returns list of alerts before this cursor (optional)</li>
   *   <li>after - Returns list of alerts after this cursor (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return AlertActionList

   */
  @RequestLine("GET /v1/alertAction?fields={fields}&alertActionType={alertActionType}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  AlertActionList listAlertActions(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listAlertActions</code> method in a fluent style.
   */
  public static class ListAlertActionsQueryParams extends HashMap<String, Object> {
    public ListAlertActionsQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public ListAlertActionsQueryParams alertActionType(final String value) {
      put("alertActionType", EncodingUtils.encode(value));
      return this;
    }
    public ListAlertActionsQueryParams limit(final Integer value) {
      put("limit", EncodingUtils.encode(value));
      return this;
    }
    public ListAlertActionsQueryParams before(final String value) {
      put("before", EncodingUtils.encode(value));
      return this;
    }
    public ListAlertActionsQueryParams after(final String value) {
      put("after", EncodingUtils.encode(value));
      return this;
    }
    public ListAlertActionsQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * List alert versions
   * Get a list of all the versions of a alert action identified by &#x60;id&#x60;
   * @param id alert Id (required)
   * @return EntityHistory
   */
  @RequestLine("GET /v1/alertAction/{id}/versions")
  @Headers({
      "Accept: application/json",
  })
  EntityHistory listAllAlertVersion(@Param("id") String id);
  /**
   * Update a Alert Action
   * Update an existing alert using JsonPatch.
   * @param id  (required)
   * @param body JsonPatch with array of operations (optional)
   * JsonPatch RFC
   * @see <a href="https://tools.ietf.org/html/rfc6902">Update a Alert Action Documentation</a>
   */
  @RequestLine("PATCH /v1/alertAction/{id}")
  @Headers({
      "Content-Type: application/json-patch+json",
      "Accept: application/json",
  })
  void patchAlertAction(@Param("id") UUID id, Object body);
}
