package org.openmetadata.client.api;

import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;

import org.openmetadata.client.model.Alert;
import org.openmetadata.client.model.AlertActionStatus;
import org.openmetadata.client.model.AlertList;
import org.openmetadata.client.model.CreateAlert;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.EntitySpelFilters;
import org.openmetadata.client.model.Function;
import org.openmetadata.client.model.SettingsList;
import java.util.UUID;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")public interface AlertsApi extends ApiClient.Api {

  /**
   * Create a new Alert
   * Create a new Alert
   * @param body  (optional)
   * @return CreateAlert
   */
  @RequestLine("POST /v1/alerts")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  CreateAlert createAlert(CreateAlert body);
  /**
   * Updated an existing or create a new Alert
   * Updated an existing or create a new alert
   * @param body  (optional)
   * @return CreateAlert
   */
  @RequestLine("PUT /v1/alerts")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  CreateAlert createOrUpdateAlert(CreateAlert body);
  /**
   * List All Default Triggers Config
   * Get a List of all OpenMetadata Bootstrapped Alert Filters
   * @return SettingsList
   */
  @RequestLine("GET /v1/alerts/defaultTriggers")
  @Headers({
      "Accept: application/json",
  })
  SettingsList defaultTriggers();
  /**
   * Delete an Alert
   * Delete an Alert
   * @param id alert Id (required)
   * @return Alert
   */
  @RequestLine("DELETE /v1/alerts/{id}")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Alert deleteAlert(@Param("id") UUID id);
  /**
   * Delete an Alert
   * Delete an Alert by given &#x60;name&#x60;.
   * @param name Name of the alert (required)
   */
  @RequestLine("DELETE /v1/alerts/name/{name}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteAlertByName(@Param("name") String name);
  /**
   * Get alert Action status for an alert
   * Get a alert actions status by given Id , and id of the alert it is bound to
   * @param alertId alert Id (required)
   * @param actionId alertAction Id (required)
   * @return AlertActionStatus
   */
  @RequestLine("GET /v1/alerts/{alertId}/status/{actionId}")
  @Headers({
      "Accept: application/json",
  })
  AlertActionStatus getAlertActionStatus(@Param("alertId") UUID alertId, @Param("actionId") UUID actionId);
  /**
   * Get a alert by name
   * Get a alert by name.
   * @param name Name of the alert (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return Alert
   */
  @RequestLine("GET /v1/alerts/name/{name}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  Alert getAlertByFQN(@Param("name") String name, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a alert by name
   * Get a alert by name.
   * Note, this is equivalent to the other <code>getAlertByFQN</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetAlertByFQNQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param name Name of the alert (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return Alert

   */
  @RequestLine("GET /v1/alerts/name/{name}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  Alert getAlertByFQN(@Param("name") String name, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getAlertByFQN</code> method in a fluent style.
   */
  public static class GetAlertByFQNQueryParams extends HashMap<String, Object> {
    public GetAlertByFQNQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetAlertByFQNQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a alert
   * Get a alert by given Id
   * @param id alert Id (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return Alert
   */
  @RequestLine("GET /v1/alerts/{id}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  Alert getAlertByID(@Param("id") UUID id, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a alert
   * Get a alert by given Id
   * Note, this is equivalent to the other <code>getAlertByID</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetAlertByIDQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id alert Id (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return Alert

   */
  @RequestLine("GET /v1/alerts/{id}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  Alert getAlertByID(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getAlertByID</code> method in a fluent style.
   */
  public static class GetAlertByIDQueryParams extends HashMap<String, Object> {
    public GetAlertByIDQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetAlertByIDQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get all alert Action of an alert
   * Get all alert Action of alert by given Id , and id of the alert it is bound to
   * @param alertId alert Id (required)
   * @return AlertActionStatus
   */
  @RequestLine("GET /v1/alerts/allAlertAction/{alertId}")
  @Headers({
      "Accept: application/json",
  })
  AlertActionStatus getAllAlertActionForAlert(@Param("alertId") UUID alertId);
  /**
   * Get a version of the alert
   * Get a version of the alert by given &#x60;id&#x60;
   * @param id alert Id (required)
   * @param version alert version number in the form &#x60;major&#x60;.&#x60;minor&#x60; (required)
   * @return Alert
   */
  @RequestLine("GET /v1/alerts/{id}/versions/{version}")
  @Headers({
      "Accept: application/json",
  })
  Alert getSpecificAlertVersion(@Param("id") UUID id, @Param("version") String version);
  /**
   * Get list of Alert functions used in filtering alert.
   * Get list of Alert functions used in filtering conditions in alerts
   * @return List&lt;Function&gt;
   */
  @RequestLine("GET /v1/alerts/functions")
  @Headers({
      "Accept: application/json",
  })
  List<Function> listAlertFunctions();
  /**
   * Get list of Alert functions used in filtering alert.
   * Get list of Alert functions used in filtering conditions in alerts
   * @return Map&lt;String, EntitySpelFilters&gt;
   */
  @RequestLine("GET /v1/alerts/entityFunctions")
  @Headers({
      "Accept: application/json",
  })
  Map<String, EntitySpelFilters> listAlertFunctions1();
  /**
   * List alerts
   * Get a list of Alerts
   * @param fields Fields requested in the returned resource (optional)
   * @param limit Limit the number alerts returned. (1 to 1000000, default &#x3D; 10)  (optional)
   * @param before Returns list of alerts before this cursor (optional)
   * @param after Returns list of alerts after this cursor (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return AlertList
   */
  @RequestLine("GET /v1/alerts?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  AlertList listAlerts(@Param("fields") String fields, @Param("limit") Integer limit, @Param("before") String before, @Param("after") String after, @Param("include") String include);

  /**
   * List alerts
   * Get a list of Alerts
   * Note, this is equivalent to the other <code>listAlerts</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListAlertsQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>limit - Limit the number alerts returned. (1 to 1000000, default &#x3D; 10)  (optional)</li>
   *   <li>before - Returns list of alerts before this cursor (optional)</li>
   *   <li>after - Returns list of alerts after this cursor (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return AlertList

   */
  @RequestLine("GET /v1/alerts?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  AlertList listAlerts(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listAlerts</code> method in a fluent style.
   */
  public static class ListAlertsQueryParams extends HashMap<String, Object> {
    public ListAlertsQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public ListAlertsQueryParams limit(final Integer value) {
      put("limit", EncodingUtils.encode(value));
      return this;
    }
    public ListAlertsQueryParams before(final String value) {
      put("before", EncodingUtils.encode(value));
      return this;
    }
    public ListAlertsQueryParams after(final String value) {
      put("after", EncodingUtils.encode(value));
      return this;
    }
    public ListAlertsQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * List alert versions
   * Get a list of all the versions of a alert identified by &#x60;id&#x60;
   * @param id alert Id (required)
   * @return EntityHistory
   */
  @RequestLine("GET /v1/alerts/{id}/versions")
  @Headers({
      "Accept: application/json",
  })
  EntityHistory listAllAlertVersion1(@Param("id") String id);
  /**
   * Update a Alert
   * Update an existing alert using JsonPatch.
   * @param id  (required)
   * @param body JsonPatch with array of operations (optional)
   * JsonPatch RFC
   * @see <a href="https://tools.ietf.org/html/rfc6902">Update a Alert Documentation</a>
   */
  @RequestLine("PATCH /v1/alerts/{id}")
  @Headers({
      "Content-Type: application/json-patch+json",
      "Accept: application/json",
  })
  void patchAlert(@Param("id") UUID id, Object body);
}
