package org.openmetadata.client.api;

import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;

import org.openmetadata.client.model.Bot;
import org.openmetadata.client.model.BotList;
import org.openmetadata.client.model.CreateBot;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import java.util.UUID;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")public interface BotsApi extends ApiClient.Api {

  /**
   * Create a bot
   * Create a new bot.
   * @param body  (optional)
   * @return Bot
   */
  @RequestLine("POST /v1/bots")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Bot createBot(CreateBot body);
  /**
   * Create or update a bot
   * Create a bot, if it does not exist. If a bot already exists, update the bot.
   * @param body  (optional)
   * @return Bot
   */
  @RequestLine("PUT /v1/bots")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Bot createOrUpdateBot(CreateBot body);
  /**
   * Delete a bot
   * Delete a bot by &#x60;id&#x60;.
   * @param id Id of the Bot (required)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/bots/{id}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteBot(@Param("id") UUID id, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a bot
   * Delete a bot by &#x60;id&#x60;.
   * Note, this is equivalent to the other <code>deleteBot</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteBotQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id Id of the Bot (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/bots/{id}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteBot(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteBot</code> method in a fluent style.
   */
  public static class DeleteBotQueryParams extends HashMap<String, Object> {
    public DeleteBotQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Delete a bot
   * Delete a bot by &#x60;fullyQualifiedName&#x60;.
   * @param fqn Name of the Bot (required)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/bots/name/{fqn}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteBotByFQN(@Param("fqn") String fqn, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a bot
   * Delete a bot by &#x60;fullyQualifiedName&#x60;.
   * Note, this is equivalent to the other <code>deleteBotByFQN</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteBotByFQNQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param fqn Name of the Bot (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/bots/name/{fqn}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteBotByFQN(@Param("fqn") String fqn, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteBotByFQN</code> method in a fluent style.
   */
  public static class DeleteBotByFQNQueryParams extends HashMap<String, Object> {
    public DeleteBotByFQNQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a bot by name
   * Get a bot by name.
   * @param fqn Fully qualified name of the table (required)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return Bot
   */
  @RequestLine("GET /v1/bots/name/{fqn}?include={include}")
  @Headers({
      "Accept: application/json",
  })
  Bot getBotByFQN(@Param("fqn") String fqn, @Param("include") String include);

  /**
   * Get a bot by name
   * Get a bot by name.
   * Note, this is equivalent to the other <code>getBotByFQN</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetBotByFQNQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param fqn Fully qualified name of the table (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return Bot

   */
  @RequestLine("GET /v1/bots/name/{fqn}?include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  Bot getBotByFQN(@Param("fqn") String fqn, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getBotByFQN</code> method in a fluent style.
   */
  public static class GetBotByFQNQueryParams extends HashMap<String, Object> {
    public GetBotByFQNQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a bot
   * Get a bot by &#x60;id&#x60;.
   * @param id  (required)
   * @param include  (optional)
   * @return Bot
   */
  @RequestLine("GET /v1/bots/{id}?include={include}")
  @Headers({
      "Accept: application/json",
  })
  Bot getBotByID(@Param("id") UUID id, @Param("include") String include);

  /**
   * Get a bot
   * Get a bot by &#x60;id&#x60;.
   * Note, this is equivalent to the other <code>getBotByID</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetBotByIDQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>include -  (optional)</li>
   *   </ul>
   * @return Bot

   */
  @RequestLine("GET /v1/bots/{id}?include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  Bot getBotByID(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getBotByID</code> method in a fluent style.
   */
  public static class GetBotByIDQueryParams extends HashMap<String, Object> {
    public GetBotByIDQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * List bot versions
   * Get a list of all the versions of a bot identified by &#x60;id&#x60;
   * @param id bot Id (required)
   * @return EntityHistory
   */
  @RequestLine("GET /v1/bots/{id}/versions")
  @Headers({
      "Accept: application/json",
  })
  EntityHistory listAllBotVersion(@Param("id") UUID id);
  /**
   * List Bot
   * Get a list of Bot.
   * @param limit  (optional)
   * @param before Returns list of Bot before this cursor (optional)
   * @param after Returns list of Bot after this cursor (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return BotList
   */
  @RequestLine("GET /v1/bots?limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  BotList listBots(@Param("limit") Integer limit, @Param("before") String before, @Param("after") String after, @Param("include") String include);

  /**
   * List Bot
   * Get a list of Bot.
   * Note, this is equivalent to the other <code>listBots</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListBotsQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>limit -  (optional)</li>
   *   <li>before - Returns list of Bot before this cursor (optional)</li>
   *   <li>after - Returns list of Bot after this cursor (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return BotList

   */
  @RequestLine("GET /v1/bots?limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  BotList listBots(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listBots</code> method in a fluent style.
   */
  public static class ListBotsQueryParams extends HashMap<String, Object> {
    public ListBotsQueryParams limit(final Integer value) {
      put("limit", EncodingUtils.encode(value));
      return this;
    }
    public ListBotsQueryParams before(final String value) {
      put("before", EncodingUtils.encode(value));
      return this;
    }
    public ListBotsQueryParams after(final String value) {
      put("after", EncodingUtils.encode(value));
      return this;
    }
    public ListBotsQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a version of the bot
   * Get a version of the bot by given &#x60;id&#x60;
   * @param id bot Id (required)
   * @param version bot version number in the form &#x60;major&#x60;.&#x60;minor&#x60; (required)
   * @return Bot
   */
  @RequestLine("GET /v1/bots/{id}/versions/{version}")
  @Headers({
      "Accept: application/json",
  })
  Bot listSpecificBotVersion(@Param("id") String id, @Param("version") String version);
  /**
   * Update a bot
   * Update an existing bot using JsonPatch.
   * @param id Id of the bot (required)
   * @param body JsonPatch with array of operations (optional)
   * JsonPatch RFC
   * @see <a href="https://tools.ietf.org/html/rfc6902">Update a bot Documentation</a>
   */
  @RequestLine("PATCH /v1/bots/{id}")
  @Headers({
      "Content-Type: application/json-patch+json",
      "Accept: application/json",
  })
  void patchBot(@Param("id") String id, Object body);
  /**
   * Restore a soft deleted bot.
   * Restore a soft deleted bot.
   * @param body  (optional)
   * @return Bot
   */
  @RequestLine("PUT /v1/bots/restore")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Bot restore1(RestoreEntity body);
}
