package org.openmetadata.client.api;

import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;

import org.openmetadata.client.model.AirflowConfigurationForAPI;
import org.openmetadata.client.model.AuthenticationConfiguration;
import org.openmetadata.client.model.AuthorizerConfiguration;
import org.openmetadata.client.model.JWKSResponse;
import org.openmetadata.client.model.SandboxConfiguration;
import org.openmetadata.client.model.SlackChatConfiguration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")public interface ConfigApi extends ApiClient.Api {

  /**
   * Get airflow configuration
   * 
   * @return AirflowConfigurationForAPI
   */
  @RequestLine("GET /v1/config/airflow")
  @Headers({
      "Accept: application/json",
  })
  AirflowConfigurationForAPI getAirflowConfiguration();
  /**
   * Get auth configuration
   * 
   * @return AuthenticationConfiguration
   */
  @RequestLine("GET /v1/config/auth")
  @Headers({
      "Accept: application/json",
  })
  AuthenticationConfiguration getAuthConfiguration();
  /**
   * Get authorizer configuration
   * 
   * @return AuthorizerConfiguration
   */
  @RequestLine("GET /v1/config/authorizer")
  @Headers({
      "Accept: application/json",
  })
  AuthorizerConfiguration getAuthorizerConfig();
  /**
   * Get JWKS public key
   * 
   * @return JWKSResponse
   */
  @RequestLine("GET /v1/config/jwks")
  @Headers({
      "Accept: application/json",
  })
  JWKSResponse getJWKSResponse();
  /**
   * Get sandbox mode
   * 
   * @return SandboxConfiguration
   */
  @RequestLine("GET /v1/config/sandbox")
  @Headers({
      "Accept: application/json",
  })
  SandboxConfiguration getSandboxConfiguration();
  /**
   * Get Slack Chat Configuration
   * 
   * @return SlackChatConfiguration
   */
  @RequestLine("GET /v1/config/slackChat")
  @Headers({
      "Accept: application/json",
  })
  SlackChatConfiguration getSlackChatConfiguration();
}
