package org.openmetadata.client.api;

import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;

import org.openmetadata.client.model.CreateDashboardService;
import org.openmetadata.client.model.DashboardService;
import org.openmetadata.client.model.DashboardServiceList;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import java.util.UUID;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")public interface DashboardServicesApi extends ApiClient.Api {

  /**
   * Create a dashboard service
   * Create a new dashboard service.
   * @param body  (optional)
   * @return DashboardService
   */
  @RequestLine("POST /v1/services/dashboardServices")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  DashboardService createDashboardService(CreateDashboardService body);
  /**
   * Update a Dashboard service
   * Update an existing dashboard service identified by &#x60;id&#x60;.
   * @param body  (optional)
   * @return DashboardService
   */
  @RequestLine("PUT /v1/services/dashboardServices")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  DashboardService createOrUpdateDashboardService(CreateDashboardService body);
  /**
   * Delete a Dashboard service
   * Delete a Dashboard services. If dashboard (and charts) belong to the service, it can&#x27;t be deleted.
   * @param id Id of the dashboard service (required)
   * @param recursive Recursively delete this entity and it&#x27;s children. (Default &#x60;false&#x60;) (optional)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/services/dashboardServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteDashboardService(@Param("id") UUID id, @Param("recursive") Boolean recursive, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a Dashboard service
   * Delete a Dashboard services. If dashboard (and charts) belong to the service, it can&#x27;t be deleted.
   * Note, this is equivalent to the other <code>deleteDashboardService</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteDashboardServiceQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id Id of the dashboard service (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>recursive - Recursively delete this entity and it&#x27;s children. (Default &#x60;false&#x60;) (optional)</li>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/services/dashboardServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteDashboardService(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteDashboardService</code> method in a fluent style.
   */
  public static class DeleteDashboardServiceQueryParams extends HashMap<String, Object> {
    public DeleteDashboardServiceQueryParams recursive(final Boolean value) {
      put("recursive", EncodingUtils.encode(value));
      return this;
    }
    public DeleteDashboardServiceQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Delete a Dashboard service
   * Delete a Dashboard services by &#x60;name&#x60;. If dashboard (and charts) belong to the service, it can&#x27;t be deleted.
   * @param name Name of the table (required)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/services/dashboardServices/name/{name}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteDashboardServiceByName(@Param("name") String name, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a Dashboard service
   * Delete a Dashboard services by &#x60;name&#x60;. If dashboard (and charts) belong to the service, it can&#x27;t be deleted.
   * Note, this is equivalent to the other <code>deleteDashboardServiceByName</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteDashboardServiceByNameQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param name Name of the table (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/services/dashboardServices/name/{name}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteDashboardServiceByName(@Param("name") String name, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteDashboardServiceByName</code> method in a fluent style.
   */
  public static class DeleteDashboardServiceByNameQueryParams extends HashMap<String, Object> {
    public DeleteDashboardServiceByNameQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get dashboard service by name
   * Get a dashboard service by the service &#x60;name&#x60;.
   * @param name  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return DashboardService
   */
  @RequestLine("GET /v1/services/dashboardServices/name/{name}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  DashboardService getDashboardServiceByFQN(@Param("name") String name, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get dashboard service by name
   * Get a dashboard service by the service &#x60;name&#x60;.
   * Note, this is equivalent to the other <code>getDashboardServiceByFQN</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetDashboardServiceByFQNQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param name  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return DashboardService

   */
  @RequestLine("GET /v1/services/dashboardServices/name/{name}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  DashboardService getDashboardServiceByFQN(@Param("name") String name, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getDashboardServiceByFQN</code> method in a fluent style.
   */
  public static class GetDashboardServiceByFQNQueryParams extends HashMap<String, Object> {
    public GetDashboardServiceByFQNQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetDashboardServiceByFQNQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a dashboard service
   * Get a dashboard service by &#x60;id&#x60;.
   * @param id  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return DashboardService
   */
  @RequestLine("GET /v1/services/dashboardServices/{id}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  DashboardService getDashboardServiceByID(@Param("id") UUID id, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a dashboard service
   * Get a dashboard service by &#x60;id&#x60;.
   * Note, this is equivalent to the other <code>getDashboardServiceByID</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetDashboardServiceByIDQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return DashboardService

   */
  @RequestLine("GET /v1/services/dashboardServices/{id}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  DashboardService getDashboardServiceByID(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getDashboardServiceByID</code> method in a fluent style.
   */
  public static class GetDashboardServiceByIDQueryParams extends HashMap<String, Object> {
    public GetDashboardServiceByIDQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetDashboardServiceByIDQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a version of the dashboard service
   * Get a version of the dashboard service by given &#x60;id&#x60;
   * @param id dashboard service Id (required)
   * @param version dashboard service version number in the form &#x60;major&#x60;.&#x60;minor&#x60; (required)
   * @return DashboardService
   */
  @RequestLine("GET /v1/services/dashboardServices/{id}/versions/{version}")
  @Headers({
      "Accept: application/json",
  })
  DashboardService getSpecificDashboardServiceVersion(@Param("id") UUID id, @Param("version") String version);
  /**
   * List dashboard service versions
   * Get a list of all the versions of a dashboard service identified by &#x60;id&#x60;
   * @param id dashboard service Id (required)
   * @return EntityHistory
   */
  @RequestLine("GET /v1/services/dashboardServices/{id}/versions")
  @Headers({
      "Accept: application/json",
  })
  EntityHistory listAllDashboardServiceVersion(@Param("id") String id);
  /**
   * List dashboard services
   * Get a list of dashboard services.
   * @param name  (optional)
   * @param fields Fields requested in the returned resource (optional)
   * @param limit  (optional)
   * @param before Returns list of dashboard services before this cursor (optional)
   * @param after Returns list of dashboard services after this cursor (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return DashboardServiceList
   */
  @RequestLine("GET /v1/services/dashboardServices?name={name}&fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  DashboardServiceList listDashboardsService(@Param("name") String name, @Param("fields") String fields, @Param("limit") Integer limit, @Param("before") String before, @Param("after") String after, @Param("include") String include);

  /**
   * List dashboard services
   * Get a list of dashboard services.
   * Note, this is equivalent to the other <code>listDashboardsService</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListDashboardsServiceQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>name -  (optional)</li>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>limit -  (optional)</li>
   *   <li>before - Returns list of dashboard services before this cursor (optional)</li>
   *   <li>after - Returns list of dashboard services after this cursor (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return DashboardServiceList

   */
  @RequestLine("GET /v1/services/dashboardServices?name={name}&fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  DashboardServiceList listDashboardsService(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listDashboardsService</code> method in a fluent style.
   */
  public static class ListDashboardsServiceQueryParams extends HashMap<String, Object> {
    public ListDashboardsServiceQueryParams name(final String value) {
      put("name", EncodingUtils.encode(value));
      return this;
    }
    public ListDashboardsServiceQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public ListDashboardsServiceQueryParams limit(final Integer value) {
      put("limit", EncodingUtils.encode(value));
      return this;
    }
    public ListDashboardsServiceQueryParams before(final String value) {
      put("before", EncodingUtils.encode(value));
      return this;
    }
    public ListDashboardsServiceQueryParams after(final String value) {
      put("after", EncodingUtils.encode(value));
      return this;
    }
    public ListDashboardsServiceQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Update a dashboard service
   * Update an existing dashboard service using JsonPatch.
   * @param id  (required)
   * @param body JsonPatch with array of operations (optional)
   * JsonPatch RFC
   * @see <a href="https://tools.ietf.org/html/rfc6902">Update a dashboard service Documentation</a>
   */
  @RequestLine("PATCH /v1/services/dashboardServices/{id}")
  @Headers({
      "Content-Type: application/json-patch+json",
      "Accept: application/json",
  })
  void patchDashboardService(@Param("id") UUID id, Object body);
  /**
   * Restore a soft deleted DashboardService.
   * Restore a soft deleted DashboardService.
   * @param body  (optional)
   * @return DashboardService
   */
  @RequestLine("PUT /v1/services/dashboardServices/restore")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  DashboardService restore18(RestoreEntity body);
}
