package org.openmetadata.client.api;

import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;

import java.math.BigDecimal;
import org.openmetadata.client.model.CreateDataInsightChart;
import org.openmetadata.client.model.DataInsightChart;
import org.openmetadata.client.model.DataInsightChartList;
import org.openmetadata.client.model.DataInsightChartResultList;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import java.util.UUID;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")public interface DataInsightApi extends ApiClient.Api {

  /**
   * Create a Data Insight Chart
   * Create a Data Insight Chart.
   * @param body  (optional)
   * @return DataInsightChart
   */
  @RequestLine("POST /v1/dataInsight")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  DataInsightChart createDataInsightChart(CreateDataInsightChart body);
  /**
   * Update data insight chart
   * Create a data insight chart, if it does not exist or update an existing data insight chart.
   * @param body  (optional)
   * @return DataInsightChart
   */
  @RequestLine("PUT /v1/dataInsight")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  DataInsightChart createOrUpdateDataInsightChart(CreateDataInsightChart body);
  /**
   * Delete a data insight chart
   * Delete a data insight chart by &#x60;id&#x60;.
   * @param id Data Insight Chart Id (required)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/dataInsight/{id}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteDataInsightChart(@Param("id") UUID id, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a data insight chart
   * Delete a data insight chart by &#x60;id&#x60;.
   * Note, this is equivalent to the other <code>deleteDataInsightChart</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteDataInsightChartQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id Data Insight Chart Id (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/dataInsight/{id}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteDataInsightChart(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteDataInsightChart</code> method in a fluent style.
   */
  public static class DeleteDataInsightChartQueryParams extends HashMap<String, Object> {
    public DeleteDataInsightChartQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Delete a data insight chart
   * Delete a data insight chart by &#x60;name&#x60;.
   * @param name Name of the Data Insight Chart (required)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/dataInsight/name/{name}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteDataInsightChartByName(@Param("name") String name, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a data insight chart
   * Delete a data insight chart by &#x60;name&#x60;.
   * Note, this is equivalent to the other <code>deleteDataInsightChartByName</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteDataInsightChartByNameQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param name Name of the Data Insight Chart (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/dataInsight/name/{name}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteDataInsightChartByName(@Param("name") String name, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteDataInsightChartByName</code> method in a fluent style.
   */
  public static class DeleteDataInsightChartByNameQueryParams extends HashMap<String, Object> {
    public DeleteDataInsightChartByNameQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a data insight chart by name
   * Get a data insight chart by &#x60;name&#x60;.
   * @param name  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return DataInsightChart
   */
  @RequestLine("GET /v1/dataInsight/name/{name}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  DataInsightChart getDataInsightChartByName(@Param("name") String name, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a data insight chart by name
   * Get a data insight chart by &#x60;name&#x60;.
   * Note, this is equivalent to the other <code>getDataInsightChartByName</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetDataInsightChartByNameQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param name  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return DataInsightChart

   */
  @RequestLine("GET /v1/dataInsight/name/{name}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  DataInsightChart getDataInsightChartByName(@Param("name") String name, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getDataInsightChartByName</code> method in a fluent style.
   */
  public static class GetDataInsightChartByNameQueryParams extends HashMap<String, Object> {
    public GetDataInsightChartByNameQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetDataInsightChartByNameQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get aggregated data for a data insight chart
   * Get aggregated data for a data insight chart.
   * @param dataInsightChartName Get aggregated data for a specific chart name (optional)
   * @param dataReportIndex Specify the elasticsearch index to fetch data from (optional)
   * @param tier Tier filter. The value will be used to filter results (optional)
   * @param team Team filter. The value will be used to filter results (optional)
   * @param organization Organization filter. The value will be used to filter results (optional)
   * @param startTs Filter after the given start timestamp (optional)
   * @param endTs Filter before the given end timestamp (optional)
   * @return DataInsightChartResultList
   */
  @RequestLine("GET /v1/dataInsight/aggregate?dataInsightChartName={dataInsightChartName}&dataReportIndex={dataReportIndex}&tier={tier}&team={team}&organization={organization}&startTs={startTs}&endTs={endTs}")
  @Headers({
      "Accept: application/json",
  })
  DataInsightChartResultList getDataInsightChartResults(@Param("dataInsightChartName") String dataInsightChartName, @Param("dataReportIndex") String dataReportIndex, @Param("tier") String tier, @Param("team") String team, @Param("organization") String organization, @Param("startTs") BigDecimal startTs, @Param("endTs") BigDecimal endTs);

  /**
   * Get aggregated data for a data insight chart
   * Get aggregated data for a data insight chart.
   * Note, this is equivalent to the other <code>getDataInsightChartResults</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetDataInsightChartResultsQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>dataInsightChartName - Get aggregated data for a specific chart name (optional)</li>
   *   <li>dataReportIndex - Specify the elasticsearch index to fetch data from (optional)</li>
   *   <li>tier - Tier filter. The value will be used to filter results (optional)</li>
   *   <li>team - Team filter. The value will be used to filter results (optional)</li>
   *   <li>organization - Organization filter. The value will be used to filter results (optional)</li>
   *   <li>startTs - Filter after the given start timestamp (optional)</li>
   *   <li>endTs - Filter before the given end timestamp (optional)</li>
   *   </ul>
   * @return DataInsightChartResultList

   */
  @RequestLine("GET /v1/dataInsight/aggregate?dataInsightChartName={dataInsightChartName}&dataReportIndex={dataReportIndex}&tier={tier}&team={team}&organization={organization}&startTs={startTs}&endTs={endTs}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  DataInsightChartResultList getDataInsightChartResults(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getDataInsightChartResults</code> method in a fluent style.
   */
  public static class GetDataInsightChartResultsQueryParams extends HashMap<String, Object> {
    public GetDataInsightChartResultsQueryParams dataInsightChartName(final String value) {
      put("dataInsightChartName", EncodingUtils.encode(value));
      return this;
    }
    public GetDataInsightChartResultsQueryParams dataReportIndex(final String value) {
      put("dataReportIndex", EncodingUtils.encode(value));
      return this;
    }
    public GetDataInsightChartResultsQueryParams tier(final String value) {
      put("tier", EncodingUtils.encode(value));
      return this;
    }
    public GetDataInsightChartResultsQueryParams team(final String value) {
      put("team", EncodingUtils.encode(value));
      return this;
    }
    public GetDataInsightChartResultsQueryParams organization(final String value) {
      put("organization", EncodingUtils.encode(value));
      return this;
    }
    public GetDataInsightChartResultsQueryParams startTs(final BigDecimal value) {
      put("startTs", EncodingUtils.encode(value));
      return this;
    }
    public GetDataInsightChartResultsQueryParams endTs(final BigDecimal value) {
      put("endTs", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a version of the DataInsight
   * Get a version of the data insight by given &#x60;id&#x60;
   * @param id Data Insight Chart Id (required)
   * @param version Data Insight Chart version number in the form &#x60;major&#x60;.&#x60;minor&#x60; (required)
   * @return DataInsightChart
   */
  @RequestLine("GET /v1/dataInsight/{id}/versions/{version}")
  @Headers({
      "Accept: application/json",
  })
  DataInsightChart getSpecificDataInsightChartVersion(@Param("id") String id, @Param("version") String version);
  /**
   * List data charts
   * Get a list of data insight charts
   * @param fields Fields requested in the returned resource (optional)
   * @param limit Limit the number data insight chart returned. (1 to 1000000, default &#x3D; 10) (optional)
   * @param before Returns list of data insight chart before this cursor (optional)
   * @param after Returns list of data insight chart after this cursor (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return DataInsightChartList
   */
  @RequestLine("GET /v1/dataInsight?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  DataInsightChartList listDataInsightChart(@Param("fields") String fields, @Param("limit") Integer limit, @Param("before") String before, @Param("after") String after, @Param("include") String include);

  /**
   * List data charts
   * Get a list of data insight charts
   * Note, this is equivalent to the other <code>listDataInsightChart</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListDataInsightChartQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>limit - Limit the number data insight chart returned. (1 to 1000000, default &#x3D; 10) (optional)</li>
   *   <li>before - Returns list of data insight chart before this cursor (optional)</li>
   *   <li>after - Returns list of data insight chart after this cursor (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return DataInsightChartList

   */
  @RequestLine("GET /v1/dataInsight?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  DataInsightChartList listDataInsightChart(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listDataInsightChart</code> method in a fluent style.
   */
  public static class ListDataInsightChartQueryParams extends HashMap<String, Object> {
    public ListDataInsightChartQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public ListDataInsightChartQueryParams limit(final Integer value) {
      put("limit", EncodingUtils.encode(value));
      return this;
    }
    public ListDataInsightChartQueryParams before(final String value) {
      put("before", EncodingUtils.encode(value));
      return this;
    }
    public ListDataInsightChartQueryParams after(final String value) {
      put("after", EncodingUtils.encode(value));
      return this;
    }
    public ListDataInsightChartQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a Data Insight Chart
   * Get a Data Insight Chart by &#x60;id&#x60;.
   * @param id  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return DataInsightChart
   */
  @RequestLine("GET /v1/dataInsight/{id}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  DataInsightChart listDataInsightChartId(@Param("id") UUID id, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a Data Insight Chart
   * Get a Data Insight Chart by &#x60;id&#x60;.
   * Note, this is equivalent to the other <code>listDataInsightChartId</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListDataInsightChartIdQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return DataInsightChart

   */
  @RequestLine("GET /v1/dataInsight/{id}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  DataInsightChart listDataInsightChartId(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listDataInsightChartId</code> method in a fluent style.
   */
  public static class ListDataInsightChartIdQueryParams extends HashMap<String, Object> {
    public ListDataInsightChartIdQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public ListDataInsightChartIdQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * List data insight chart versions
   * Get a list of all the versions of a data insight chart identified by &#x60;id&#x60;
   * @param id Data Inisght chart Id (required)
   * @return EntityHistory
   */
  @RequestLine("GET /v1/dataInsight/{id}/versions")
  @Headers({
      "Accept: application/json",
  })
  EntityHistory listDataInsightChartVersion(@Param("id") String id);
  /**
   * Update a data insight chart
   * Update an existing data insight chart using JsonPatch.
   * @param id  (required)
   * @param body JsonPatch with array of operations (optional)
   * JsonPatch RFC
   * @see <a href="https://tools.ietf.org/html/rfc6902">Update a data insight chart Documentation</a>
   */
  @RequestLine("PATCH /v1/dataInsight/{id}")
  @Headers({
      "Content-Type: application/json-patch+json",
      "Accept: application/json",
  })
  void patchDataInsightChart(@Param("id") UUID id, Object body);
  /**
   * Restore a soft deleted DataInsightChart.
   * Restore a soft deleted DataInsightChart.
   * @param body  (optional)
   * @return DataInsightChart
   */
  @RequestLine("PUT /v1/dataInsight/restore")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  DataInsightChart restore4(RestoreEntity body);
}
