package org.openmetadata.client.api;

import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;


import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")public interface DatabasesSchemasApi extends ApiClient.Api {

  /**
   * Delete a schema
   * Delete a schema by &#x60;fullyQualifiedName&#x60;. Schema can only be deleted if it has no tables.
   * @param fqn Name of the DBSchema (required)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/databaseSchemas/name/{fqn}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteDBSchemaByFQN(@Param("fqn") String fqn, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a schema
   * Delete a schema by &#x60;fullyQualifiedName&#x60;. Schema can only be deleted if it has no tables.
   * Note, this is equivalent to the other <code>deleteDBSchemaByFQN</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteDBSchemaByFQNQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param fqn Name of the DBSchema (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/databaseSchemas/name/{fqn}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteDBSchemaByFQN(@Param("fqn") String fqn, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteDBSchemaByFQN</code> method in a fluent style.
   */
  public static class DeleteDBSchemaByFQNQueryParams extends HashMap<String, Object> {
    public DeleteDBSchemaByFQNQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
}
