package org.openmetadata.client.api;

import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;

import org.openmetadata.client.model.ChangeEventList;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")public interface EventsApi extends ApiClient.Api {

  /**
   * Get change events
   * Get a list of change events matching event types, entity type, from a given date
   * @param timestamp Events starting from this unix timestamp in milliseconds (required)
   * @param entityCreated List of comma separated entities requested for &#x60;entityCreated&#x60; event. When set to &#x60;*&#x60; all entities will be returned (optional)
   * @param entityUpdated List of comma separated entities requested for &#x60;entityCreated&#x60; event. When set to &#x60;*&#x60; all entities will be returned (optional)
   * @param entityDeleted List of comma separated entities requested for &#x60;entityCreated&#x60; event. When set to &#x60;*&#x60; all entities will be returned (optional)
   * @return ChangeEventList
   */
  @RequestLine("GET /v1/events?entityCreated={entityCreated}&entityUpdated={entityUpdated}&entityDeleted={entityDeleted}&timestamp={timestamp}")
  @Headers({
      "Accept: application/json",
  })
  ChangeEventList listChangeEvents(@Param("timestamp") Long timestamp, @Param("entityCreated") String entityCreated, @Param("entityUpdated") String entityUpdated, @Param("entityDeleted") String entityDeleted);

  /**
   * Get change events
   * Get a list of change events matching event types, entity type, from a given date
   * Note, this is equivalent to the other <code>listChangeEvents</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListChangeEventsQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>entityCreated - List of comma separated entities requested for &#x60;entityCreated&#x60; event. When set to &#x60;*&#x60; all entities will be returned (optional)</li>
   *   <li>entityUpdated - List of comma separated entities requested for &#x60;entityCreated&#x60; event. When set to &#x60;*&#x60; all entities will be returned (optional)</li>
   *   <li>entityDeleted - List of comma separated entities requested for &#x60;entityCreated&#x60; event. When set to &#x60;*&#x60; all entities will be returned (optional)</li>
   *   <li>timestamp - Events starting from this unix timestamp in milliseconds (required)</li>
   *   </ul>
   * @return ChangeEventList

   */
  @RequestLine("GET /v1/events?entityCreated={entityCreated}&entityUpdated={entityUpdated}&entityDeleted={entityDeleted}&timestamp={timestamp}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  ChangeEventList listChangeEvents(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listChangeEvents</code> method in a fluent style.
   */
  public static class ListChangeEventsQueryParams extends HashMap<String, Object> {
    public ListChangeEventsQueryParams entityCreated(final String value) {
      put("entityCreated", EncodingUtils.encode(value));
      return this;
    }
    public ListChangeEventsQueryParams entityUpdated(final String value) {
      put("entityUpdated", EncodingUtils.encode(value));
      return this;
    }
    public ListChangeEventsQueryParams entityDeleted(final String value) {
      put("entityDeleted", EncodingUtils.encode(value));
      return this;
    }
    public ListChangeEventsQueryParams timestamp(final Long value) {
      put("timestamp", EncodingUtils.encode(value));
      return this;
    }
  }
}
