package org.openmetadata.client.api;

import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;

import org.openmetadata.client.model.Classification;
import org.openmetadata.client.model.CreateGlossary;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.Glossary;
import org.openmetadata.client.model.GlossaryList;
import org.openmetadata.client.model.GlossaryTermList;
import org.openmetadata.client.model.RestoreEntity;
import java.util.UUID;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")public interface GlossariesApi extends ApiClient.Api {

  /**
   * Create a glossary
   * Create a new glossary.
   * @param body  (optional)
   * @return Glossary
   */
  @RequestLine("POST /v1/glossaries")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Glossary createGlossary(CreateGlossary body);
  /**
   * Create or update a glossary
   * Create a new glossary, if it does not exist or update an existing glossary.
   * @param body  (optional)
   * @return Glossary
   */
  @RequestLine("PUT /v1/glossaries")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Glossary createOrUpdateGlossary(CreateGlossary body);
  /**
   * Delete a Glossary
   * Delete a glossary by &#x60;id&#x60;.
   * @param id Glossary Id (required)
   * @param recursive Recursively delete this entity and it&#x27;s children. (Default &#x60;false&#x60;) (optional)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/glossaries/{id}?recursive={recursive}&hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteGlossary(@Param("id") UUID id, @Param("recursive") Boolean recursive, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a Glossary
   * Delete a glossary by &#x60;id&#x60;.
   * Note, this is equivalent to the other <code>deleteGlossary</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteGlossaryQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id Glossary Id (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>recursive - Recursively delete this entity and it&#x27;s children. (Default &#x60;false&#x60;) (optional)</li>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/glossaries/{id}?recursive={recursive}&hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteGlossary(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteGlossary</code> method in a fluent style.
   */
  public static class DeleteGlossaryQueryParams extends HashMap<String, Object> {
    public DeleteGlossaryQueryParams recursive(final Boolean value) {
      put("recursive", EncodingUtils.encode(value));
      return this;
    }
    public DeleteGlossaryQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Delete a Glossary
   * Delete a glossary by &#x60;name&#x60;.
   * @param name Name of the Glossary (required)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/glossaries/name/{name}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteGlossaryByName(@Param("name") String name, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a Glossary
   * Delete a glossary by &#x60;name&#x60;.
   * Note, this is equivalent to the other <code>deleteGlossaryByName</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteGlossaryByNameQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param name Name of the Glossary (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/glossaries/name/{name}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteGlossaryByName(@Param("name") String name, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteGlossaryByName</code> method in a fluent style.
   */
  public static class DeleteGlossaryByNameQueryParams extends HashMap<String, Object> {
    public DeleteGlossaryByNameQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Export glossary in CSV format
   * 
   * @param name  (required)
   * @return GlossaryTermList
   */
  @RequestLine("GET /v1/glossaries/name/{name}/export")
  @Headers({
      "Accept: application/json",
  })
  GlossaryTermList exportGlossary(@Param("name") String name);
  /**
   * Get a glossary by name
   * Get a glossary by name.
   * @param name  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return Glossary
   */
  @RequestLine("GET /v1/glossaries/name/{name}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  Glossary getGlossaryByFQN(@Param("name") String name, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a glossary by name
   * Get a glossary by name.
   * Note, this is equivalent to the other <code>getGlossaryByFQN</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetGlossaryByFQNQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param name  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return Glossary

   */
  @RequestLine("GET /v1/glossaries/name/{name}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  Glossary getGlossaryByFQN(@Param("name") String name, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getGlossaryByFQN</code> method in a fluent style.
   */
  public static class GetGlossaryByFQNQueryParams extends HashMap<String, Object> {
    public GetGlossaryByFQNQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetGlossaryByFQNQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a glossary
   * Get a glossary by &#x60;id&#x60;.
   * @param id  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return Glossary
   */
  @RequestLine("GET /v1/glossaries/{id}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  Glossary getGlossaryByID(@Param("id") UUID id, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a glossary
   * Get a glossary by &#x60;id&#x60;.
   * Note, this is equivalent to the other <code>getGlossaryByID</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetGlossaryByIDQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return Glossary

   */
  @RequestLine("GET /v1/glossaries/{id}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  Glossary getGlossaryByID(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getGlossaryByID</code> method in a fluent style.
   */
  public static class GetGlossaryByIDQueryParams extends HashMap<String, Object> {
    public GetGlossaryByIDQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetGlossaryByIDQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a version of the classification
   * Get a version of the classification by given &#x60;id&#x60;
   * @param id classification Id (required)
   * @param version classification version number in the form &#x60;major&#x60;.&#x60;minor&#x60; (required)
   * @return Classification
   */
  @RequestLine("GET /v1/classifications/{id}/versions/{version}")
  @Headers({
      "Accept: application/json",
  })
  Classification getSpecificClassificationVersion(@Param("id") UUID id, @Param("version") String version);
  /**
   * Get a version of the glossaries
   * Get a version of the glossary by given &#x60;id&#x60;
   * @param id glossary Id (required)
   * @param version glossary version number in the form &#x60;major&#x60;.&#x60;minor&#x60; (required)
   * @return Glossary
   */
  @RequestLine("GET /v1/glossaries/{id}/versions/{version}")
  @Headers({
      "Accept: application/json",
  })
  Glossary getSpecificGlossaryVersion(@Param("id") UUID id, @Param("version") String version);
  /**
   * Import glossary terms from CSV to create, and update glossary terms.
   * 
   * @param name  (required)
   * @param body  (optional)
   * @param dryRun Dry-run when true is used for validating the CSV without really importing it. (default&#x3D;true) (optional)
   * @return GlossaryTermList
   */
  @RequestLine("PUT /v1/glossaries/name/{name}/import?dryRun={dryRun}")
  @Headers({
      "Content-Type: text/plain",
      "Accept: application/json",
  })
  GlossaryTermList importGlossary(@Param("name") String name, String body, @Param("dryRun") Boolean dryRun);

  /**
   * Import glossary terms from CSV to create, and update glossary terms.
   * 
   * Note, this is equivalent to the other <code>importGlossary</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ImportGlossaryQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param name  (required)
   * @param body  (optional)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>dryRun - Dry-run when true is used for validating the CSV without really importing it. (default&#x3D;true) (optional)</li>
   *   </ul>
   * @return GlossaryTermList

   */
  @RequestLine("PUT /v1/glossaries/name/{name}/import?dryRun={dryRun}")
  @Headers({
      "Content-Type: text/plain",
      "Accept: application/json",
  })
  GlossaryTermList importGlossary(@Param("name") String name, String body, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>importGlossary</code> method in a fluent style.
   */
  public static class ImportGlossaryQueryParams extends HashMap<String, Object> {
    public ImportGlossaryQueryParams dryRun(final Boolean value) {
      put("dryRun", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * List classification versions
   * Get a list of all the versions of a classification identified by &#x60;id&#x60;
   * @param id classification Id (required)
   * @return EntityHistory
   */
  @RequestLine("GET /v1/classifications/{id}/versions")
  @Headers({
      "Accept: application/json",
  })
  EntityHistory listAllClassificationVersion(@Param("id") String id);
  /**
   * List glossary versions
   * Get a list of all the versions of a glossary identified by &#x60;id&#x60;
   * @param id glossary Id (required)
   * @return EntityHistory
   */
  @RequestLine("GET /v1/glossaries/{id}/versions")
  @Headers({
      "Accept: application/json",
  })
  EntityHistory listAllGlossaryVersion(@Param("id") String id);
  /**
   * List Glossaries
   * Get a list of glossaries. Use &#x60;fields&#x60; parameter to get only necessary fields.  Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * @param fields Fields requested in the returned resource (optional)
   * @param limit Limit the number glossaries returned. (1 to 1000000, default &#x3D; 10) (optional)
   * @param before Returns list of glossaries before this cursor (optional)
   * @param after Returns list of glossaries after this cursor (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return GlossaryList
   */
  @RequestLine("GET /v1/glossaries?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  GlossaryList listGlossaries(@Param("fields") String fields, @Param("limit") Integer limit, @Param("before") String before, @Param("after") String after, @Param("include") String include);

  /**
   * List Glossaries
   * Get a list of glossaries. Use &#x60;fields&#x60; parameter to get only necessary fields.  Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * Note, this is equivalent to the other <code>listGlossaries</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListGlossariesQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>limit - Limit the number glossaries returned. (1 to 1000000, default &#x3D; 10) (optional)</li>
   *   <li>before - Returns list of glossaries before this cursor (optional)</li>
   *   <li>after - Returns list of glossaries after this cursor (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return GlossaryList

   */
  @RequestLine("GET /v1/glossaries?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  GlossaryList listGlossaries(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listGlossaries</code> method in a fluent style.
   */
  public static class ListGlossariesQueryParams extends HashMap<String, Object> {
    public ListGlossariesQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public ListGlossariesQueryParams limit(final Integer value) {
      put("limit", EncodingUtils.encode(value));
      return this;
    }
    public ListGlossariesQueryParams before(final String value) {
      put("before", EncodingUtils.encode(value));
      return this;
    }
    public ListGlossariesQueryParams after(final String value) {
      put("after", EncodingUtils.encode(value));
      return this;
    }
    public ListGlossariesQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Update a glossary
   * Update an existing glossary using JsonPatch.
   * @param id  (required)
   * @param body JsonPatch with array of operations (optional)
   * JsonPatch RFC
   * @see <a href="https://tools.ietf.org/html/rfc6902">Update a glossary Documentation</a>
   */
  @RequestLine("PATCH /v1/glossaries/{id}")
  @Headers({
      "Content-Type: application/json-patch+json",
      "Accept: application/json",
  })
  void patchGlossary(@Param("id") UUID id, Object body);
  /**
   * Restore a soft deleted Glossary.
   * Restore a soft deleted Glossary.
   * @param body  (optional)
   * @return Glossary
   */
  @RequestLine("PUT /v1/glossaries/restore")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Glossary restore11(RestoreEntity body);
}
