package org.openmetadata.client.api;

import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;

import org.openmetadata.client.model.CreateGlossaryTerm;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.Glossary;
import org.openmetadata.client.model.GlossaryTerm;
import org.openmetadata.client.model.GlossaryTermList;
import org.openmetadata.client.model.RestoreEntity;
import java.util.UUID;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")public interface GlossaryTermApi extends ApiClient.Api {

  /**
   * Create a glossary term
   * Create a new glossary term.
   * @param body  (optional)
   * @return GlossaryTerm
   */
  @RequestLine("POST /v1/glossaryTerms")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  GlossaryTerm createGlossaryTerm(CreateGlossaryTerm body);
  /**
   * Create or update a glossary term
   * Create a new glossary term, if it does not exist or update an existing glossary term.
   * @param body  (optional)
   * @return GlossaryTerm
   */
  @RequestLine("PUT /v1/glossaryTerms")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  GlossaryTerm createOrUpdateGlossaryTerm(CreateGlossaryTerm body);
  /**
   * Delete a glossary term
   * Delete a glossary term by &#x60;id&#x60;.
   * @param id Glossary Term Id (required)
   * @param recursive Recursively delete this entity and it&#x27;s children. (Default &#x60;false&#x60;) (optional)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/glossaryTerms/{id}?recursive={recursive}&hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void delete(@Param("id") UUID id, @Param("recursive") Boolean recursive, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a glossary term
   * Delete a glossary term by &#x60;id&#x60;.
   * Note, this is equivalent to the other <code>delete</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id Glossary Term Id (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>recursive - Recursively delete this entity and it&#x27;s children. (Default &#x60;false&#x60;) (optional)</li>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/glossaryTerms/{id}?recursive={recursive}&hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void delete(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>delete</code> method in a fluent style.
   */
  public static class DeleteQueryParams extends HashMap<String, Object> {
    public DeleteQueryParams recursive(final Boolean value) {
      put("recursive", EncodingUtils.encode(value));
      return this;
    }
    public DeleteQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Delete a glossary term
   * Delete a glossary term by &#x60;name&#x60;.
   * @param name Name of the glossary term (required)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/glossaryTerms/name/{name}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteGlossaryTermByName(@Param("name") String name, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a glossary term
   * Delete a glossary term by &#x60;name&#x60;.
   * Note, this is equivalent to the other <code>deleteGlossaryTermByName</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteGlossaryTermByNameQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param name Name of the glossary term (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/glossaryTerms/name/{name}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteGlossaryTermByName(@Param("name") String name, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteGlossaryTermByName</code> method in a fluent style.
   */
  public static class DeleteGlossaryTermByNameQueryParams extends HashMap<String, Object> {
    public DeleteGlossaryTermByNameQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a glossary term by name
   * Get a glossary term by name.
   * @param name  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return Glossary
   */
  @RequestLine("GET /v1/glossaryTerms/name/{name}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  Glossary getGlossaryTermByFQN(@Param("name") String name, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a glossary term by name
   * Get a glossary term by name.
   * Note, this is equivalent to the other <code>getGlossaryTermByFQN</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetGlossaryTermByFQNQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param name  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return Glossary

   */
  @RequestLine("GET /v1/glossaryTerms/name/{name}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  Glossary getGlossaryTermByFQN(@Param("name") String name, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getGlossaryTermByFQN</code> method in a fluent style.
   */
  public static class GetGlossaryTermByFQNQueryParams extends HashMap<String, Object> {
    public GetGlossaryTermByFQNQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetGlossaryTermByFQNQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a glossary term
   * Get a glossary term by &#x60;id&#x60;.
   * @param id  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return Glossary
   */
  @RequestLine("GET /v1/glossaryTerms/{id}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  Glossary getGlossaryTermByID(@Param("id") UUID id, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a glossary term
   * Get a glossary term by &#x60;id&#x60;.
   * Note, this is equivalent to the other <code>getGlossaryTermByID</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetGlossaryTermByIDQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return Glossary

   */
  @RequestLine("GET /v1/glossaryTerms/{id}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  Glossary getGlossaryTermByID(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getGlossaryTermByID</code> method in a fluent style.
   */
  public static class GetGlossaryTermByIDQueryParams extends HashMap<String, Object> {
    public GetGlossaryTermByIDQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetGlossaryTermByIDQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a version of the glossary term
   * Get a version of the glossary term by given &#x60;id&#x60;
   * @param id glossary Id (required)
   * @param version glossary term version number in the form &#x60;major&#x60;.&#x60;minor&#x60; (required)
   * @return Glossary
   */
  @RequestLine("GET /v1/glossaryTerms/{id}/versions/{version}")
  @Headers({
      "Accept: application/json",
  })
  Glossary getSpecificGlossaryTermVersion(@Param("id") UUID id, @Param("version") String version);
  /**
   * List glossary term versions
   * Get a list of all the versions of a glossary terms identified by &#x60;id&#x60;
   * @param id glossary Id (required)
   * @return EntityHistory
   */
  @RequestLine("GET /v1/glossaryTerms/{id}/versions")
  @Headers({
      "Accept: application/json",
  })
  EntityHistory listAllGlossaryTermVersion(@Param("id") String id);
  /**
   * List glossary terms
   * Get a list of glossary terms. Use &#x60;fields&#x60; parameter to get only necessary fields.  Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * @param glossary List glossary terms filtered by glossary identified by Id given in &#x60;glossary&#x60; parameter. (optional)
   * @param parent List glossary terms filtered by children of glossary term identified by Id given in &#x60;parent&#x60; parameter. (optional)
   * @param fields Fields requested in the returned resource (optional)
   * @param limit Limit the number glossary terms returned. (1 to 1000000, default &#x3D; 10) (optional)
   * @param before Returns list of glossary terms before this cursor (optional)
   * @param after Returns list of glossary terms after this cursor (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return GlossaryTermList
   */
  @RequestLine("GET /v1/glossaryTerms?glossary={glossary}&parent={parent}&fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  GlossaryTermList listGlossaryTerm(@Param("glossary") String glossary, @Param("parent") String parent, @Param("fields") String fields, @Param("limit") Integer limit, @Param("before") String before, @Param("after") String after, @Param("include") String include);

  /**
   * List glossary terms
   * Get a list of glossary terms. Use &#x60;fields&#x60; parameter to get only necessary fields.  Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * Note, this is equivalent to the other <code>listGlossaryTerm</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListGlossaryTermQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>glossary - List glossary terms filtered by glossary identified by Id given in &#x60;glossary&#x60; parameter. (optional)</li>
   *   <li>parent - List glossary terms filtered by children of glossary term identified by Id given in &#x60;parent&#x60; parameter. (optional)</li>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>limit - Limit the number glossary terms returned. (1 to 1000000, default &#x3D; 10) (optional)</li>
   *   <li>before - Returns list of glossary terms before this cursor (optional)</li>
   *   <li>after - Returns list of glossary terms after this cursor (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return GlossaryTermList

   */
  @RequestLine("GET /v1/glossaryTerms?glossary={glossary}&parent={parent}&fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  GlossaryTermList listGlossaryTerm(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listGlossaryTerm</code> method in a fluent style.
   */
  public static class ListGlossaryTermQueryParams extends HashMap<String, Object> {
    public ListGlossaryTermQueryParams glossary(final String value) {
      put("glossary", EncodingUtils.encode(value));
      return this;
    }
    public ListGlossaryTermQueryParams parent(final String value) {
      put("parent", EncodingUtils.encode(value));
      return this;
    }
    public ListGlossaryTermQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public ListGlossaryTermQueryParams limit(final Integer value) {
      put("limit", EncodingUtils.encode(value));
      return this;
    }
    public ListGlossaryTermQueryParams before(final String value) {
      put("before", EncodingUtils.encode(value));
      return this;
    }
    public ListGlossaryTermQueryParams after(final String value) {
      put("after", EncodingUtils.encode(value));
      return this;
    }
    public ListGlossaryTermQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Update a glossary term
   * Update an existing glossary term using JsonPatch.
   * @param id  (required)
   * @param body JsonPatch with array of operations (optional)
   * JsonPatch RFC
   * @see <a href="https://tools.ietf.org/html/rfc6902">Update a glossary term Documentation</a>
   */
  @RequestLine("PATCH /v1/glossaryTerms/{id}")
  @Headers({
      "Content-Type: application/json-patch+json",
      "Accept: application/json",
  })
  void patchGlossaryTerm(@Param("id") UUID id, Object body);
  /**
   * Restore a soft deleted GlossaryTerm.
   * Restore a soft deleted GlossaryTerm.
   * @param body  (optional)
   * @return GlossaryTerm
   */
  @RequestLine("PUT /v1/glossaryTerms/restore")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  GlossaryTerm restore12(RestoreEntity body);
}
