package org.openmetadata.client.api;

import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;

import java.math.BigDecimal;
import org.openmetadata.client.model.CreateIngestionPipeline;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.IngestionPipeline;
import org.openmetadata.client.model.PipelineStatus;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.TestServiceConnection;
import java.util.UUID;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")public interface IngestionPipelinesApi extends ApiClient.Api {

  /**
   * Add pipeline status
   * Add pipeline status of ingestion pipeline.
   * @param fqn fqn of the ingestion pipeline (required)
   * @param body  (optional)
   * @return IngestionPipeline
   */
  @RequestLine("PUT /v1/services/ingestionPipelines/{fqn}/pipelineStatus")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  IngestionPipeline addPipelineStatus(@Param("fqn") String fqn, PipelineStatus body);
  /**
   * Check the Airflow REST host IP
   * Check the Airflow REST host IP
   */
  @RequestLine("GET /v1/services/ingestionPipelines/ip")
  @Headers({
      "Accept: application/json",
  })
  void checkAirflowHostIp();
  /**
   * Check the Airflow REST status
   * Check that the Airflow REST endpoint is reachable and up and running
   */
  @RequestLine("GET /v1/services/ingestionPipelines/status")
  @Headers({
      "Accept: application/json",
  })
  void checkRestAirflowStatus();
  /**
   * Create a Ingestion Pipeline
   * Create a new Ingestion Pipeline.
   * @param body  (optional)
   * @return IngestionPipeline
   */
  @RequestLine("POST /v1/services/ingestionPipelines")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  IngestionPipeline createIngestionPipeline(CreateIngestionPipeline body);
  /**
   * Create or update a IngestionPipeline
   * Create a new IngestionPipeline, if it does not exist or update an existing IngestionPipeline.
   * @param body  (optional)
   * @return IngestionPipeline
   */
  @RequestLine("PUT /v1/services/ingestionPipelines")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  IngestionPipeline createOrUpdateIngestionPipeline(CreateIngestionPipeline body);
  /**
   * Delete a Ingestion
   * Delete a ingestion by &#x60;id&#x60;.
   * @param id Pipeline Id (required)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/services/ingestionPipelines/{id}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteIngestionPipeline(@Param("id") String id, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a Ingestion
   * Delete a ingestion by &#x60;id&#x60;.
   * Note, this is equivalent to the other <code>deleteIngestionPipeline</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteIngestionPipelineQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id Pipeline Id (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/services/ingestionPipelines/{id}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteIngestionPipeline(@Param("id") String id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteIngestionPipeline</code> method in a fluent style.
   */
  public static class DeleteIngestionPipelineQueryParams extends HashMap<String, Object> {
    public DeleteIngestionPipelineQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Delete a Ingestion
   * Delete an ingestion pipeline by &#x60;fullyQualifiedName&#x60;.
   * @param fqn Name of the ingestion pipeline (required)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/services/ingestionPipelines/name/{fqn}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteIngestionPipelineByFQN(@Param("fqn") String fqn, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a Ingestion
   * Delete an ingestion pipeline by &#x60;fullyQualifiedName&#x60;.
   * Note, this is equivalent to the other <code>deleteIngestionPipelineByFQN</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteIngestionPipelineByFQNQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param fqn Name of the ingestion pipeline (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/services/ingestionPipelines/name/{fqn}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteIngestionPipelineByFQN(@Param("fqn") String fqn, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteIngestionPipelineByFQN</code> method in a fluent style.
   */
  public static class DeleteIngestionPipelineByFQNQueryParams extends HashMap<String, Object> {
    public DeleteIngestionPipelineByFQNQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Deploy a ingestion pipeline run
   * Trigger a ingestion pipeline run by id.
   * @param id  (required)
   * @return IngestionPipeline
   */
  @RequestLine("POST /v1/services/ingestionPipelines/deploy/{id}")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  IngestionPipeline deployIngestion(@Param("id") UUID id);
  /**
   * Get a IngestionPipeline
   * Get a IngestionPipeline by &#x60;id&#x60;.
   * @param id  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return IngestionPipeline
   */
  @RequestLine("GET /v1/services/ingestionPipelines/{id}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  IngestionPipeline getIngestionPipelineByID(@Param("id") UUID id, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a IngestionPipeline
   * Get a IngestionPipeline by &#x60;id&#x60;.
   * Note, this is equivalent to the other <code>getIngestionPipelineByID</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetIngestionPipelineByIDQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return IngestionPipeline

   */
  @RequestLine("GET /v1/services/ingestionPipelines/{id}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  IngestionPipeline getIngestionPipelineByID(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getIngestionPipelineByID</code> method in a fluent style.
   */
  public static class GetIngestionPipelineByIDQueryParams extends HashMap<String, Object> {
    public GetIngestionPipelineByIDQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetIngestionPipelineByIDQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Retrieve all logs from last ingestion pipeline run
   * Get all logs from last ingestion pipeline run by &#x60;id&#x60;.
   * @param id Pipeline Id (required)
   * @param after Returns log chunk after this cursor (optional)
   */
  @RequestLine("GET /v1/services/ingestionPipelines/logs/{id}/last?after={after}")
  @Headers({
      "Accept: application/json",
  })
  void getLastIngestionLogs(@Param("id") String id, @Param("after") String after);

  /**
   * Retrieve all logs from last ingestion pipeline run
   * Get all logs from last ingestion pipeline run by &#x60;id&#x60;.
   * Note, this is equivalent to the other <code>getLastIngestionLogs</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetLastIngestionLogsQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id Pipeline Id (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>after - Returns log chunk after this cursor (optional)</li>
   *   </ul>

   */
  @RequestLine("GET /v1/services/ingestionPipelines/logs/{id}/last?after={after}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  void getLastIngestionLogs(@Param("id") String id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getLastIngestionLogs</code> method in a fluent style.
   */
  public static class GetLastIngestionLogsQueryParams extends HashMap<String, Object> {
    public GetLastIngestionLogsQueryParams after(final String value) {
      put("after", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * get pipeline status
   * Get pipeline status of ingestion pipeline
   * @param fqn fqn of the ingestion pipeline (required)
   * @param id Pipeline Status Run Id (required)
   * @return IngestionPipeline
   */
  @RequestLine("GET /v1/services/ingestionPipelines/{fqn}/pipelineStatus/{id}")
  @Headers({
      "Accept: application/json",
  })
  IngestionPipeline getPipelineStatus(@Param("fqn") String fqn, @Param("id") String id);
  /**
   * Get a IngestionPipeline by name
   * Get a ingestion by fully qualified name.
   * @param fqn  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return IngestionPipeline
   */
  @RequestLine("GET /v1/services/ingestionPipelines/name/{fqn}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  IngestionPipeline getSpecificIngestionPipelineByFQN(@Param("fqn") String fqn, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a IngestionPipeline by name
   * Get a ingestion by fully qualified name.
   * Note, this is equivalent to the other <code>getSpecificIngestionPipelineByFQN</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetSpecificIngestionPipelineByFQNQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param fqn  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return IngestionPipeline

   */
  @RequestLine("GET /v1/services/ingestionPipelines/name/{fqn}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  IngestionPipeline getSpecificIngestionPipelineByFQN(@Param("fqn") String fqn, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getSpecificIngestionPipelineByFQN</code> method in a fluent style.
   */
  public static class GetSpecificIngestionPipelineByFQNQueryParams extends HashMap<String, Object> {
    public GetSpecificIngestionPipelineByFQNQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetSpecificIngestionPipelineByFQNQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a version of the IngestionPipeline
   * Get a version of the IngestionPipeline by given &#x60;id&#x60;
   * @param id Ingestion Id (required)
   * @param version Ingestion version number in the form &#x60;major&#x60;.&#x60;minor&#x60; (required)
   * @return IngestionPipeline
   */
  @RequestLine("GET /v1/services/ingestionPipelines/{id}/versions/{version}")
  @Headers({
      "Accept: application/json",
  })
  IngestionPipeline getSpecificIngestionPipelineVersion(@Param("id") String id, @Param("version") String version);
  /**
   * Mark as failed and kill any not-finished workflow or task for the IngestionPipeline
   * Kill an ingestion pipeline by ID.
   * @param id  (required)
   * @return IngestionPipeline
   */
  @RequestLine("POST /v1/services/ingestionPipelines/kill/{id}")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  IngestionPipeline killIngestionPipelineRuns(@Param("id") UUID id);
  /**
   * List ingestion workflow versions
   * Get a list of all the versions of a IngestionPipeline identified by &#x60;id&#x60;
   * @param id IngestionPipeline Id (required)
   * @return EntityHistory
   */
  @RequestLine("GET /v1/services/ingestionPipelines/{id}/versions")
  @Headers({
      "Accept: application/json",
  })
  EntityHistory listAllIngestionPipelineVersion(@Param("id") String id);
  /**
   * List Ingestion Pipelines for Metadata Operations
   * Get a list of Airflow Pipelines for Metadata Operations. Use &#x60;fields&#x60; parameter to get only necessary fields.  Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * @param fields Fields requested in the returned resource (optional)
   * @param service Filter airflow pipelines by service fully qualified name (optional)
   * @param limit Limit the number ingestion returned. (1 to 1000000, default &#x3D; 10) (optional)
   * @param before Returns list of ingestion before this cursor (optional)
   * @param after Returns list of ingestion after this cursor (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return IngestionPipeline
   */
  @RequestLine("GET /v1/services/ingestionPipelines?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  IngestionPipeline listIngestionPipelines(@Param("fields") String fields, @Param("service") String service, @Param("limit") Integer limit, @Param("before") String before, @Param("after") String after, @Param("include") String include);

  /**
   * List Ingestion Pipelines for Metadata Operations
   * Get a list of Airflow Pipelines for Metadata Operations. Use &#x60;fields&#x60; parameter to get only necessary fields.  Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * Note, this is equivalent to the other <code>listIngestionPipelines</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListIngestionPipelinesQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>service - Filter airflow pipelines by service fully qualified name (optional)</li>
   *   <li>limit - Limit the number ingestion returned. (1 to 1000000, default &#x3D; 10) (optional)</li>
   *   <li>before - Returns list of ingestion before this cursor (optional)</li>
   *   <li>after - Returns list of ingestion after this cursor (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return IngestionPipeline

   */
  @RequestLine("GET /v1/services/ingestionPipelines?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  IngestionPipeline listIngestionPipelines(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listIngestionPipelines</code> method in a fluent style.
   */
  public static class ListIngestionPipelinesQueryParams extends HashMap<String, Object> {
    public ListIngestionPipelinesQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public ListIngestionPipelinesQueryParams service(final String value) {
      put("service", EncodingUtils.encode(value));
      return this;
    }
    public ListIngestionPipelinesQueryParams limit(final Integer value) {
      put("limit", EncodingUtils.encode(value));
      return this;
    }
    public ListIngestionPipelinesQueryParams before(final String value) {
      put("before", EncodingUtils.encode(value));
      return this;
    }
    public ListIngestionPipelinesQueryParams after(final String value) {
      put("after", EncodingUtils.encode(value));
      return this;
    }
    public ListIngestionPipelinesQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * List of pipeline status
   * Get a list of all the pipeline status for the given ingestion pipeline id, optionally filtered by  &#x60;startTs&#x60; and &#x60;endTs&#x60; of the profile. Use cursor-based pagination to limit the number of entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * @param fqn fqn of the ingestion pipeline (required)
   * @param startTs Filter pipeline status after the given start timestamp (optional)
   * @param endTs Filter pipeline status before the given end timestamp (optional)
   * @return IngestionPipeline
   */
  @RequestLine("GET /v1/services/ingestionPipelines/{fqn}/pipelineStatus?startTs={startTs}&endTs={endTs}")
  @Headers({
      "Accept: application/json",
  })
  IngestionPipeline listPipelineStatuses1(@Param("fqn") String fqn, @Param("startTs") BigDecimal startTs, @Param("endTs") BigDecimal endTs);

  /**
   * List of pipeline status
   * Get a list of all the pipeline status for the given ingestion pipeline id, optionally filtered by  &#x60;startTs&#x60; and &#x60;endTs&#x60; of the profile. Use cursor-based pagination to limit the number of entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * Note, this is equivalent to the other <code>listPipelineStatuses1</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListPipelineStatuses1QueryParams} class that allows for
   * building up this map in a fluent style.
   * @param fqn fqn of the ingestion pipeline (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>startTs - Filter pipeline status after the given start timestamp (optional)</li>
   *   <li>endTs - Filter pipeline status before the given end timestamp (optional)</li>
   *   </ul>
   * @return IngestionPipeline

   */
  @RequestLine("GET /v1/services/ingestionPipelines/{fqn}/pipelineStatus?startTs={startTs}&endTs={endTs}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  IngestionPipeline listPipelineStatuses1(@Param("fqn") String fqn, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listPipelineStatuses1</code> method in a fluent style.
   */
  public static class ListPipelineStatuses1QueryParams extends HashMap<String, Object> {
    public ListPipelineStatuses1QueryParams startTs(final BigDecimal value) {
      put("startTs", EncodingUtils.encode(value));
      return this;
    }
    public ListPipelineStatuses1QueryParams endTs(final BigDecimal value) {
      put("endTs", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Update a IngestionPipeline
   * Update an existing IngestionPipeline using JsonPatch.
   * @param id  (required)
   * @param body JsonPatch with array of operations (optional)
   * JsonPatch RFC
   * @see <a href="https://tools.ietf.org/html/rfc6902">Update a IngestionPipeline Documentation</a>
   */
  @RequestLine("PATCH /v1/services/ingestionPipelines/{id}")
  @Headers({
      "Content-Type: application/json-patch+json",
      "Accept: application/json",
  })
  void patchIngestionPipeline(@Param("id") UUID id, Object body);
  /**
   * Restore a soft deleted IngestionPipeline.
   * Restore a soft deleted IngestionPipeline.
   * @param body  (optional)
   * @return IngestionPipeline
   */
  @RequestLine("PUT /v1/services/ingestionPipelines/restore")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  IngestionPipeline restore20(RestoreEntity body);
  /**
   * Test Connection of a Service
   * Test Connection of a Service.
   * @param body  (optional)
   */
  @RequestLine("POST /v1/services/ingestionPipelines/testConnection")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  void testConnection(TestServiceConnection body);
  /**
   * Set an Ingestion pipeline either as Enabled or Disabled
   * Toggle an ingestion pipeline state by id.
   * @param id  (required)
   * @return IngestionPipeline
   */
  @RequestLine("POST /v1/services/ingestionPipelines/toggleIngestion/{id}")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  IngestionPipeline toggleIngestionPipelineEnabled(@Param("id") UUID id);
  /**
   * Trigger a ingestion pipeline run
   * Trigger a ingestion pipeline run by id.
   * @param id  (required)
   * @return IngestionPipeline
   */
  @RequestLine("POST /v1/services/ingestionPipelines/trigger/{id}")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  IngestionPipeline triggerIngestionPipelineRun(@Param("id") UUID id);
}
