package org.openmetadata.client.api;

import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;

import java.math.BigDecimal;
import org.openmetadata.client.model.CreateKpiRequest;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.Kpi;
import org.openmetadata.client.model.KpiList;
import org.openmetadata.client.model.KpiResult;
import org.openmetadata.client.model.KpiResultList;
import org.openmetadata.client.model.RestoreEntity;
import java.util.UUID;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")public interface KpiApi extends ApiClient.Api {

  /**
   * Add kpi result data
   * Add Kpi Result data to the kpi.
   * @param fqn fqn of the kpi (required)
   * @param body  (optional)
   * @return Kpi
   */
  @RequestLine("PUT /v1/kpi/{fqn}/kpiResult")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Kpi addKpiResult(@Param("fqn") String fqn, KpiResult body);
  /**
   * Create a Kpi
   * Create a Kpi.
   * @param body  (optional)
   * @return Kpi
   */
  @RequestLine("POST /v1/kpi")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Kpi createKpi(CreateKpiRequest body);
  /**
   * Update Kpi
   * Create a Kpi, it it does not exist or update an existing Kpi.
   * @param body  (optional)
   * @return Kpi
   */
  @RequestLine("PUT /v1/kpi")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Kpi createOrUpdateKpi(CreateKpiRequest body);
  /**
   * Delete a Kpi
   * Delete a Kpi by &#x60;id&#x60;.
   * @param id Kpi Id (required)
   * @param recursive Recursively delete this entity and it&#x27;s children. (Default &#x60;false&#x60;) (optional)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/kpi/{id}?recursive={recursive}&hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteKpi(@Param("id") UUID id, @Param("recursive") Boolean recursive, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a Kpi
   * Delete a Kpi by &#x60;id&#x60;.
   * Note, this is equivalent to the other <code>deleteKpi</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteKpiQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id Kpi Id (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>recursive - Recursively delete this entity and it&#x27;s children. (Default &#x60;false&#x60;) (optional)</li>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/kpi/{id}?recursive={recursive}&hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteKpi(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteKpi</code> method in a fluent style.
   */
  public static class DeleteKpiQueryParams extends HashMap<String, Object> {
    public DeleteKpiQueryParams recursive(final Boolean value) {
      put("recursive", EncodingUtils.encode(value));
      return this;
    }
    public DeleteKpiQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Delete a Kpi
   * Delete a Kpi by &#x60;name&#x60;.
   * @param name Name of the table (required)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/kpi/name/{name}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteKpiByName(@Param("name") String name, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a Kpi
   * Delete a Kpi by &#x60;name&#x60;.
   * Note, this is equivalent to the other <code>deleteKpiByName</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteKpiByNameQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param name Name of the table (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/kpi/name/{name}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteKpiByName(@Param("name") String name, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteKpiByName</code> method in a fluent style.
   */
  public static class DeleteKpiByNameQueryParams extends HashMap<String, Object> {
    public DeleteKpiByNameQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Delete kpi result.
   * Delete kpi result for a kpi.
   * @param fqn fqn of the kpi (required)
   * @param timestamp Timestamp of the kpi result (required)
   * @return Kpi
   */
  @RequestLine("DELETE /v1/kpi/{fqn}/kpiResult/{timestamp}")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Kpi deleteKpiResult(@Param("fqn") String fqn, @Param("timestamp") Long timestamp);
  /**
   * Get a Kpi
   * Get a Kpi by &#x60;id&#x60;.
   * @param id  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return Kpi
   */
  @RequestLine("GET /v1/kpi/{id}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  Kpi get3(@Param("id") UUID id, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a Kpi
   * Get a Kpi by &#x60;id&#x60;.
   * Note, this is equivalent to the other <code>get3</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link Get3QueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return Kpi

   */
  @RequestLine("GET /v1/kpi/{id}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  Kpi get3(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>get3</code> method in a fluent style.
   */
  public static class Get3QueryParams extends HashMap<String, Object> {
    public Get3QueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public Get3QueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a Kpi by name
   * Get a Kpi by  name.
   * @param name  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return Kpi
   */
  @RequestLine("GET /v1/kpi/name/{name}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  Kpi getKpiByName(@Param("name") String name, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a Kpi by name
   * Get a Kpi by  name.
   * Note, this is equivalent to the other <code>getKpiByName</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetKpiByNameQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param name  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return Kpi

   */
  @RequestLine("GET /v1/kpi/name/{name}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  Kpi getKpiByName(@Param("name") String name, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getKpiByName</code> method in a fluent style.
   */
  public static class GetKpiByNameQueryParams extends HashMap<String, Object> {
    public GetKpiByNameQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetKpiByNameQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a latest Kpi Result
   * Get Latest Kpi Result for the given kpi
   * @param fqn fqn of the kpi (required)
   * @return KpiResultList
   */
  @RequestLine("GET /v1/kpi/{fqn}/latestKpiResult")
  @Headers({
      "Accept: application/json",
  })
  KpiResultList getLatestKpiResults(@Param("fqn") String fqn);
  /**
   * Get a version of the Kpi
   * Get a version of the Kpi by given &#x60;id&#x60;
   * @param id Kpi Id (required)
   * @param version Kpi version number in the form &#x60;major&#x60;.&#x60;minor&#x60; (required)
   * @return Kpi
   */
  @RequestLine("GET /v1/kpi/{id}/versions/{version}")
  @Headers({
      "Accept: application/json",
  })
  Kpi getSpecificKpiVersion(@Param("id") String id, @Param("version") String version);
  /**
   * List kpi versions
   * Get a list of all the versions of a Kpi identified by &#x60;id&#x60;
   * @param id Kpi Id (required)
   * @return EntityHistory
   */
  @RequestLine("GET /v1/kpi/{id}/versions")
  @Headers({
      "Accept: application/json",
  })
  EntityHistory listAllKpiVersion(@Param("id") String id);
  /**
   * List of kpi results
   * Get a list of all the kpi results for the given kpi id, optionally filtered by  &#x60;startTs&#x60; and &#x60;endTs&#x60; of the profile. Use cursor-based pagination to limit the number of entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * @param fqn fqn of the kpi (required)
   * @param startTs Filter kpi results after the given start timestamp (optional)
   * @param endTs Filter kpi results before the given end timestamp (optional)
   * @param orderBy Order the result  (optional)
   * @return KpiResultList
   */
  @RequestLine("GET /v1/kpi/{fqn}/kpiResult?startTs={startTs}&endTs={endTs}&orderBy={orderBy}")
  @Headers({
      "Accept: application/json",
  })
  KpiResultList listKpiResults(@Param("fqn") String fqn, @Param("startTs") BigDecimal startTs, @Param("endTs") BigDecimal endTs, @Param("orderBy") String orderBy);

  /**
   * List of kpi results
   * Get a list of all the kpi results for the given kpi id, optionally filtered by  &#x60;startTs&#x60; and &#x60;endTs&#x60; of the profile. Use cursor-based pagination to limit the number of entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * Note, this is equivalent to the other <code>listKpiResults</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListKpiResultsQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param fqn fqn of the kpi (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>startTs - Filter kpi results after the given start timestamp (optional)</li>
   *   <li>endTs - Filter kpi results before the given end timestamp (optional)</li>
   *   <li>orderBy - Order the result  (optional)</li>
   *   </ul>
   * @return KpiResultList

   */
  @RequestLine("GET /v1/kpi/{fqn}/kpiResult?startTs={startTs}&endTs={endTs}&orderBy={orderBy}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  KpiResultList listKpiResults(@Param("fqn") String fqn, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listKpiResults</code> method in a fluent style.
   */
  public static class ListKpiResultsQueryParams extends HashMap<String, Object> {
    public ListKpiResultsQueryParams startTs(final BigDecimal value) {
      put("startTs", EncodingUtils.encode(value));
      return this;
    }
    public ListKpiResultsQueryParams endTs(final BigDecimal value) {
      put("endTs", EncodingUtils.encode(value));
      return this;
    }
    public ListKpiResultsQueryParams orderBy(final String value) {
      put("orderBy", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * List Kpi
   * Get a list of kpi. Use &#x60;fields&#x60; parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * @param fields Fields requested in the returned resource (optional)
   * @param limit Limit the number kpi returned. (1 to 1000000, default &#x3D; 10) (optional)
   * @param before Returns list of tests before this cursor (optional)
   * @param after Returns list of tests after this cursor (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return KpiList
   */
  @RequestLine("GET /v1/kpi?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  KpiList listKpis(@Param("fields") String fields, @Param("limit") Integer limit, @Param("before") String before, @Param("after") String after, @Param("include") String include);

  /**
   * List Kpi
   * Get a list of kpi. Use &#x60;fields&#x60; parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * Note, this is equivalent to the other <code>listKpis</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListKpisQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>limit - Limit the number kpi returned. (1 to 1000000, default &#x3D; 10) (optional)</li>
   *   <li>before - Returns list of tests before this cursor (optional)</li>
   *   <li>after - Returns list of tests after this cursor (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return KpiList

   */
  @RequestLine("GET /v1/kpi?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  KpiList listKpis(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listKpis</code> method in a fluent style.
   */
  public static class ListKpisQueryParams extends HashMap<String, Object> {
    public ListKpisQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public ListKpisQueryParams limit(final Integer value) {
      put("limit", EncodingUtils.encode(value));
      return this;
    }
    public ListKpisQueryParams before(final String value) {
      put("before", EncodingUtils.encode(value));
      return this;
    }
    public ListKpisQueryParams after(final String value) {
      put("after", EncodingUtils.encode(value));
      return this;
    }
    public ListKpisQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Update a Kpi
   * Update an existing Kpi using JsonPatch.
   * @param id  (required)
   * @param body JsonPatch with array of operations (optional)
   * JsonPatch RFC
   * @see <a href="https://tools.ietf.org/html/rfc6902">Update a Kpi Documentation</a>
   */
  @RequestLine("PATCH /v1/kpi/{id}")
  @Headers({
      "Content-Type: application/json-patch+json",
      "Accept: application/json",
  })
  void patchKpi(@Param("id") UUID id, Object body);
  /**
   * Restore a soft deleted Kpi.
   * Restore a soft deleted Kpi.
   * @param body  (optional)
   * @return Kpi
   */
  @RequestLine("PUT /v1/kpi/restore")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Kpi restore13(RestoreEntity body);
}
