package org.openmetadata.client.api;

import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;

import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateLocation;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.Location;
import org.openmetadata.client.model.LocationList;
import org.openmetadata.client.model.RestoreEntity;
import java.util.UUID;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")public interface LocationsApi extends ApiClient.Api {

  /**
   * Add a follower
   * Add a user identified by &#x60;userId&#x60; as followed of this location
   * @param id Id of the location (required)
   * @param body Id of the user to be added as follower (optional)
   * @return ChangeEvent
   */
  @RequestLine("PUT /v1/locations/{id}/followers")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  ChangeEvent addFollower(@Param("id") UUID id, UUID body);
  /**
   * Create a location
   * Create a location under an existing &#x60;service&#x60;.
   * @param body  (optional)
   * @return Location
   */
  @RequestLine("POST /v1/locations")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Location createLocation(CreateLocation body);
  /**
   * Create or update location
   * Create a location, it it does not exist or update an existing location.
   * @param body  (optional)
   * @return Location
   */
  @RequestLine("PUT /v1/locations")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Location createOrUpdateLocation(CreateLocation body);
  /**
   * Remove a follower
   * Remove the user identified &#x60;userId&#x60; as a follower of the location.
   * @param id Id of the location (required)
   * @param userId Id of the user being removed as follower (required)
   * @return ChangeEvent
   */
  @RequestLine("DELETE /v1/locations/{id}/followers/{userId}")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  ChangeEvent deleteFollower1(@Param("id") String id, @Param("userId") String userId);
  /**
   * Delete a location
   * Delete a location by &#x60;id&#x60;.
   * @param id Location Id (required)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/locations/{id}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteLocation2(@Param("id") UUID id, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a location
   * Delete a location by &#x60;id&#x60;.
   * Note, this is equivalent to the other <code>deleteLocation2</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteLocation2QueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id Location Id (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/locations/{id}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteLocation2(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteLocation2</code> method in a fluent style.
   */
  public static class DeleteLocation2QueryParams extends HashMap<String, Object> {
    public DeleteLocation2QueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Delete a location
   * Delete a location by &#x60;fullyQualifiedName&#x60;.
   * @param fqn Name of the location (required)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/locations/name/{fqn}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteLocationByFQN(@Param("fqn") String fqn, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a location
   * Delete a location by &#x60;fullyQualifiedName&#x60;.
   * Note, this is equivalent to the other <code>deleteLocationByFQN</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteLocationByFQNQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param fqn Name of the location (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/locations/name/{fqn}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteLocationByFQN(@Param("fqn") String fqn, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteLocationByFQN</code> method in a fluent style.
   */
  public static class DeleteLocationByFQNQueryParams extends HashMap<String, Object> {
    public DeleteLocationByFQNQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a table associated with location
   * Get a table associated with location by given &#x60;id&#x60;
   * @param id location Id (required)
   * @return Location
   */
  @RequestLine("GET /v1/locations/association/{id}")
  @Headers({
      "Accept: application/json",
  })
  Location getEntityByLocation(@Param("id") UUID id);
  /**
   * Get a location by name
   * Get a location by fully qualified name.
   * @param fqn Fully qualified name of the location urlencoded if needed (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return Location
   */
  @RequestLine("GET /v1/locations/name/{fqn}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  Location getLocationByFQN(@Param("fqn") String fqn, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a location by name
   * Get a location by fully qualified name.
   * Note, this is equivalent to the other <code>getLocationByFQN</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetLocationByFQNQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param fqn Fully qualified name of the location urlencoded if needed (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return Location

   */
  @RequestLine("GET /v1/locations/name/{fqn}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  Location getLocationByFQN(@Param("fqn") String fqn, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getLocationByFQN</code> method in a fluent style.
   */
  public static class GetLocationByFQNQueryParams extends HashMap<String, Object> {
    public GetLocationByFQNQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetLocationByFQNQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a location
   * Get a location by &#x60;id&#x60;.
   * @param id location Id (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return Location
   */
  @RequestLine("GET /v1/locations/{id}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  Location getLocationByID(@Param("id") String id, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a location
   * Get a location by &#x60;id&#x60;.
   * Note, this is equivalent to the other <code>getLocationByID</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetLocationByIDQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id location Id (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return Location

   */
  @RequestLine("GET /v1/locations/{id}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  Location getLocationByID(@Param("id") String id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getLocationByID</code> method in a fluent style.
   */
  public static class GetLocationByIDQueryParams extends HashMap<String, Object> {
    public GetLocationByIDQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetLocationByIDQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a version of the location
   * Get a version of the location by given &#x60;id&#x60;
   * @param id location Id (required)
   * @param version location version number in the form &#x60;major&#x60;.&#x60;minor&#x60; (required)
   * @return Location
   */
  @RequestLine("GET /v1/locations/{id}/versions/{version}")
  @Headers({
      "Accept: application/json",
  })
  Location getSpecificLocationVersion(@Param("id") String id, @Param("version") String version);
  /**
   * List location versions
   * Get a list of all the versions of a location identified by &#x60;id&#x60;
   * @param id location Id (required)
   * @return EntityHistory
   */
  @RequestLine("GET /v1/locations/{id}/versions")
  @Headers({
      "Accept: application/json",
  })
  EntityHistory listAllLocationVersion(@Param("id") String id);
  /**
   * List locations that are prefixes
   * Get a list of locations. Use &#x60;fields&#x60; parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * @param fqn Fully qualified name of the location urlencoded if needed (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param limit Limit the number locations returned. (1 to 1000000, default &#x3D; 10) (optional)
   * @param before Returns list of locations before this cursor (optional)
   * @param after Returns list of locations after this cursor (optional)
   * @return LocationList
   */
  @RequestLine("GET /v1/locations/prefixes/{fqn}?fields={fields}&limit={limit}&before={before}&after={after}")
  @Headers({
      "Accept: application/json",
  })
  LocationList listLocationPrefixes(@Param("fqn") String fqn, @Param("fields") String fields, @Param("limit") Integer limit, @Param("before") String before, @Param("after") String after);

  /**
   * List locations that are prefixes
   * Get a list of locations. Use &#x60;fields&#x60; parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * Note, this is equivalent to the other <code>listLocationPrefixes</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListLocationPrefixesQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param fqn Fully qualified name of the location urlencoded if needed (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>limit - Limit the number locations returned. (1 to 1000000, default &#x3D; 10) (optional)</li>
   *   <li>before - Returns list of locations before this cursor (optional)</li>
   *   <li>after - Returns list of locations after this cursor (optional)</li>
   *   </ul>
   * @return LocationList

   */
  @RequestLine("GET /v1/locations/prefixes/{fqn}?fields={fields}&limit={limit}&before={before}&after={after}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  LocationList listLocationPrefixes(@Param("fqn") String fqn, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listLocationPrefixes</code> method in a fluent style.
   */
  public static class ListLocationPrefixesQueryParams extends HashMap<String, Object> {
    public ListLocationPrefixesQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public ListLocationPrefixesQueryParams limit(final Integer value) {
      put("limit", EncodingUtils.encode(value));
      return this;
    }
    public ListLocationPrefixesQueryParams before(final String value) {
      put("before", EncodingUtils.encode(value));
      return this;
    }
    public ListLocationPrefixesQueryParams after(final String value) {
      put("after", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * List locations
   * Get a list of locations, optionally filtered by &#x60;service&#x60; it belongs to. Use &#x60;fields&#x60; parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * @param fields Fields requested in the returned resource (optional)
   * @param service Filter locations by prefix of the FQN (optional)
   * @param limit Limit the number locations returned. (1 to 1000000, default &#x3D; 10) (optional)
   * @param before Returns list of locations before this cursor (optional)
   * @param after Returns list of locations after this cursor (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return LocationList
   */
  @RequestLine("GET /v1/locations?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  LocationList listLocations(@Param("fields") String fields, @Param("service") String service, @Param("limit") Integer limit, @Param("before") String before, @Param("after") String after, @Param("include") String include);

  /**
   * List locations
   * Get a list of locations, optionally filtered by &#x60;service&#x60; it belongs to. Use &#x60;fields&#x60; parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * Note, this is equivalent to the other <code>listLocations</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListLocationsQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>service - Filter locations by prefix of the FQN (optional)</li>
   *   <li>limit - Limit the number locations returned. (1 to 1000000, default &#x3D; 10) (optional)</li>
   *   <li>before - Returns list of locations before this cursor (optional)</li>
   *   <li>after - Returns list of locations after this cursor (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return LocationList

   */
  @RequestLine("GET /v1/locations?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  LocationList listLocations(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listLocations</code> method in a fluent style.
   */
  public static class ListLocationsQueryParams extends HashMap<String, Object> {
    public ListLocationsQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public ListLocationsQueryParams service(final String value) {
      put("service", EncodingUtils.encode(value));
      return this;
    }
    public ListLocationsQueryParams limit(final Integer value) {
      put("limit", EncodingUtils.encode(value));
      return this;
    }
    public ListLocationsQueryParams before(final String value) {
      put("before", EncodingUtils.encode(value));
      return this;
    }
    public ListLocationsQueryParams after(final String value) {
      put("after", EncodingUtils.encode(value));
      return this;
    }
    public ListLocationsQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Update a location
   * Update an existing location using JsonPatch.
   * @param id  (required)
   * @param body JsonPatch with array of operations (optional)
   * JsonPatch RFC
   * @see <a href="https://tools.ietf.org/html/rfc6902">Update a location Documentation</a>
   */
  @RequestLine("PATCH /v1/locations/{id}")
  @Headers({
      "Content-Type: application/json-patch+json",
      "Accept: application/json",
  })
  void patchLocation(@Param("id") UUID id, Object body);
  /**
   * Restore a soft deleted location.
   * Restore a soft deleted location.
   * @param body  (optional)
   * @return Location
   */
  @RequestLine("PUT /v1/locations/restore")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Location restore14(RestoreEntity body);
}
