package org.openmetadata.client.api;

import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;

import org.openmetadata.client.model.CreateMessagingService;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.MessagingService;
import org.openmetadata.client.model.MessagingServiceList;
import org.openmetadata.client.model.RestoreEntity;
import java.util.UUID;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")public interface MessagingServicesApi extends ApiClient.Api {

  /**
   * Update messaging service
   * Create a new messaging service or Update an existing messaging service identified by &#x60;id&#x60;.
   * @param body  (optional)
   * @return MessagingService
   */
  @RequestLine("PUT /v1/services/messagingServices")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  MessagingService createOrUpdateMessagingService(CreateMessagingService body);
  /**
   * Delete a messaging service
   * Delete a messaging service. If topics belong the service, it can&#x27;t be deleted.
   * @param id Id of the messaging service (required)
   * @param recursive Recursively delete this entity and it&#x27;s children. (Default &#x60;false&#x60;) (optional)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/services/messagingServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteMessagingService(@Param("id") UUID id, @Param("recursive") Boolean recursive, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a messaging service
   * Delete a messaging service. If topics belong the service, it can&#x27;t be deleted.
   * Note, this is equivalent to the other <code>deleteMessagingService</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteMessagingServiceQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id Id of the messaging service (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>recursive - Recursively delete this entity and it&#x27;s children. (Default &#x60;false&#x60;) (optional)</li>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/services/messagingServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteMessagingService(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteMessagingService</code> method in a fluent style.
   */
  public static class DeleteMessagingServiceQueryParams extends HashMap<String, Object> {
    public DeleteMessagingServiceQueryParams recursive(final Boolean value) {
      put("recursive", EncodingUtils.encode(value));
      return this;
    }
    public DeleteMessagingServiceQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Delete a messaging service
   * Delete a messaging service by &#x60;name&#x60;. If topics belong the service, it can&#x27;t be deleted.
   * @param name Name of the messaging service (required)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/services/messagingServices/name/{name}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteMessagingServiceByName(@Param("name") String name, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a messaging service
   * Delete a messaging service by &#x60;name&#x60;. If topics belong the service, it can&#x27;t be deleted.
   * Note, this is equivalent to the other <code>deleteMessagingServiceByName</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteMessagingServiceByNameQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param name Name of the messaging service (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/services/messagingServices/name/{name}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteMessagingServiceByName(@Param("name") String name, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteMessagingServiceByName</code> method in a fluent style.
   */
  public static class DeleteMessagingServiceByNameQueryParams extends HashMap<String, Object> {
    public DeleteMessagingServiceByNameQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get messaging service by name
   * Get a messaging service by the service &#x60;name&#x60;.
   * @param name  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return MessagingService
   */
  @RequestLine("GET /v1/services/messagingServices/name/{name}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  MessagingService getMessagingServiceByFQN(@Param("name") String name, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get messaging service by name
   * Get a messaging service by the service &#x60;name&#x60;.
   * Note, this is equivalent to the other <code>getMessagingServiceByFQN</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetMessagingServiceByFQNQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param name  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return MessagingService

   */
  @RequestLine("GET /v1/services/messagingServices/name/{name}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  MessagingService getMessagingServiceByFQN(@Param("name") String name, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getMessagingServiceByFQN</code> method in a fluent style.
   */
  public static class GetMessagingServiceByFQNQueryParams extends HashMap<String, Object> {
    public GetMessagingServiceByFQNQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetMessagingServiceByFQNQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a messaging service
   * Get a messaging service by &#x60;id&#x60;.
   * @param id  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return MessagingService
   */
  @RequestLine("GET /v1/services/messagingServices/{id}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  MessagingService getMessagingServiceByID(@Param("id") UUID id, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a messaging service
   * Get a messaging service by &#x60;id&#x60;.
   * Note, this is equivalent to the other <code>getMessagingServiceByID</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetMessagingServiceByIDQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return MessagingService

   */
  @RequestLine("GET /v1/services/messagingServices/{id}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  MessagingService getMessagingServiceByID(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getMessagingServiceByID</code> method in a fluent style.
   */
  public static class GetMessagingServiceByIDQueryParams extends HashMap<String, Object> {
    public GetMessagingServiceByIDQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetMessagingServiceByIDQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a version of the messaging service
   * Get a version of the messaging service by given &#x60;id&#x60;
   * @param id messaging service Id (required)
   * @param version messaging service version number in the form &#x60;major&#x60;.&#x60;minor&#x60; (required)
   * @return MessagingService
   */
  @RequestLine("GET /v1/services/messagingServices/{id}/versions/{version}")
  @Headers({
      "Accept: application/json",
  })
  MessagingService getSpecificMessagingServiceVersion(@Param("id") String id, @Param("version") String version);
  /**
   * List messaging service versions
   * Get a list of all the versions of a messaging service identified by &#x60;id&#x60;
   * @param id messaging service Id (required)
   * @return EntityHistory
   */
  @RequestLine("GET /v1/services/messagingServices/{id}/versions")
  @Headers({
      "Accept: application/json",
  })
  EntityHistory listAllMessagingServiceVersion(@Param("id") String id);
  /**
   * List messaging services
   * Get a list of messaging services. Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * @param fields Fields requested in the returned resource (optional)
   * @param limit Limit number services returned. (1 to 1000000, default 10) (optional)
   * @param before Returns list of services before this cursor (optional)
   * @param after Returns list of services after this cursor (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return MessagingServiceList
   */
  @RequestLine("GET /v1/services/messagingServices?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  MessagingServiceList listMessagingService(@Param("fields") String fields, @Param("limit") Integer limit, @Param("before") String before, @Param("after") String after, @Param("include") String include);

  /**
   * List messaging services
   * Get a list of messaging services. Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * Note, this is equivalent to the other <code>listMessagingService</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListMessagingServiceQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>limit - Limit number services returned. (1 to 1000000, default 10) (optional)</li>
   *   <li>before - Returns list of services before this cursor (optional)</li>
   *   <li>after - Returns list of services after this cursor (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return MessagingServiceList

   */
  @RequestLine("GET /v1/services/messagingServices?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  MessagingServiceList listMessagingService(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listMessagingService</code> method in a fluent style.
   */
  public static class ListMessagingServiceQueryParams extends HashMap<String, Object> {
    public ListMessagingServiceQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public ListMessagingServiceQueryParams limit(final Integer value) {
      put("limit", EncodingUtils.encode(value));
      return this;
    }
    public ListMessagingServiceQueryParams before(final String value) {
      put("before", EncodingUtils.encode(value));
      return this;
    }
    public ListMessagingServiceQueryParams after(final String value) {
      put("after", EncodingUtils.encode(value));
      return this;
    }
    public ListMessagingServiceQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Update a Messaging Service
   * Update an existing messaging service using JsonPatch.
   * @param id  (required)
   * @param body JsonPatch with array of operations (optional)
   * JsonPatch RFC
   * @see <a href="https://tools.ietf.org/html/rfc6902">Update a Messaging Service Documentation</a>
   */
  @RequestLine("PATCH /v1/services/messagingServices/{id}")
  @Headers({
      "Content-Type: application/json-patch+json",
      "Accept: application/json",
  })
  void patchMessagingService(@Param("id") UUID id, Object body);
  /**
   * Restore a soft deleted MessagingService.
   * Restore a soft deleted MessagingService.
   * @param body  (optional)
   * @return MessagingService
   */
  @RequestLine("PUT /v1/services/messagingServices/restore")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  MessagingService restore21(RestoreEntity body);
}
