package org.openmetadata.client.api;

import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;

import org.openmetadata.client.model.CreateType;
import org.openmetadata.client.model.CustomProperty;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.Type;
import org.openmetadata.client.model.TypeList;
import java.util.UUID;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")public interface MetadataApi extends ApiClient.Api {

  /**
   * Add or update a Property to an entity
   * Add or update a property to an entity type. Properties can only be added to entity type and not property type.
   * @param id Type Id (required)
   * @param body  (optional)
   */
  @RequestLine("PUT /v1/metadata/types/{id}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void addProperty(@Param("id") String id, CustomProperty body);
  /**
   * Create or update a type
   * Create a new type, if it does not exist or update an existing type.
   * @param body  (optional)
   * @return Type
   */
  @RequestLine("PUT /v1/metadata/types")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Type createOrUpdate1(CreateType body);
  /**
   * Create a type
   * Create a new type.
   * @param body  (optional)
   * @return Type
   */
  @RequestLine("POST /v1/metadata/types")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Type createType(CreateType body);
  /**
   * Delete a type
   * Delete a type by &#x60;id&#x60;.
   * @param id Type Id (required)
   */
  @RequestLine("DELETE /v1/metadata/types/{id}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteType(@Param("id") String id);
  /**
   * Delete a type
   * Delete a type by &#x60;name&#x60;.
   * @param name Name of the type (required)
   */
  @RequestLine("DELETE /v1/metadata/types/name/{name}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteTypeByName(@Param("name") String name);
  /**
   * Get a version of the types
   * Get a version of the type by given &#x60;id&#x60;
   * @param id type Id (required)
   * @param version type version number in the form &#x60;major&#x60;.&#x60;minor&#x60; (required)
   * @return Type
   */
  @RequestLine("GET /v1/metadata/types/{id}/versions/{version}")
  @Headers({
      "Accept: application/json",
  })
  Type getSpecificTypeVersion(@Param("id") String id, @Param("version") String version);
  /**
   * Get a type
   * Get a type by &#x60;id&#x60;.
   * @param id  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return Type
   */
  @RequestLine("GET /v1/metadata/types/{id}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  Type getTypeByID(@Param("id") UUID id, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a type
   * Get a type by &#x60;id&#x60;.
   * Note, this is equivalent to the other <code>getTypeByID</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetTypeByIDQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return Type

   */
  @RequestLine("GET /v1/metadata/types/{id}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  Type getTypeByID(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getTypeByID</code> method in a fluent style.
   */
  public static class GetTypeByIDQueryParams extends HashMap<String, Object> {
    public GetTypeByIDQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetTypeByIDQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a type by name
   * Get a type by name.
   * @param name  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return Type
   */
  @RequestLine("GET /v1/metadata/types/name/{name}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  Type getTypeByName(@Param("name") String name, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a type by name
   * Get a type by name.
   * Note, this is equivalent to the other <code>getTypeByName</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetTypeByNameQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param name  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return Type

   */
  @RequestLine("GET /v1/metadata/types/name/{name}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  Type getTypeByName(@Param("name") String name, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getTypeByName</code> method in a fluent style.
   */
  public static class GetTypeByNameQueryParams extends HashMap<String, Object> {
    public GetTypeByNameQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetTypeByNameQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * List type versions
   * Get a list of all the versions of a type identified by &#x60;id&#x60;
   * @param id type Id (required)
   * @return EntityHistory
   */
  @RequestLine("GET /v1/metadata/types/{id}/versions")
  @Headers({
      "Accept: application/json",
  })
  EntityHistory listAllTypeVersion(@Param("id") String id);
  /**
   * List types
   * Get a list of types. Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * @param category Filter types by metadata type category. (optional)
   * @param limit Limit the number types returned. (1 to 1000000, default &#x3D; 10) (optional)
   * @param before Returns list of types before this cursor (optional)
   * @param after Returns list of types after this cursor (optional)
   * @return TypeList
   */
  @RequestLine("GET /v1/metadata/types?category={category}&limit={limit}&before={before}&after={after}")
  @Headers({
      "Accept: application/json",
  })
  TypeList listTypes(@Param("category") String category, @Param("limit") Integer limit, @Param("before") String before, @Param("after") String after);

  /**
   * List types
   * Get a list of types. Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * Note, this is equivalent to the other <code>listTypes</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListTypesQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>category - Filter types by metadata type category. (optional)</li>
   *   <li>limit - Limit the number types returned. (1 to 1000000, default &#x3D; 10) (optional)</li>
   *   <li>before - Returns list of types before this cursor (optional)</li>
   *   <li>after - Returns list of types after this cursor (optional)</li>
   *   </ul>
   * @return TypeList

   */
  @RequestLine("GET /v1/metadata/types?category={category}&limit={limit}&before={before}&after={after}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  TypeList listTypes(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listTypes</code> method in a fluent style.
   */
  public static class ListTypesQueryParams extends HashMap<String, Object> {
    public ListTypesQueryParams category(final String value) {
      put("category", EncodingUtils.encode(value));
      return this;
    }
    public ListTypesQueryParams limit(final Integer value) {
      put("limit", EncodingUtils.encode(value));
      return this;
    }
    public ListTypesQueryParams before(final String value) {
      put("before", EncodingUtils.encode(value));
      return this;
    }
    public ListTypesQueryParams after(final String value) {
      put("after", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Update a type
   * Update an existing type using JsonPatch.
   * @param id  (required)
   * @param body JsonPatch with array of operations (optional)
   * JsonPatch RFC
   * @see <a href="https://tools.ietf.org/html/rfc6902">Update a type Documentation</a>
   */
  @RequestLine("PATCH /v1/metadata/types/{id}")
  @Headers({
      "Content-Type: application/json-patch+json",
      "Accept: application/json",
  })
  void patchType(@Param("id") UUID id, Object body);
}
