package org.openmetadata.client.api;

import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;

import org.openmetadata.client.model.CreateMetadataService;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.MetadataService;
import org.openmetadata.client.model.MetadataServiceList;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.Table;
import java.util.UUID;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")public interface MetadataServiceApi extends ApiClient.Api {

  /**
   * Create Metadata Service
   * Create a new Metadata Service.
   * @param body  (optional)
   * @return MetadataService
   */
  @RequestLine("POST /v1/services/metadataServices")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  MetadataService createMetadataService(CreateMetadataService body);
  /**
   * Update Metadata Service
   * Update an existing or create a new Metadata Service.
   * @param body  (optional)
   * @return MetadataService
   */
  @RequestLine("PUT /v1/services/metadataServices")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  MetadataService createOrUpdateMetadataService(CreateMetadataService body);
  /**
   * Delete a Metadata Service
   * Delete a metadata services. If some service belong the service, it can&#x27;t be deleted.
   * @param id Id of the Metadata Service (required)
   * @param recursive Recursively delete this entity and it&#x27;s children. (Default &#x60;false&#x60;) (optional)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/services/metadataServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteMetadataService(@Param("id") String id, @Param("recursive") Boolean recursive, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a Metadata Service
   * Delete a metadata services. If some service belong the service, it can&#x27;t be deleted.
   * Note, this is equivalent to the other <code>deleteMetadataService</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteMetadataServiceQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id Id of the Metadata Service (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>recursive - Recursively delete this entity and it&#x27;s children. (Default &#x60;false&#x60;) (optional)</li>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/services/metadataServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteMetadataService(@Param("id") String id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteMetadataService</code> method in a fluent style.
   */
  public static class DeleteMetadataServiceQueryParams extends HashMap<String, Object> {
    public DeleteMetadataServiceQueryParams recursive(final Boolean value) {
      put("recursive", EncodingUtils.encode(value));
      return this;
    }
    public DeleteMetadataServiceQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Delete a Metadata Service
   * Delete a metadata services by &#x60;name&#x60;. If some service belong the service, it can&#x27;t be deleted.
   * @param name Name of the metadata service (required)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/services/metadataServices/name/{name}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteMetadataServiceByName(@Param("name") String name, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a Metadata Service
   * Delete a metadata services by &#x60;name&#x60;. If some service belong the service, it can&#x27;t be deleted.
   * Note, this is equivalent to the other <code>deleteMetadataServiceByName</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteMetadataServiceByNameQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param name Name of the metadata service (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/services/metadataServices/name/{name}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteMetadataServiceByName(@Param("name") String name, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteMetadataServiceByName</code> method in a fluent style.
   */
  public static class DeleteMetadataServiceByNameQueryParams extends HashMap<String, Object> {
    public DeleteMetadataServiceByNameQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get Metadata Service by name
   * Get a Metadata Service by the service &#x60;name&#x60;.
   * @param name  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return MetadataService
   */
  @RequestLine("GET /v1/services/metadataServices/name/{name}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  MetadataService getMetadataServiceByFQN(@Param("name") String name, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get Metadata Service by name
   * Get a Metadata Service by the service &#x60;name&#x60;.
   * Note, this is equivalent to the other <code>getMetadataServiceByFQN</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetMetadataServiceByFQNQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param name  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return MetadataService

   */
  @RequestLine("GET /v1/services/metadataServices/name/{name}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  MetadataService getMetadataServiceByFQN(@Param("name") String name, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getMetadataServiceByFQN</code> method in a fluent style.
   */
  public static class GetMetadataServiceByFQNQueryParams extends HashMap<String, Object> {
    public GetMetadataServiceByFQNQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetMetadataServiceByFQNQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a Metadata Service
   * Get a Metadata Service by &#x60;id&#x60;.
   * @param id  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return MetadataService
   */
  @RequestLine("GET /v1/services/metadataServices/{id}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  MetadataService getMetadataServiceByID(@Param("id") UUID id, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a Metadata Service
   * Get a Metadata Service by &#x60;id&#x60;.
   * Note, this is equivalent to the other <code>getMetadataServiceByID</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetMetadataServiceByIDQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return MetadataService

   */
  @RequestLine("GET /v1/services/metadataServices/{id}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  MetadataService getMetadataServiceByID(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getMetadataServiceByID</code> method in a fluent style.
   */
  public static class GetMetadataServiceByIDQueryParams extends HashMap<String, Object> {
    public GetMetadataServiceByIDQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetMetadataServiceByIDQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a version of the Metadata Service
   * Get a version of the Metadata Service by given &#x60;id&#x60;
   * @param id Metadata Service Id (required)
   * @param version Metadata Service version number in the form &#x60;major&#x60;.&#x60;minor&#x60; (required)
   * @return MetadataService
   */
  @RequestLine("GET /v1/services/metadataServices/{id}/versions/{version}")
  @Headers({
      "Accept: application/json",
  })
  MetadataService getSpecificMetadataServiceVersion(@Param("id") String id, @Param("version") String version);
  /**
   * List Metadata Service versions
   * Get a list of all the versions of a Metadata Service identified by &#x60;id&#x60;
   * @param id Metadata Service Id (required)
   * @return EntityHistory
   */
  @RequestLine("GET /v1/services/metadataServices/{id}/versions")
  @Headers({
      "Accept: application/json",
  })
  EntityHistory listAllMetadataServiceVersion(@Param("id") String id);
  /**
   * List metadata services
   * Get a list of metadata services.
   * @param fields Fields requested in the returned resource (optional)
   * @param limit  (optional)
   * @param before Returns list of metadata services before this cursor (optional)
   * @param after Returns list of metadata services after this cursor (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return MetadataServiceList
   */
  @RequestLine("GET /v1/services/metadataServices?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  MetadataServiceList listMetadataServices(@Param("fields") String fields, @Param("limit") Integer limit, @Param("before") String before, @Param("after") String after, @Param("include") String include);

  /**
   * List metadata services
   * Get a list of metadata services.
   * Note, this is equivalent to the other <code>listMetadataServices</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListMetadataServicesQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>limit -  (optional)</li>
   *   <li>before - Returns list of metadata services before this cursor (optional)</li>
   *   <li>after - Returns list of metadata services after this cursor (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return MetadataServiceList

   */
  @RequestLine("GET /v1/services/metadataServices?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  MetadataServiceList listMetadataServices(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listMetadataServices</code> method in a fluent style.
   */
  public static class ListMetadataServicesQueryParams extends HashMap<String, Object> {
    public ListMetadataServicesQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public ListMetadataServicesQueryParams limit(final Integer value) {
      put("limit", EncodingUtils.encode(value));
      return this;
    }
    public ListMetadataServicesQueryParams before(final String value) {
      put("before", EncodingUtils.encode(value));
      return this;
    }
    public ListMetadataServicesQueryParams after(final String value) {
      put("after", EncodingUtils.encode(value));
      return this;
    }
    public ListMetadataServicesQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Update a Metadata service
   * Update an existing Metadata service using JsonPatch.
   * @param id  (required)
   * @param body JsonPatch with array of operations (optional)
   * JsonPatch RFC
   * @see <a href="https://tools.ietf.org/html/rfc6902">Update a Metadata service Documentation</a>
   */
  @RequestLine("PATCH /v1/services/metadataServices/{id}")
  @Headers({
      "Content-Type: application/json-patch+json",
      "Accept: application/json",
  })
  void patchMetadataService(@Param("id") UUID id, Object body);
  /**
   * Restore a soft deleted metadata service.
   * Restore a soft deleted metadata service.
   * @param body  (optional)
   * @return Table
   */
  @RequestLine("PUT /v1/services/metadataServices/restore")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Table restore22(RestoreEntity body);
}
