package org.openmetadata.client.api;

import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;

import org.openmetadata.client.model.Metrics;
import org.openmetadata.client.model.MetricsList;
import java.util.UUID;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")public interface MetricsApi extends ApiClient.Api {

  /**
   * Create a metric
   * Create a new metric.
   * @param body  (optional)
   * @return Metrics
   */
  @RequestLine("POST /v1/metrics")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Metrics createMetric(Metrics body);
  /**
   * Create or update a metric
   * Create a new metric, if it does not exist or update an existing metric.
   * @param body  (optional)
   * @return Metrics
   */
  @RequestLine("PUT /v1/metrics")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Metrics createOrUpdateMetric(Metrics body);
  /**
   * Get a metric
   * Get a metric by &#x60;id&#x60;.
   * @param id  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return Metrics
   */
  @RequestLine("GET /v1/metrics/{id}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  Metrics getMetricByID(@Param("id") UUID id, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a metric
   * Get a metric by &#x60;id&#x60;.
   * Note, this is equivalent to the other <code>getMetricByID</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetMetricByIDQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return Metrics

   */
  @RequestLine("GET /v1/metrics/{id}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  Metrics getMetricByID(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getMetricByID</code> method in a fluent style.
   */
  public static class GetMetricByIDQueryParams extends HashMap<String, Object> {
    public GetMetricByIDQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetMetricByIDQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * List metrics
   * Get a list of metrics. Use &#x60;fields&#x60; parameter to get only necessary fields.
   * @param fields Fields requested in the returned resource (optional)
   * @param limit  (optional)
   * @param before Returns list of metrics before this cursor (optional)
   * @param after Returns list of metrics after this cursor (optional)
   * @return MetricsList
   */
  @RequestLine("GET /v1/metrics?fields={fields}&limit={limit}&before={before}&after={after}")
  @Headers({
      "Accept: application/json",
  })
  MetricsList listMetrics(@Param("fields") String fields, @Param("limit") Integer limit, @Param("before") String before, @Param("after") String after);

  /**
   * List metrics
   * Get a list of metrics. Use &#x60;fields&#x60; parameter to get only necessary fields.
   * Note, this is equivalent to the other <code>listMetrics</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListMetricsQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>limit -  (optional)</li>
   *   <li>before - Returns list of metrics before this cursor (optional)</li>
   *   <li>after - Returns list of metrics after this cursor (optional)</li>
   *   </ul>
   * @return MetricsList

   */
  @RequestLine("GET /v1/metrics?fields={fields}&limit={limit}&before={before}&after={after}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  MetricsList listMetrics(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listMetrics</code> method in a fluent style.
   */
  public static class ListMetricsQueryParams extends HashMap<String, Object> {
    public ListMetricsQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public ListMetricsQueryParams limit(final Integer value) {
      put("limit", EncodingUtils.encode(value));
      return this;
    }
    public ListMetricsQueryParams before(final String value) {
      put("before", EncodingUtils.encode(value));
      return this;
    }
    public ListMetricsQueryParams after(final String value) {
      put("after", EncodingUtils.encode(value));
      return this;
    }
  }
}
