package org.openmetadata.client.api;

import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;

import org.openmetadata.client.model.CreateMlModelService;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.MlModelService;
import org.openmetadata.client.model.MlModelServiceList;
import org.openmetadata.client.model.RestoreEntity;
import java.util.UUID;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")public interface MlModelServicesApi extends ApiClient.Api {

  /**
   * Update mlModel service
   * Create a new mlModel service or update an existing mlModel service identified by &#x60;id&#x60;.
   * @param body  (optional)
   * @return MlModelService
   */
  @RequestLine("PUT /v1/services/mlmodelServices")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  MlModelService createOrUpdateMlModelService(CreateMlModelService body);
  /**
   * Delete a mlModel service
   * Delete a mlModel services. If mlModels (and tasks) belong to the service, it can&#x27;t be deleted.
   * @param id Id of the mlModel service (required)
   * @param recursive Recursively delete this entity and it&#x27;s children. (Default &#x60;false&#x60;) (optional)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/services/mlmodelServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteMlModelService(@Param("id") UUID id, @Param("recursive") Boolean recursive, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a mlModel service
   * Delete a mlModel services. If mlModels (and tasks) belong to the service, it can&#x27;t be deleted.
   * Note, this is equivalent to the other <code>deleteMlModelService</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteMlModelServiceQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id Id of the mlModel service (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>recursive - Recursively delete this entity and it&#x27;s children. (Default &#x60;false&#x60;) (optional)</li>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/services/mlmodelServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteMlModelService(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteMlModelService</code> method in a fluent style.
   */
  public static class DeleteMlModelServiceQueryParams extends HashMap<String, Object> {
    public DeleteMlModelServiceQueryParams recursive(final Boolean value) {
      put("recursive", EncodingUtils.encode(value));
      return this;
    }
    public DeleteMlModelServiceQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Delete a mlModel service
   * Delete a mlModel services by &#x60;name&#x60;. If mlModels (and tasks) belong to the service, it can&#x27;t be deleted.
   * @param name Name of the ML model service (required)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/services/mlmodelServices/name/{name}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteMlModelServiceByName(@Param("name") String name, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a mlModel service
   * Delete a mlModel services by &#x60;name&#x60;. If mlModels (and tasks) belong to the service, it can&#x27;t be deleted.
   * Note, this is equivalent to the other <code>deleteMlModelServiceByName</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteMlModelServiceByNameQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param name Name of the ML model service (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/services/mlmodelServices/name/{name}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteMlModelServiceByName(@Param("name") String name, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteMlModelServiceByName</code> method in a fluent style.
   */
  public static class DeleteMlModelServiceByNameQueryParams extends HashMap<String, Object> {
    public DeleteMlModelServiceByNameQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get mlModel service by name
   * Get a mlModel service by the service &#x60;name&#x60;.
   * @param name  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return MlModelService
   */
  @RequestLine("GET /v1/services/mlmodelServices/name/{name}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  MlModelService getMlModelServiceByFQN(@Param("name") String name, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get mlModel service by name
   * Get a mlModel service by the service &#x60;name&#x60;.
   * Note, this is equivalent to the other <code>getMlModelServiceByFQN</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetMlModelServiceByFQNQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param name  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return MlModelService

   */
  @RequestLine("GET /v1/services/mlmodelServices/name/{name}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  MlModelService getMlModelServiceByFQN(@Param("name") String name, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getMlModelServiceByFQN</code> method in a fluent style.
   */
  public static class GetMlModelServiceByFQNQueryParams extends HashMap<String, Object> {
    public GetMlModelServiceByFQNQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetMlModelServiceByFQNQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a mlModel service
   * Get a mlModel service by &#x60;id&#x60;.
   * @param id  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return MlModelService
   */
  @RequestLine("GET /v1/services/mlmodelServices/{id}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  MlModelService getMlModelServiceByID(@Param("id") UUID id, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a mlModel service
   * Get a mlModel service by &#x60;id&#x60;.
   * Note, this is equivalent to the other <code>getMlModelServiceByID</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetMlModelServiceByIDQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return MlModelService

   */
  @RequestLine("GET /v1/services/mlmodelServices/{id}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  MlModelService getMlModelServiceByID(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getMlModelServiceByID</code> method in a fluent style.
   */
  public static class GetMlModelServiceByIDQueryParams extends HashMap<String, Object> {
    public GetMlModelServiceByIDQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetMlModelServiceByIDQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a version of the mlModel service
   * Get a version of the mlModel service by given &#x60;id&#x60;
   * @param id mlModel service Id (required)
   * @param version mlModel service version number in the form &#x60;major&#x60;.&#x60;minor&#x60; (required)
   * @return MlModelService
   */
  @RequestLine("GET /v1/services/mlmodelServices/{id}/versions/{version}")
  @Headers({
      "Accept: application/json",
  })
  MlModelService getSpecificMlModelService(@Param("id") UUID id, @Param("version") String version);
  /**
   * List mlModel service versions
   * Get a list of all the versions of a mlModel service identified by &#x60;id&#x60;
   * @param id mlModel service Id (required)
   * @return EntityHistory
   */
  @RequestLine("GET /v1/services/mlmodelServices/{id}/versions")
  @Headers({
      "Accept: application/json",
  })
  EntityHistory listAllMlModelServiceVersion(@Param("id") String id);
  /**
   * List mlModel services
   * Get a list of mlModel services. Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * @param fields Fields requested in the returned resource (optional)
   * @param limit Limit number services returned. (1 to 1000000, default 10) (optional)
   * @param before Returns list of services before this cursor (optional)
   * @param after Returns list of services after this cursor (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return MlModelServiceList
   */
  @RequestLine("GET /v1/services/mlmodelServices?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  MlModelServiceList listMlModelService(@Param("fields") String fields, @Param("limit") Integer limit, @Param("before") String before, @Param("after") String after, @Param("include") String include);

  /**
   * List mlModel services
   * Get a list of mlModel services. Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * Note, this is equivalent to the other <code>listMlModelService</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListMlModelServiceQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>limit - Limit number services returned. (1 to 1000000, default 10) (optional)</li>
   *   <li>before - Returns list of services before this cursor (optional)</li>
   *   <li>after - Returns list of services after this cursor (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return MlModelServiceList

   */
  @RequestLine("GET /v1/services/mlmodelServices?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  MlModelServiceList listMlModelService(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listMlModelService</code> method in a fluent style.
   */
  public static class ListMlModelServiceQueryParams extends HashMap<String, Object> {
    public ListMlModelServiceQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public ListMlModelServiceQueryParams limit(final Integer value) {
      put("limit", EncodingUtils.encode(value));
      return this;
    }
    public ListMlModelServiceQueryParams before(final String value) {
      put("before", EncodingUtils.encode(value));
      return this;
    }
    public ListMlModelServiceQueryParams after(final String value) {
      put("after", EncodingUtils.encode(value));
      return this;
    }
    public ListMlModelServiceQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Update a MlModel service
   * Update an existing MlModelService service using JsonPatch.
   * @param id  (required)
   * @param body JsonPatch with array of operations (optional)
   * JsonPatch RFC
   * @see <a href="https://tools.ietf.org/html/rfc6902">Update a MlModel service Documentation</a>
   */
  @RequestLine("PATCH /v1/services/mlmodelServices/{id}")
  @Headers({
      "Content-Type: application/json-patch+json",
      "Accept: application/json",
  })
  void patchMlModelService(@Param("id") UUID id, Object body);
  /**
   * Restore a soft deleted MlModelService.
   * Restore a soft deleted MlModelService.
   * @param body  (optional)
   * @return MlModelService
   */
  @RequestLine("PUT /v1/services/mlmodelServices/restore")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  MlModelService restore23(RestoreEntity body);
}
