package org.openmetadata.client.api;

import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;

import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateMlModel;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.MlModel;
import org.openmetadata.client.model.MlModelList;
import org.openmetadata.client.model.RestoreEntity;
import java.util.UUID;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")public interface MlModelsApi extends ApiClient.Api {

  /**
   * Add a follower
   * Add a user identified by &#x60;userId&#x60; as follower of this model
   * @param id Id of the model (required)
   * @param body Id of the user to be added as follower (optional)
   * @return ChangeEvent
   */
  @RequestLine("PUT /v1/mlmodels/{id}/followers")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  ChangeEvent addFollower1(@Param("id") UUID id, UUID body);
  /**
   * Create an ML Model
   * Create a new ML Model.
   * @param body  (optional)
   * @return MlModel
   */
  @RequestLine("POST /v1/mlmodels")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  MlModel createMlModel(CreateMlModel body);
  /**
   * Create or update an ML Model
   * Create a new ML Model, if it does not exist or update an existing model.
   * @param body  (optional)
   * @return MlModel
   */
  @RequestLine("PUT /v1/mlmodels")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  MlModel createOrUpdateMlModel(CreateMlModel body);
  /**
   * Remove a follower
   * Remove the user identified &#x60;userId&#x60; as a follower of the model.
   * @param id Id of the model (required)
   * @param userId Id of the user being removed as follower (required)
   * @return ChangeEvent
   */
  @RequestLine("DELETE /v1/mlmodels/{id}/followers/{userId}")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  ChangeEvent deleteFollower2(@Param("id") String id, @Param("userId") String userId);
  /**
   * Delete an ML Model
   * Delete an ML Model by &#x60;id&#x60;.
   * @param id ML Model Id (required)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/mlmodels/{id}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteMlModel(@Param("id") UUID id, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete an ML Model
   * Delete an ML Model by &#x60;id&#x60;.
   * Note, this is equivalent to the other <code>deleteMlModel</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteMlModelQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id ML Model Id (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/mlmodels/{id}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteMlModel(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteMlModel</code> method in a fluent style.
   */
  public static class DeleteMlModelQueryParams extends HashMap<String, Object> {
    public DeleteMlModelQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Delete an ML Model
   * Delete an ML Model by &#x60;fullyQualifiedName&#x60;.
   * @param fqn Name of the ML model (required)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/mlmodels/name/{fqn}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteMlModelByFQN(@Param("fqn") String fqn, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete an ML Model
   * Delete an ML Model by &#x60;fullyQualifiedName&#x60;.
   * Note, this is equivalent to the other <code>deleteMlModelByFQN</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteMlModelByFQNQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param fqn Name of the ML model (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/mlmodels/name/{fqn}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteMlModelByFQN(@Param("fqn") String fqn, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteMlModelByFQN</code> method in a fluent style.
   */
  public static class DeleteMlModelByFQNQueryParams extends HashMap<String, Object> {
    public DeleteMlModelByFQNQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get an ML Model by name
   * Get an ML Model by fully qualified name.
   * @param fqn  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return MlModel
   */
  @RequestLine("GET /v1/mlmodels/name/{fqn}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  MlModel getMlModelByFQN(@Param("fqn") String fqn, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get an ML Model by name
   * Get an ML Model by fully qualified name.
   * Note, this is equivalent to the other <code>getMlModelByFQN</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetMlModelByFQNQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param fqn  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return MlModel

   */
  @RequestLine("GET /v1/mlmodels/name/{fqn}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  MlModel getMlModelByFQN(@Param("fqn") String fqn, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getMlModelByFQN</code> method in a fluent style.
   */
  public static class GetMlModelByFQNQueryParams extends HashMap<String, Object> {
    public GetMlModelByFQNQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetMlModelByFQNQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get an ML Model
   * Get an ML Model by &#x60;id&#x60;.
   * @param id  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return MlModel
   */
  @RequestLine("GET /v1/mlmodels/{id}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  MlModel getMlModelByID(@Param("id") UUID id, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get an ML Model
   * Get an ML Model by &#x60;id&#x60;.
   * Note, this is equivalent to the other <code>getMlModelByID</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetMlModelByIDQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return MlModel

   */
  @RequestLine("GET /v1/mlmodels/{id}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  MlModel getMlModelByID(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getMlModelByID</code> method in a fluent style.
   */
  public static class GetMlModelByIDQueryParams extends HashMap<String, Object> {
    public GetMlModelByIDQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetMlModelByIDQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a version of the ML Model
   * Get a version of the ML Model by given &#x60;id&#x60;
   * @param id ML Model Id (required)
   * @param version ML Model version number in the form &#x60;major&#x60;.&#x60;minor&#x60; (required)
   * @return MlModel
   */
  @RequestLine("GET /v1/mlmodels/{id}/versions/{version}")
  @Headers({
      "Accept: application/json",
  })
  MlModel getSpecificMlModelVersion(@Param("id") String id, @Param("version") String version);
  /**
   * List Ml Model versions
   * Get a list of all the versions of an Ml Model identified by &#x60;id&#x60;
   * @param id ML Model Id (required)
   * @return EntityHistory
   */
  @RequestLine("GET /v1/mlmodels/{id}/versions")
  @Headers({
      "Accept: application/json",
  })
  EntityHistory listAllMlModelVersion(@Param("id") String id);
  /**
   * List ML Models
   * Get a list of mlmodels, optionally filtered by &#x60;service&#x60; it belongs to. Use &#x60;fields&#x60; parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * @param fields Fields requested in the returned resource (optional)
   * @param service Filter MlModels by service name (optional)
   * @param limit Limit the number models returned. (1 to 1000000, default &#x3D; 10) (optional)
   * @param before Returns list of models before this cursor (optional)
   * @param after Returns list of models after this cursor (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return MlModelList
   */
  @RequestLine("GET /v1/mlmodels?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  MlModelList listMlModels(@Param("fields") String fields, @Param("service") String service, @Param("limit") Integer limit, @Param("before") String before, @Param("after") String after, @Param("include") String include);

  /**
   * List ML Models
   * Get a list of mlmodels, optionally filtered by &#x60;service&#x60; it belongs to. Use &#x60;fields&#x60; parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * Note, this is equivalent to the other <code>listMlModels</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListMlModelsQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>service - Filter MlModels by service name (optional)</li>
   *   <li>limit - Limit the number models returned. (1 to 1000000, default &#x3D; 10) (optional)</li>
   *   <li>before - Returns list of models before this cursor (optional)</li>
   *   <li>after - Returns list of models after this cursor (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return MlModelList

   */
  @RequestLine("GET /v1/mlmodels?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  MlModelList listMlModels(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listMlModels</code> method in a fluent style.
   */
  public static class ListMlModelsQueryParams extends HashMap<String, Object> {
    public ListMlModelsQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public ListMlModelsQueryParams service(final String value) {
      put("service", EncodingUtils.encode(value));
      return this;
    }
    public ListMlModelsQueryParams limit(final Integer value) {
      put("limit", EncodingUtils.encode(value));
      return this;
    }
    public ListMlModelsQueryParams before(final String value) {
      put("before", EncodingUtils.encode(value));
      return this;
    }
    public ListMlModelsQueryParams after(final String value) {
      put("after", EncodingUtils.encode(value));
      return this;
    }
    public ListMlModelsQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Update an ML Model
   * Update an existing ML Model using JsonPatch.
   * @param id Id of the ML Model (required)
   * @param body JsonPatch with array of operations (optional)
   * JsonPatch RFC
   * @see <a href="https://tools.ietf.org/html/rfc6902">Update an ML Model Documentation</a>
   */
  @RequestLine("PATCH /v1/mlmodels/{id}")
  @Headers({
      "Content-Type: application/json-patch+json",
      "Accept: application/json",
  })
  void patchMlModel(@Param("id") String id, Object body);
  /**
   * Restore a soft deleted MlModel.
   * Restore a soft deleted MlModel.
   * @param body  (optional)
   * @return MlModel
   */
  @RequestLine("PUT /v1/mlmodels/restore")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  MlModel restore15(RestoreEntity body);
}
