package org.openmetadata.client.api;

import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;

import org.openmetadata.client.model.CreatePipelineService;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.PipelineService;
import org.openmetadata.client.model.PipelineServiceList;
import org.openmetadata.client.model.RestoreEntity;
import java.util.UUID;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")public interface PipelineServicesApi extends ApiClient.Api {

  /**
   * Update pipeline service
   * Create a new pipeline service or update an existing pipeline service identified by &#x60;id&#x60;.
   * @param body  (optional)
   * @return PipelineService
   */
  @RequestLine("PUT /v1/services/pipelineServices")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  PipelineService createOrUpdatePipelineService(CreatePipelineService body);
  /**
   * Create a pipeline service
   * Create a new pipeline service.
   * @param body  (optional)
   * @return PipelineService
   */
  @RequestLine("POST /v1/services/pipelineServices")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  PipelineService createPipelineService(CreatePipelineService body);
  /**
   * Delete a pipeline service
   * Delete a pipeline services. If pipelines (and tasks) belong to the service, it can&#x27;t be deleted.
   * @param id Id of the pipeline service (required)
   * @param recursive Recursively delete this entity and it&#x27;s children. (Default &#x60;false&#x60;) (optional)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/services/pipelineServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deletePipelineService(@Param("id") String id, @Param("recursive") Boolean recursive, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a pipeline service
   * Delete a pipeline services. If pipelines (and tasks) belong to the service, it can&#x27;t be deleted.
   * Note, this is equivalent to the other <code>deletePipelineService</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeletePipelineServiceQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id Id of the pipeline service (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>recursive - Recursively delete this entity and it&#x27;s children. (Default &#x60;false&#x60;) (optional)</li>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/services/pipelineServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deletePipelineService(@Param("id") String id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deletePipelineService</code> method in a fluent style.
   */
  public static class DeletePipelineServiceQueryParams extends HashMap<String, Object> {
    public DeletePipelineServiceQueryParams recursive(final Boolean value) {
      put("recursive", EncodingUtils.encode(value));
      return this;
    }
    public DeletePipelineServiceQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Delete a pipeline service
   * Delete a pipeline services by &#x60;name&#x60;. If pipelines (and tasks) belong to the service, it can&#x27;t be deleted.
   * @param name Name of the pipeline service (required)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/services/pipelineServices/name/{name}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deletePipelineServiceByName(@Param("name") String name, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a pipeline service
   * Delete a pipeline services by &#x60;name&#x60;. If pipelines (and tasks) belong to the service, it can&#x27;t be deleted.
   * Note, this is equivalent to the other <code>deletePipelineServiceByName</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeletePipelineServiceByNameQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param name Name of the pipeline service (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/services/pipelineServices/name/{name}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deletePipelineServiceByName(@Param("name") String name, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deletePipelineServiceByName</code> method in a fluent style.
   */
  public static class DeletePipelineServiceByNameQueryParams extends HashMap<String, Object> {
    public DeletePipelineServiceByNameQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get pipeline service by name
   * Get a pipeline service by the service &#x60;name&#x60;.
   * @param name  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return PipelineService
   */
  @RequestLine("GET /v1/services/pipelineServices/name/{name}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  PipelineService getPipelineServiceByFQN(@Param("name") String name, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get pipeline service by name
   * Get a pipeline service by the service &#x60;name&#x60;.
   * Note, this is equivalent to the other <code>getPipelineServiceByFQN</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetPipelineServiceByFQNQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param name  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return PipelineService

   */
  @RequestLine("GET /v1/services/pipelineServices/name/{name}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  PipelineService getPipelineServiceByFQN(@Param("name") String name, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getPipelineServiceByFQN</code> method in a fluent style.
   */
  public static class GetPipelineServiceByFQNQueryParams extends HashMap<String, Object> {
    public GetPipelineServiceByFQNQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetPipelineServiceByFQNQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a pipeline service
   * Get a pipeline service by &#x60;id&#x60;.
   * @param id  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return PipelineService
   */
  @RequestLine("GET /v1/services/pipelineServices/{id}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  PipelineService getPipelineServiceByID(@Param("id") UUID id, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a pipeline service
   * Get a pipeline service by &#x60;id&#x60;.
   * Note, this is equivalent to the other <code>getPipelineServiceByID</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetPipelineServiceByIDQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return PipelineService

   */
  @RequestLine("GET /v1/services/pipelineServices/{id}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  PipelineService getPipelineServiceByID(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getPipelineServiceByID</code> method in a fluent style.
   */
  public static class GetPipelineServiceByIDQueryParams extends HashMap<String, Object> {
    public GetPipelineServiceByIDQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetPipelineServiceByIDQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a version of the pipeline service
   * Get a version of the pipeline service by given &#x60;id&#x60;
   * @param id pipeline service Id (required)
   * @param version pipeline service version number in the form &#x60;major&#x60;.&#x60;minor&#x60; (required)
   * @return PipelineService
   */
  @RequestLine("GET /v1/services/pipelineServices/{id}/versions/{version}")
  @Headers({
      "Accept: application/json",
  })
  PipelineService getSpecificPipelineService(@Param("id") String id, @Param("version") String version);
  /**
   * List pipeline service versions
   * Get a list of all the versions of a pipeline service identified by &#x60;id&#x60;
   * @param id pipeline service Id (required)
   * @return EntityHistory
   */
  @RequestLine("GET /v1/services/pipelineServices/{id}/versions")
  @Headers({
      "Accept: application/json",
  })
  EntityHistory listAllPipelineServiceVersion(@Param("id") String id);
  /**
   * List pipeline services
   * Get a list of pipeline services. Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * @param fields Fields requested in the returned resource (optional)
   * @param limit Limit number services returned. (1 to 1000000, default 10) (optional)
   * @param before Returns list of services before this cursor (optional)
   * @param after Returns list of services after this cursor (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return PipelineServiceList
   */
  @RequestLine("GET /v1/services/pipelineServices?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  PipelineServiceList listPipelineService(@Param("fields") String fields, @Param("limit") Integer limit, @Param("before") String before, @Param("after") String after, @Param("include") String include);

  /**
   * List pipeline services
   * Get a list of pipeline services. Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * Note, this is equivalent to the other <code>listPipelineService</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListPipelineServiceQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>limit - Limit number services returned. (1 to 1000000, default 10) (optional)</li>
   *   <li>before - Returns list of services before this cursor (optional)</li>
   *   <li>after - Returns list of services after this cursor (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return PipelineServiceList

   */
  @RequestLine("GET /v1/services/pipelineServices?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  PipelineServiceList listPipelineService(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listPipelineService</code> method in a fluent style.
   */
  public static class ListPipelineServiceQueryParams extends HashMap<String, Object> {
    public ListPipelineServiceQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public ListPipelineServiceQueryParams limit(final Integer value) {
      put("limit", EncodingUtils.encode(value));
      return this;
    }
    public ListPipelineServiceQueryParams before(final String value) {
      put("before", EncodingUtils.encode(value));
      return this;
    }
    public ListPipelineServiceQueryParams after(final String value) {
      put("after", EncodingUtils.encode(value));
      return this;
    }
    public ListPipelineServiceQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Update a Pipeline Service
   * Update an existing pipeline service using JsonPatch.
   * @param id  (required)
   * @param body JsonPatch with array of operations (optional)
   * JsonPatch RFC
   * @see <a href="https://tools.ietf.org/html/rfc6902">Update a Pipeline Service Documentation</a>
   */
  @RequestLine("PATCH /v1/services/pipelineServices/{id}")
  @Headers({
      "Content-Type: application/json-patch+json",
      "Accept: application/json",
  })
  void patchPipelineService(@Param("id") UUID id, Object body);
  /**
   * Restore a soft deleted PipelineService.
   * Restore a soft deleted PipelineService.
   * @param body  (optional)
   * @return PipelineService
   */
  @RequestLine("PUT /v1/services/pipelineServices/restore")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  PipelineService restore24(RestoreEntity body);
}
