package org.openmetadata.client.api;

import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;

import org.openmetadata.client.model.CreatePolicy;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.Policy;
import org.openmetadata.client.model.PolicyList;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.ResultListFunction;
import org.openmetadata.client.model.ResultListResourceDescriptor;
import java.util.UUID;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")public interface PoliciesApi extends ApiClient.Api {

  /**
   * Create or update a policy
   * Create a new policy, if it does not exist or update an existing policy.
   * @param body  (optional)
   * @return Policy
   */
  @RequestLine("PUT /v1/policies")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Policy createOrUpdatePolicy(CreatePolicy body);
  /**
   * Create a policy
   * Create a new policy.
   * @param body  (optional)
   * @return Policy
   */
  @RequestLine("POST /v1/policies")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Policy createPolicy(CreatePolicy body);
  /**
   * Delete a Policy
   * Delete a policy by &#x60;id&#x60;.
   * @param id Policy Id (required)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/policies/{id}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deletePolicy(@Param("id") UUID id, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a Policy
   * Delete a policy by &#x60;id&#x60;.
   * Note, this is equivalent to the other <code>deletePolicy</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeletePolicyQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id Policy Id (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/policies/{id}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deletePolicy(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deletePolicy</code> method in a fluent style.
   */
  public static class DeletePolicyQueryParams extends HashMap<String, Object> {
    public DeletePolicyQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Delete a Policy
   * Delete a policy by &#x60;fullyQualifiedName&#x60;.
   * @param fqn Name of the policy (required)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/policies/name/{fqn}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deletePolicyByFQN(@Param("fqn") String fqn, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a Policy
   * Delete a policy by &#x60;fullyQualifiedName&#x60;.
   * Note, this is equivalent to the other <code>deletePolicyByFQN</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeletePolicyByFQNQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param fqn Name of the policy (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/policies/name/{fqn}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deletePolicyByFQN(@Param("fqn") String fqn, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deletePolicyByFQN</code> method in a fluent style.
   */
  public static class DeletePolicyByFQNQueryParams extends HashMap<String, Object> {
    public DeletePolicyByFQNQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a policy by name
   * Get a policy by fully qualified name.
   * @param fqn  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return Policy
   */
  @RequestLine("GET /v1/policies/name/{fqn}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  Policy getPolicyByFQN(@Param("fqn") String fqn, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a policy by name
   * Get a policy by fully qualified name.
   * Note, this is equivalent to the other <code>getPolicyByFQN</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetPolicyByFQNQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param fqn  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return Policy

   */
  @RequestLine("GET /v1/policies/name/{fqn}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  Policy getPolicyByFQN(@Param("fqn") String fqn, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getPolicyByFQN</code> method in a fluent style.
   */
  public static class GetPolicyByFQNQueryParams extends HashMap<String, Object> {
    public GetPolicyByFQNQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetPolicyByFQNQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a policy
   * Get a policy by &#x60;id&#x60;.
   * @param id  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return Policy
   */
  @RequestLine("GET /v1/policies/{id}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  Policy getPolicyByID(@Param("id") UUID id, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a policy
   * Get a policy by &#x60;id&#x60;.
   * Note, this is equivalent to the other <code>getPolicyByID</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetPolicyByIDQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return Policy

   */
  @RequestLine("GET /v1/policies/{id}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  Policy getPolicyByID(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getPolicyByID</code> method in a fluent style.
   */
  public static class GetPolicyByIDQueryParams extends HashMap<String, Object> {
    public GetPolicyByIDQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetPolicyByIDQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a version of the policy
   * Get a version of the policy by given &#x60;id&#x60;
   * @param id policy Id (required)
   * @param version policy version number in the form &#x60;major&#x60;.&#x60;minor&#x60; (required)
   * @return Policy
   */
  @RequestLine("GET /v1/policies/{id}/versions/{version}")
  @Headers({
      "Accept: application/json",
  })
  Policy getSpecificPolicyVersion(@Param("id") String id, @Param("version") String version);
  /**
   * List policy versions
   * Get a list of all the versions of a policy identified by &#x60;id&#x60;
   * @param id policy Id (required)
   * @return EntityHistory
   */
  @RequestLine("GET /v1/policies/{id}/versions")
  @Headers({
      "Accept: application/json",
  })
  EntityHistory listAllPolicyVersion(@Param("id") String id);
  /**
   * List Policies
   * Get a list of policies. Use &#x60;fields&#x60; parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * @param fields Fields requested in the returned resource (optional)
   * @param limit Limit the number policies returned. (1 to 1000000, default &#x3D; 10) (optional)
   * @param before Returns list of policies before this cursor (optional)
   * @param after Returns list of policies after this cursor (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return PolicyList
   */
  @RequestLine("GET /v1/policies?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  PolicyList listPolicies(@Param("fields") String fields, @Param("limit") Integer limit, @Param("before") String before, @Param("after") String after, @Param("include") String include);

  /**
   * List Policies
   * Get a list of policies. Use &#x60;fields&#x60; parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * Note, this is equivalent to the other <code>listPolicies</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListPoliciesQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>limit - Limit the number policies returned. (1 to 1000000, default &#x3D; 10) (optional)</li>
   *   <li>before - Returns list of policies before this cursor (optional)</li>
   *   <li>after - Returns list of policies after this cursor (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return PolicyList

   */
  @RequestLine("GET /v1/policies?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  PolicyList listPolicies(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listPolicies</code> method in a fluent style.
   */
  public static class ListPoliciesQueryParams extends HashMap<String, Object> {
    public ListPoliciesQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public ListPoliciesQueryParams limit(final Integer value) {
      put("limit", EncodingUtils.encode(value));
      return this;
    }
    public ListPoliciesQueryParams before(final String value) {
      put("before", EncodingUtils.encode(value));
      return this;
    }
    public ListPoliciesQueryParams after(final String value) {
      put("after", EncodingUtils.encode(value));
      return this;
    }
    public ListPoliciesQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get list of policy functions used in authoring conditions in policy rules.
   * Get list of policy functions used in authoring conditions in policy rules.
   * @return ResultListFunction
   */
  @RequestLine("GET /v1/policies/functions")
  @Headers({
      "Accept: application/json",
  })
  ResultListFunction listPolicyFunctions();
  /**
   * Get list of policy resources used in authoring a policy.
   * Get list of policy resources used in authoring a policy.
   * @return ResultListResourceDescriptor
   */
  @RequestLine("GET /v1/policies/resources")
  @Headers({
      "Accept: application/json",
  })
  ResultListResourceDescriptor listPolicyResources();
  /**
   * Update a policy
   * Update an existing policy using JsonPatch.
   * @param id  (required)
   * @param body JsonPatch with array of operations (optional)
   * JsonPatch RFC
   * @see <a href="https://tools.ietf.org/html/rfc6902">Update a policy Documentation</a>
   */
  @RequestLine("PATCH /v1/policies/{id}")
  @Headers({
      "Content-Type: application/json-patch+json",
      "Accept: application/json",
  })
  void patchPolicy(@Param("id") UUID id, Object body);
  /**
   * Restore a soft deleted policy.
   * Restore a soft deleted policy.
   * @param body  (optional)
   * @return Policy
   */
  @RequestLine("PUT /v1/policies/restore")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Policy restore17(RestoreEntity body);
  /**
   * Validate a given condition
   * Validate a given condition expression used in filtering rules.
   * @param expression  (required)
   */
  @RequestLine("GET /v1/alerts/validation/condition/{expression}")
  @Headers({
      "Accept: */*",
  })
  void validateCondition(@Param("expression") String expression);
  /**
   * Validate a given condition
   * Validate a given condition expression used in authoring rules.
   * @param expression  (required)
   */
  @RequestLine("GET /v1/policies/validation/condition/{expression}")
  @Headers({
      "Accept: */*",
  })
  void validateCondition1(@Param("expression") String expression);
}
