package org.openmetadata.client.api;

import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;

import java.math.BigDecimal;
import org.openmetadata.client.model.ReportData;
import org.openmetadata.client.model.ReportDataResultList;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")public interface ReportDataApi extends ApiClient.Api {

  /**
   * Add report data
   * Add report data
   * @param body  (optional)
   * @return ReportData
   */
  @RequestLine("POST /v1/analytic/reportData")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  ReportData addReportData(ReportData body);
  /**
   * List the report data
   * Get a list of all the report data for a given reportDataType, optionally filtered by  &#x60;startTs&#x60; and &#x60;endTs&#x60; of the result. Use cursor-based pagination to limit the number of entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * @param reportDataType report data type (optional)
   * @param startTs Filter reportData results after the given start timestamp (optional)
   * @param endTs Filter reportData results before the given end timestamp (optional)
   * @return ReportDataResultList
   */
  @RequestLine("GET /v1/analytic/reportData?reportDataType={reportDataType}&startTs={startTs}&endTs={endTs}")
  @Headers({
      "Accept: application/json",
  })
  ReportDataResultList getReportData(@Param("reportDataType") String reportDataType, @Param("startTs") BigDecimal startTs, @Param("endTs") BigDecimal endTs);

  /**
   * List the report data
   * Get a list of all the report data for a given reportDataType, optionally filtered by  &#x60;startTs&#x60; and &#x60;endTs&#x60; of the result. Use cursor-based pagination to limit the number of entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * Note, this is equivalent to the other <code>getReportData</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetReportDataQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>reportDataType - report data type (optional)</li>
   *   <li>startTs - Filter reportData results after the given start timestamp (optional)</li>
   *   <li>endTs - Filter reportData results before the given end timestamp (optional)</li>
   *   </ul>
   * @return ReportDataResultList

   */
  @RequestLine("GET /v1/analytic/reportData?reportDataType={reportDataType}&startTs={startTs}&endTs={endTs}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  ReportDataResultList getReportData(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getReportData</code> method in a fluent style.
   */
  public static class GetReportDataQueryParams extends HashMap<String, Object> {
    public GetReportDataQueryParams reportDataType(final String value) {
      put("reportDataType", EncodingUtils.encode(value));
      return this;
    }
    public GetReportDataQueryParams startTs(final BigDecimal value) {
      put("startTs", EncodingUtils.encode(value));
      return this;
    }
    public GetReportDataQueryParams endTs(final BigDecimal value) {
      put("endTs", EncodingUtils.encode(value));
      return this;
    }
  }
}
