package org.openmetadata.client.api;

import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;

import org.openmetadata.client.model.Report;
import org.openmetadata.client.model.ReportList;
import java.util.UUID;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")public interface ReportsApi extends ApiClient.Api {

  /**
   * Create or update a report
   * Create a new report, it it does not exist or update an existing report.
   * @param body  (optional)
   * @return Report
   */
  @RequestLine("PUT /v1/reports")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Report createOrUpdateReport(Report body);
  /**
   * Create a report
   * Create a new report.
   * @param body  (optional)
   * @return Report
   */
  @RequestLine("POST /v1/reports")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Report getReportByFQN(Report body);
  /**
   * Get a report
   * Get a report by &#x60;id&#x60;.
   * @param id  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return Report
   */
  @RequestLine("GET /v1/reports/{id}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  Report getReportByID(@Param("id") UUID id, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a report
   * Get a report by &#x60;id&#x60;.
   * Note, this is equivalent to the other <code>getReportByID</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetReportByIDQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return Report

   */
  @RequestLine("GET /v1/reports/{id}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  Report getReportByID(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getReportByID</code> method in a fluent style.
   */
  public static class GetReportByIDQueryParams extends HashMap<String, Object> {
    public GetReportByIDQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetReportByIDQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * List reports
   * Get a list of reports. Use &#x60;fields&#x60; parameter to get only necessary fields.
   * @param fields Fields requested in the returned resource (optional)
   * @return ReportList
   */
  @RequestLine("GET /v1/reports?fields={fields}")
  @Headers({
      "Accept: application/json",
  })
  ReportList listReports(@Param("fields") String fields);

  /**
   * List reports
   * Get a list of reports. Use &#x60;fields&#x60; parameter to get only necessary fields.
   * Note, this is equivalent to the other <code>listReports</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListReportsQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   </ul>
   * @return ReportList

   */
  @RequestLine("GET /v1/reports?fields={fields}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  ReportList listReports(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listReports</code> method in a fluent style.
   */
  public static class ListReportsQueryParams extends HashMap<String, Object> {
    public ListReportsQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
  }
}
