package org.openmetadata.client.api;

import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;

import org.openmetadata.client.model.Settings;
import org.openmetadata.client.model.SettingsList;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")public interface SettingsApi extends ApiClient.Api {

  /**
   * Update Setting
   * Update Existing Settings
   * @param body  (optional)
   * @return Settings
   */
  @RequestLine("PUT /v1/settings")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Settings createOrUpdate(Settings body);
  /**
   * Get a Setting
   * Get a OpenMetadata Settings
   * @param settingName  (required)
   * @return Settings
   */
  @RequestLine("GET /v1/settings/{settingName}")
  @Headers({
      "Accept: application/json",
  })
  Settings getSetting(@Param("settingName") String settingName);
  /**
   * List All Settings
   * Get a List of all OpenMetadata Settings
   * @return SettingsList
   */
  @RequestLine("GET /v1/settings")
  @Headers({
      "Accept: application/json",
  })
  SettingsList listSettings();
  /**
   * Patch a Setting
   * Update an existing Setting using JsonPatch.
   * @param settingName Key of the Setting (required)
   * @param body JsonPatch with array of operations (optional)
   * JsonPatch RFC
   * @see <a href="https://tools.ietf.org/html/rfc6902">Patch a Setting Documentation</a>
   */
  @RequestLine("PATCH /v1/settings/{settingName}")
  @Headers({
      "Content-Type: application/json-patch+json",
      "Accept: application/json",
  })
  void patchSetting(@Param("settingName") String settingName, Object body);
}
