package org.openmetadata.client.api;

import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;

import org.openmetadata.client.model.CreateStorageService;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.StorageService;
import org.openmetadata.client.model.StorageServiceList;
import java.util.UUID;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")public interface StorageServicesApi extends ApiClient.Api {

  /**
   * Update storage service
   * Update an existing storage service identified by &#x60;id&#x60;.
   * @param body  (optional)
   * @return StorageService
   */
  @RequestLine("PUT /v1/services/storageServices")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  StorageService createOrUpdateStorageService(CreateStorageService body);
  /**
   * Create storage service
   * Create a new storage service.
   * @param body  (optional)
   * @return StorageService
   */
  @RequestLine("POST /v1/services/storageServices")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  StorageService createStorageService(CreateStorageService body);
  /**
   * Delete a storage service
   * Delete a storage services. If storages (and tables) belong the service, it can&#x27;t be deleted.
   * @param id Id of the storage service (required)
   * @param recursive Recursively delete this entity and it&#x27;s children. (Default &#x60;false&#x60;) (optional)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/services/storageServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteStorageService(@Param("id") UUID id, @Param("recursive") Boolean recursive, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a storage service
   * Delete a storage services. If storages (and tables) belong the service, it can&#x27;t be deleted.
   * Note, this is equivalent to the other <code>deleteStorageService</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteStorageServiceQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id Id of the storage service (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>recursive - Recursively delete this entity and it&#x27;s children. (Default &#x60;false&#x60;) (optional)</li>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/services/storageServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteStorageService(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteStorageService</code> method in a fluent style.
   */
  public static class DeleteStorageServiceQueryParams extends HashMap<String, Object> {
    public DeleteStorageServiceQueryParams recursive(final Boolean value) {
      put("recursive", EncodingUtils.encode(value));
      return this;
    }
    public DeleteStorageServiceQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Delete a storage service
   * Delete a storage services by &#x60;name&#x60;. If storages (and tables) belong the service, it can&#x27;t be deleted.
   * @param name Name of the storage service (required)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/services/storageServices/name/{name}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteStorageServiceByName(@Param("name") String name, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a storage service
   * Delete a storage services by &#x60;name&#x60;. If storages (and tables) belong the service, it can&#x27;t be deleted.
   * Note, this is equivalent to the other <code>deleteStorageServiceByName</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteStorageServiceByNameQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param name Name of the storage service (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/services/storageServices/name/{name}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteStorageServiceByName(@Param("name") String name, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteStorageServiceByName</code> method in a fluent style.
   */
  public static class DeleteStorageServiceByNameQueryParams extends HashMap<String, Object> {
    public DeleteStorageServiceByNameQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a version of the storage service
   * Get a version of the storage service by given &#x60;id&#x60;
   * @param id storage service Id (required)
   * @param version storage service version number in the form &#x60;major&#x60;.&#x60;minor&#x60; (required)
   * @return StorageService
   */
  @RequestLine("GET /v1/services/storageServices/{id}/versions/{version}")
  @Headers({
      "Accept: application/json",
  })
  StorageService getSpecificStorageServiceVersion(@Param("id") String id, @Param("version") String version);
  /**
   * Get storage service by name
   * Get a storage service by the service &#x60;name&#x60;.
   * @param name  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return StorageService
   */
  @RequestLine("GET /v1/services/storageServices/name/{name}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  StorageService getStorageServiceByFQN(@Param("name") String name, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get storage service by name
   * Get a storage service by the service &#x60;name&#x60;.
   * Note, this is equivalent to the other <code>getStorageServiceByFQN</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetStorageServiceByFQNQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param name  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return StorageService

   */
  @RequestLine("GET /v1/services/storageServices/name/{name}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  StorageService getStorageServiceByFQN(@Param("name") String name, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getStorageServiceByFQN</code> method in a fluent style.
   */
  public static class GetStorageServiceByFQNQueryParams extends HashMap<String, Object> {
    public GetStorageServiceByFQNQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetStorageServiceByFQNQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a storage service
   * Get a storage service by &#x60;id&#x60;.
   * @param id  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return StorageService
   */
  @RequestLine("GET /v1/services/storageServices/{id}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  StorageService getStorageServiceByID(@Param("id") UUID id, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a storage service
   * Get a storage service by &#x60;id&#x60;.
   * Note, this is equivalent to the other <code>getStorageServiceByID</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetStorageServiceByIDQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return StorageService

   */
  @RequestLine("GET /v1/services/storageServices/{id}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  StorageService getStorageServiceByID(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getStorageServiceByID</code> method in a fluent style.
   */
  public static class GetStorageServiceByIDQueryParams extends HashMap<String, Object> {
    public GetStorageServiceByIDQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetStorageServiceByIDQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * List storage service versions
   * Get a list of all the versions of a storage service identified by &#x60;id&#x60;
   * @param id storage service Id (required)
   * @return EntityHistory
   */
  @RequestLine("GET /v1/services/storageServices/{id}/versions")
  @Headers({
      "Accept: application/json",
  })
  EntityHistory listAllStorageServiceVersion(@Param("id") String id);
  /**
   * List storage services
   * Get a list of storage services. Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * @param fields Fields requested in the returned resource (optional)
   * @param limit Limit number of services returned. (1 to 1000000, default 10) (optional)
   * @param before Returns list of services before this cursor (optional)
   * @param after Returns list of services after this cursor (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return StorageServiceList
   */
  @RequestLine("GET /v1/services/storageServices?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  StorageServiceList listStorageService(@Param("fields") String fields, @Param("limit") Integer limit, @Param("before") String before, @Param("after") String after, @Param("include") String include);

  /**
   * List storage services
   * Get a list of storage services. Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * Note, this is equivalent to the other <code>listStorageService</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListStorageServiceQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>limit - Limit number of services returned. (1 to 1000000, default 10) (optional)</li>
   *   <li>before - Returns list of services before this cursor (optional)</li>
   *   <li>after - Returns list of services after this cursor (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return StorageServiceList

   */
  @RequestLine("GET /v1/services/storageServices?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  StorageServiceList listStorageService(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listStorageService</code> method in a fluent style.
   */
  public static class ListStorageServiceQueryParams extends HashMap<String, Object> {
    public ListStorageServiceQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public ListStorageServiceQueryParams limit(final Integer value) {
      put("limit", EncodingUtils.encode(value));
      return this;
    }
    public ListStorageServiceQueryParams before(final String value) {
      put("before", EncodingUtils.encode(value));
      return this;
    }
    public ListStorageServiceQueryParams after(final String value) {
      put("after", EncodingUtils.encode(value));
      return this;
    }
    public ListStorageServiceQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Restore a soft deleted StorageService.
   * Restore a soft deleted StorageService.
   * @param body  (optional)
   * @return StorageService
   */
  @RequestLine("PUT /v1/services/storageServices/restore")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  StorageService restore25(RestoreEntity body);
}
