package org.openmetadata.client.api;

import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;

import java.math.BigDecimal;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.ColumnProfileList;
import org.openmetadata.client.model.CreateCustomMetric;
import org.openmetadata.client.model.CreateTable;
import org.openmetadata.client.model.CreateTableProfile;
import org.openmetadata.client.model.DataModel;
import org.openmetadata.client.model.Database;
import org.openmetadata.client.model.DatabaseSchema;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.SQLQuery;
import org.openmetadata.client.model.SystemProfileList;
import org.openmetadata.client.model.Table;
import org.openmetadata.client.model.TableData;
import org.openmetadata.client.model.TableJoins;
import org.openmetadata.client.model.TableList;
import org.openmetadata.client.model.TableProfile;
import org.openmetadata.client.model.TableProfileList;
import org.openmetadata.client.model.TableProfilerConfig;
import org.openmetadata.client.model.TestCase;
import java.util.UUID;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")public interface TablesApi extends ApiClient.Api {

  /**
   * Add column custom metrics
   * Add column custom metrics.
   * @param id Id of the table (required)
   * @param body  (optional)
   * @return Table
   */
  @RequestLine("PUT /v1/tables/{id}/customMetric")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Table addCustomMetric(@Param("id") UUID id, CreateCustomMetric body);
  /**
   * Add data modeling information to a table
   * Add data modeling (such as DBT model) information on how the table was created to the table.
   * @param id Id of the table (required)
   * @param body  (optional)
   * @return Table
   */
  @RequestLine("PUT /v1/tables/{id}/dataModel")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Table addDataModel(@Param("id") String id, DataModel body);
  /**
   * Add table profile data
   * Add table profile data to the table.
   * @param id Id of the table (required)
   * @param body  (optional)
   * @return Table
   */
  @RequestLine("PUT /v1/tables/{id}/tableProfile")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Table addDataProfiler(@Param("id") UUID id, CreateTableProfile body);
  /**
   * Add table profile Config
   * Add table profile config to the table.
   * @param id Id of the table (required)
   * @param body  (optional)
   * @return Table
   */
  @RequestLine("PUT /v1/tables/{id}/tableProfilerConfig")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Table addDataProfilerConfig(@Param("id") UUID id, TableProfilerConfig body);
  /**
   * Add a follower
   * Add a user identified by &#x60;userId&#x60; as followed of this table
   * @param id Id of the table (required)
   * @param body Id of the user to be added as follower (optional)
   * @return ChangeEvent
   */
  @RequestLine("PUT /v1/tables/{id}/followers")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  ChangeEvent addFollowerToTable(@Param("id") UUID id, String body);
  /**
   * Add a location
   * Add a location identified by &#x60;locationId&#x60; to this table
   * @param id Id of the table (required)
   * @param body Id of the location to be added (optional)
   * @return Table
   */
  @RequestLine("PUT /v1/tables/{id}/location")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Table addLocationToTable(@Param("id") UUID id, UUID body);
  /**
   * Add sample data
   * Add sample data to the table.
   * @param id Id of the table (required)
   * @param body  (optional)
   * @return Table
   */
  @RequestLine("PUT /v1/tables/{id}/sampleData")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Table addSampleData(@Param("id") UUID id, TableData body);
  /**
   * Add table join information
   * Add information about other tables that this table is joined with. Join information can only be added for the last 30 days starting today.
   * @param id Id of the table (required)
   * @param body  (optional)
   * @return Table
   */
  @RequestLine("PUT /v1/tables/{id}/joins")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Table addTableJoinInfo(@Param("id") UUID id, TableJoins body);
  /**
   * Add table query data
   * Add table query data to the table.
   * @param id Id of the table (required)
   * @param body  (optional)
   * @return Table
   */
  @RequestLine("PUT /v1/tables/{id}/tableQuery")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Table addTableQuery(@Param("id") UUID id, SQLQuery body);
  /**
   * Create or update a table
   * Create a table, if it does not exist. If a table already exists, update the table.
   * @param body  (optional)
   * @return Table
   */
  @RequestLine("PUT /v1/tables")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Table createOrUpdateTable(CreateTable body);
  /**
   * Create a table
   * Create a new table under an existing &#x60;database&#x60;.
   * @param body  (optional)
   * @return Table
   */
  @RequestLine("POST /v1/tables")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Table createTable(CreateTable body);
  /**
   * delete custom metric from a column
   * Delete a custom metric from a column.
   * @param id Id of the table (required)
   * @param columnName column of the table (required)
   * @param customMetricName column Test Type (required)
   * @return Table
   */
  @RequestLine("DELETE /v1/tables/{id}/customMetric/{columnName}/{customMetricName}")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Table deleteCustomMetric(@Param("id") UUID id, @Param("columnName") String columnName, @Param("customMetricName") String customMetricName);
  /**
   * delete table profile data
   * delete table profile data to the table.
   * @param fqn FQN of the table or column (required)
   * @param entityType type of the entity table or column (required)
   * @param timestamp Timestamp of the table profile (required)
   * @return TableProfile
   */
  @RequestLine("DELETE /v1/tables/{fqn}/{entityType}/{timestamp}/profile")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  TableProfile deleteDataProfiler(@Param("fqn") String fqn, @Param("entityType") String entityType, @Param("timestamp") Long timestamp);
  /**
   * delete table profiler config
   * delete table profile config to the table.
   * @param id Id of the table (required)
   * @return Table
   */
  @RequestLine("DELETE /v1/tables/{id}/tableProfilerConfig")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Table deleteDataProfilerConfig(@Param("id") UUID id);
  /**
   * Remove a follower
   * Remove the user identified &#x60;userId&#x60; as a follower of the table.
   * @param id Id of the table (required)
   * @param userId Id of the user being removed as follower (required)
   * @return ChangeEvent
   */
  @RequestLine("DELETE /v1/tables/{id}/followers/{userId}")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  ChangeEvent deleteFollower(@Param("id") UUID id, @Param("userId") String userId);
  /**
   * Remove the location
   * Remove the location
   * @param id Id of the table (required)
   * @return Table
   */
  @RequestLine("DELETE /v1/tables/{id}/location")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Table deleteLocation1(@Param("id") UUID id);
  /**
   * delete sample data
   * delete sample data from the table.
   * @param id Id of the table (required)
   * @param body  (optional)
   * @return Table
   */
  @RequestLine("DELETE /v1/tables/{id}/sampleData")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Table deleteSampleData(@Param("id") UUID id, TableData body);
  /**
   * Delete a table
   * Delete a table by &#x60;id&#x60;.
   * @param id Id of the table (required)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/tables/{id}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteTable(@Param("id") UUID id, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a table
   * Delete a table by &#x60;id&#x60;.
   * Note, this is equivalent to the other <code>deleteTable</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteTableQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id Id of the table (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/tables/{id}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteTable(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteTable</code> method in a fluent style.
   */
  public static class DeleteTableQueryParams extends HashMap<String, Object> {
    public DeleteTableQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Delete a table
   * Delete a table by &#x60;fullyQualifiedName&#x60;.
   * @param fqn Name of the table (required)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/tables/name/{fqn}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteTable1(@Param("fqn") String fqn, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a table
   * Delete a table by &#x60;fullyQualifiedName&#x60;.
   * Note, this is equivalent to the other <code>deleteTable1</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteTable1QueryParams} class that allows for
   * building up this map in a fluent style.
   * @param fqn Name of the table (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/tables/name/{fqn}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteTable1(@Param("fqn") String fqn, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteTable1</code> method in a fluent style.
   */
  public static class DeleteTable1QueryParams extends HashMap<String, Object> {
    public DeleteTable1QueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Delete testCase result.
   * Delete testCase result for a testCase.
   * @param fqn fqn of the testCase (required)
   * @param timestamp Timestamp of the testCase result (required)
   * @return TestCase
   */
  @RequestLine("DELETE /v1/testCase/{fqn}/testCaseResult/{timestamp}")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  TestCase deleteTestCaseResult(@Param("fqn") String fqn, @Param("timestamp") Long timestamp);
  /**
   * Get table profile Config
   * Get table profile config to the table.
   * @param id Id of the table (required)
   * @return Table
   */
  @RequestLine("GET /v1/tables/{id}/tableProfilerConfig")
  @Headers({
      "Accept: application/json",
  })
  Table getDataProfilerConfig(@Param("id") UUID id);
  /**
   * get sample data
   * get sample data from the table.
   * @param id Id of the table (required)
   * @param body  (optional)
   * @return Table
   */
  @RequestLine("GET /v1/tables/{id}/sampleData")
  @Headers({
      "Accept: application/json",
  })
  Table getSampleData(@Param("id") UUID id, TableData body);
  /**
   * Get a version of the table
   * Get a version of the table by given &#x60;id&#x60;
   * @param id table Id (required)
   * @param version table version number in the form &#x60;major&#x60;.&#x60;minor&#x60; (required)
   * @return Table
   */
  @RequestLine("GET /v1/tables/{id}/versions/{version}")
  @Headers({
      "Accept: application/json",
  })
  Table getSpecificDatabaseVersion1(@Param("id") UUID id, @Param("version") String version);
  /**
   * Get a table by name
   * Get a table by fully qualified table name.
   * @param fqn Fully qualified name of the table (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return Table
   */
  @RequestLine("GET /v1/tables/name/{fqn}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  Table getTableByFQN(@Param("fqn") String fqn, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a table by name
   * Get a table by fully qualified table name.
   * Note, this is equivalent to the other <code>getTableByFQN</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetTableByFQNQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param fqn Fully qualified name of the table (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return Table

   */
  @RequestLine("GET /v1/tables/name/{fqn}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  Table getTableByFQN(@Param("fqn") String fqn, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getTableByFQN</code> method in a fluent style.
   */
  public static class GetTableByFQNQueryParams extends HashMap<String, Object> {
    public GetTableByFQNQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetTableByFQNQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a table
   * Get a table by &#x60;id&#x60;
   * @param id table Id (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return Table
   */
  @RequestLine("GET /v1/tables/{id}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  Table getTableByID(@Param("id") UUID id, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a table
   * Get a table by &#x60;id&#x60;
   * Note, this is equivalent to the other <code>getTableByID</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetTableByIDQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id table Id (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return Table

   */
  @RequestLine("GET /v1/tables/{id}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  Table getTableByID(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getTableByID</code> method in a fluent style.
   */
  public static class GetTableByIDQueryParams extends HashMap<String, Object> {
    public GetTableByIDQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetTableByIDQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * get table query data
   * get table query data from the table.
   * @param id Id of the table (required)
   * @param body  (optional)
   * @return Table
   */
  @RequestLine("GET /v1/tables/{id}/tableQuery")
  @Headers({
      "Accept: application/json",
  })
  Table getTableQuery(@Param("id") UUID id, SQLQuery body);
  /**
   * get table query data
   * get table query data from the table.
   * @param id Id of the table (required)
   * @param body  (optional)
   * @param limit  (optional)
   * @param before Returns list of users before this cursor (optional)
   * @param after Returns list of users after this cursor (optional)
   * @return Table
   */
  @RequestLine("GET /v1/tables/{id}/getTableQueries?limit={limit}&before={before}&after={after}")
  @Headers({
      "Accept: application/json",
  })
  Table getTableQueryList(@Param("id") UUID id, SQLQuery body, @Param("limit") Integer limit, @Param("before") String before, @Param("after") String after);

  /**
   * get table query data
   * get table query data from the table.
   * Note, this is equivalent to the other <code>getTableQueryList</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetTableQueryListQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id Id of the table (required)
   * @param body  (optional)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>limit -  (optional)</li>
   *   <li>before - Returns list of users before this cursor (optional)</li>
   *   <li>after - Returns list of users after this cursor (optional)</li>
   *   </ul>
   * @return Table

   */
  @RequestLine("GET /v1/tables/{id}/getTableQueries?limit={limit}&before={before}&after={after}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  Table getTableQueryList(@Param("id") UUID id, SQLQuery body, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getTableQueryList</code> method in a fluent style.
   */
  public static class GetTableQueryListQueryParams extends HashMap<String, Object> {
    public GetTableQueryListQueryParams limit(final Integer value) {
      put("limit", EncodingUtils.encode(value));
      return this;
    }
    public GetTableQueryListQueryParams before(final String value) {
      put("before", EncodingUtils.encode(value));
      return this;
    }
    public GetTableQueryListQueryParams after(final String value) {
      put("after", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * get the latest tableProfile
   * Get the latest table and column profile 
   * @param fqn FQN of the table or column (required)
   * @return Table
   */
  @RequestLine("GET /v1/tables/{fqn}/tableProfile/latest")
  @Headers({
      "Accept: application/json",
  })
  Table getTheLatestTableAndColumnProfile(@Param("fqn") String fqn);
  /**
   * List table versions
   * Get a list of all the versions of a table identified by &#x60;id&#x60;
   * @param id table Id (required)
   * @return EntityHistory
   */
  @RequestLine("GET /v1/tables/{id}/versions")
  @Headers({
      "Accept: application/json",
  })
  EntityHistory listAllTableVersion(@Param("id") String id);
  /**
   * List of column profiles
   * Get a list of all the column profiles for the given table fqn, optionally filtered by &#x60;extension&#x60;, &#x60;startTs&#x60; and &#x60;endTs&#x60; of the profile. Use cursor-based pagination to limit the number of entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * @param fqn FQN of the column (required)
   * @param startTs Filter table/column profiles after the given start timestamp (required)
   * @param endTs Filter table/column profiles before the given end timestamp (required)
   * @return ColumnProfileList
   */
  @RequestLine("GET /v1/tables/{fqn}/columnProfile?startTs={startTs}&endTs={endTs}")
  @Headers({
      "Accept: application/json",
  })
  ColumnProfileList listColumnProfiles(@Param("fqn") String fqn, @Param("startTs") BigDecimal startTs, @Param("endTs") BigDecimal endTs);

  /**
   * List of column profiles
   * Get a list of all the column profiles for the given table fqn, optionally filtered by &#x60;extension&#x60;, &#x60;startTs&#x60; and &#x60;endTs&#x60; of the profile. Use cursor-based pagination to limit the number of entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * Note, this is equivalent to the other <code>listColumnProfiles</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListColumnProfilesQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param fqn FQN of the column (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>startTs - Filter table/column profiles after the given start timestamp (required)</li>
   *   <li>endTs - Filter table/column profiles before the given end timestamp (required)</li>
   *   </ul>
   * @return ColumnProfileList

   */
  @RequestLine("GET /v1/tables/{fqn}/columnProfile?startTs={startTs}&endTs={endTs}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  ColumnProfileList listColumnProfiles(@Param("fqn") String fqn, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listColumnProfiles</code> method in a fluent style.
   */
  public static class ListColumnProfilesQueryParams extends HashMap<String, Object> {
    public ListColumnProfilesQueryParams startTs(final BigDecimal value) {
      put("startTs", EncodingUtils.encode(value));
      return this;
    }
    public ListColumnProfilesQueryParams endTs(final BigDecimal value) {
      put("endTs", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * List of table profiles
   * Get a list of all the table profiles for the given table fqn, optionally filtered by &#x60;extension&#x60;, &#x60;startTs&#x60; and &#x60;endTs&#x60; of the profile. Use cursor-based pagination to limit the number of entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * @param fqn FQN of the table or column (required)
   * @param startTs Filter table/column profiles after the given start timestamp (optional)
   * @param endTs Filter table/column profiles before the given end timestamp (optional)
   * @return TableProfileList
   */
  @RequestLine("GET /v1/tables/{fqn}/tableProfile?startTs={startTs}&endTs={endTs}")
  @Headers({
      "Accept: application/json",
  })
  TableProfileList listProfiles(@Param("fqn") String fqn, @Param("startTs") BigDecimal startTs, @Param("endTs") BigDecimal endTs);

  /**
   * List of table profiles
   * Get a list of all the table profiles for the given table fqn, optionally filtered by &#x60;extension&#x60;, &#x60;startTs&#x60; and &#x60;endTs&#x60; of the profile. Use cursor-based pagination to limit the number of entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * Note, this is equivalent to the other <code>listProfiles</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListProfilesQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param fqn FQN of the table or column (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>startTs - Filter table/column profiles after the given start timestamp (optional)</li>
   *   <li>endTs - Filter table/column profiles before the given end timestamp (optional)</li>
   *   </ul>
   * @return TableProfileList

   */
  @RequestLine("GET /v1/tables/{fqn}/tableProfile?startTs={startTs}&endTs={endTs}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  TableProfileList listProfiles(@Param("fqn") String fqn, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listProfiles</code> method in a fluent style.
   */
  public static class ListProfilesQueryParams extends HashMap<String, Object> {
    public ListProfilesQueryParams startTs(final BigDecimal value) {
      put("startTs", EncodingUtils.encode(value));
      return this;
    }
    public ListProfilesQueryParams endTs(final BigDecimal value) {
      put("endTs", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * List of system profiles
   * Get a list of all the system profiles for the given table fqn, filtered by &#x60;extension&#x60;, &#x60;startTs&#x60; and &#x60;endTs&#x60; of the profile. Use cursor-based pagination to limit the number of entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * @param fqn FQN of the table (required)
   * @param startTs Filter system profiles after the given start timestamp (required)
   * @param endTs Filter system profiles before the given end timestamp (required)
   * @return SystemProfileList
   */
  @RequestLine("GET /v1/tables/{fqn}/systemProfile?startTs={startTs}&endTs={endTs}")
  @Headers({
      "Accept: application/json",
  })
  SystemProfileList listSystemProfiles(@Param("fqn") String fqn, @Param("startTs") BigDecimal startTs, @Param("endTs") BigDecimal endTs);

  /**
   * List of system profiles
   * Get a list of all the system profiles for the given table fqn, filtered by &#x60;extension&#x60;, &#x60;startTs&#x60; and &#x60;endTs&#x60; of the profile. Use cursor-based pagination to limit the number of entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * Note, this is equivalent to the other <code>listSystemProfiles</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListSystemProfilesQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param fqn FQN of the table (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>startTs - Filter system profiles after the given start timestamp (required)</li>
   *   <li>endTs - Filter system profiles before the given end timestamp (required)</li>
   *   </ul>
   * @return SystemProfileList

   */
  @RequestLine("GET /v1/tables/{fqn}/systemProfile?startTs={startTs}&endTs={endTs}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  SystemProfileList listSystemProfiles(@Param("fqn") String fqn, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listSystemProfiles</code> method in a fluent style.
   */
  public static class ListSystemProfilesQueryParams extends HashMap<String, Object> {
    public ListSystemProfilesQueryParams startTs(final BigDecimal value) {
      put("startTs", EncodingUtils.encode(value));
      return this;
    }
    public ListSystemProfilesQueryParams endTs(final BigDecimal value) {
      put("endTs", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * List tables
   * Get a list of tables, optionally filtered by &#x60;database&#x60; it belongs to. Use &#x60;fields&#x60; parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * @param fields Fields requested in the returned resource (optional)
   * @param database Filter tables by database fully qualified name (optional)
   * @param limit Limit the number tables returned. (1 to 1000000, default &#x3D; 10)  (optional)
   * @param before Returns list of tables before this cursor (optional)
   * @param after Returns list of tables after this cursor (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return TableList
   */
  @RequestLine("GET /v1/tables?fields={fields}&database={database}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  TableList listTables(@Param("fields") String fields, @Param("database") String database, @Param("limit") Integer limit, @Param("before") String before, @Param("after") String after, @Param("include") String include);

  /**
   * List tables
   * Get a list of tables, optionally filtered by &#x60;database&#x60; it belongs to. Use &#x60;fields&#x60; parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * Note, this is equivalent to the other <code>listTables</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListTablesQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>database - Filter tables by database fully qualified name (optional)</li>
   *   <li>limit - Limit the number tables returned. (1 to 1000000, default &#x3D; 10)  (optional)</li>
   *   <li>before - Returns list of tables before this cursor (optional)</li>
   *   <li>after - Returns list of tables after this cursor (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return TableList

   */
  @RequestLine("GET /v1/tables?fields={fields}&database={database}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  TableList listTables(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listTables</code> method in a fluent style.
   */
  public static class ListTablesQueryParams extends HashMap<String, Object> {
    public ListTablesQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public ListTablesQueryParams database(final String value) {
      put("database", EncodingUtils.encode(value));
      return this;
    }
    public ListTablesQueryParams limit(final Integer value) {
      put("limit", EncodingUtils.encode(value));
      return this;
    }
    public ListTablesQueryParams before(final String value) {
      put("before", EncodingUtils.encode(value));
      return this;
    }
    public ListTablesQueryParams after(final String value) {
      put("after", EncodingUtils.encode(value));
      return this;
    }
    public ListTablesQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Update a table
   * Update an existing table using JsonPatch.
   * @param id Id of the table (required)
   * @param body JsonPatch with array of operations (optional)
   * JsonPatch RFC
   * @see <a href="https://tools.ietf.org/html/rfc6902">Update a table Documentation</a>
   */
  @RequestLine("PATCH /v1/tables/{id}")
  @Headers({
      "Content-Type: application/json-patch+json",
      "Accept: application/json",
  })
  void patchTable(@Param("id") UUID id, Object body);
  /**
   * Restore a soft deleted Database.
   * Restore a soft deleted Database.
   * @param body  (optional)
   * @return Database
   */
  @RequestLine("PUT /v1/databases/restore")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Database restore5(RestoreEntity body);
  /**
   * Restore a soft deleted DatabaseSchema.
   * Restore a soft deleted DatabaseSchema.
   * @param body  (optional)
   * @return DatabaseSchema
   */
  @RequestLine("PUT /v1/databaseSchemas/restore")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  DatabaseSchema restore6(RestoreEntity body);
  /**
   * Restore a soft deleted table.
   * Restore a soft deleted table.
   * @param body  (optional)
   * @return Table
   */
  @RequestLine("PUT /v1/tables/restore")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Table restore7(RestoreEntity body);
}
