package org.openmetadata.client.api;

import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;

import org.openmetadata.client.model.CreateTeam;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.Team;
import org.openmetadata.client.model.TeamList;
import java.util.UUID;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")public interface TeamsApi extends ApiClient.Api {

  /**
   * Update team
   * Create or Update a team.
   * @param body  (optional)
   * @return Team
   */
  @RequestLine("PUT /v1/teams")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Team createOrUpdateTeam(CreateTeam body);
  /**
   * Create a team
   * Create a new team.
   * @param body  (optional)
   * @return Team
   */
  @RequestLine("POST /v1/teams")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Team createTeam(CreateTeam body);
  /**
   * Delete a team
   * Delete a team by given &#x60;id&#x60;.
   * @param id Team Id (required)
   * @param recursive Recursively delete this team and it&#x27;s children. (Default &#x60;false&#x60;) (optional)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/teams/{id}?recursive={recursive}&hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteTeam(@Param("id") UUID id, @Param("recursive") Boolean recursive, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a team
   * Delete a team by given &#x60;id&#x60;.
   * Note, this is equivalent to the other <code>deleteTeam</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteTeamQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id Team Id (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>recursive - Recursively delete this team and it&#x27;s children. (Default &#x60;false&#x60;) (optional)</li>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/teams/{id}?recursive={recursive}&hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteTeam(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteTeam</code> method in a fluent style.
   */
  public static class DeleteTeamQueryParams extends HashMap<String, Object> {
    public DeleteTeamQueryParams recursive(final Boolean value) {
      put("recursive", EncodingUtils.encode(value));
      return this;
    }
    public DeleteTeamQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Delete a team
   * Delete a team by given &#x60;name&#x60;.
   * @param name Name of the team (required)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/teams/name/{name}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteTeamByName(@Param("name") String name, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a team
   * Delete a team by given &#x60;name&#x60;.
   * Note, this is equivalent to the other <code>deleteTeamByName</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteTeamByNameQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param name Name of the team (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/teams/name/{name}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteTeamByName(@Param("name") String name, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteTeamByName</code> method in a fluent style.
   */
  public static class DeleteTeamByNameQueryParams extends HashMap<String, Object> {
    public DeleteTeamByNameQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a version of the team
   * Get a version of the team by given &#x60;id&#x60;
   * @param id Team Id (required)
   * @param version Team version number in the form &#x60;major&#x60;.&#x60;minor&#x60; (required)
   * @return Team
   */
  @RequestLine("GET /v1/teams/{id}/versions/{version}")
  @Headers({
      "Accept: application/json",
  })
  Team getSpecificRoleVersion1(@Param("id") String id, @Param("version") String version);
  /**
   * Get a team by name
   * Get a team by &#x60;name&#x60;.
   * @param name  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return Team
   */
  @RequestLine("GET /v1/teams/name/{name}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  Team getTeamByFQN(@Param("name") String name, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a team by name
   * Get a team by &#x60;name&#x60;.
   * Note, this is equivalent to the other <code>getTeamByFQN</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetTeamByFQNQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param name  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return Team

   */
  @RequestLine("GET /v1/teams/name/{name}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  Team getTeamByFQN(@Param("name") String name, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getTeamByFQN</code> method in a fluent style.
   */
  public static class GetTeamByFQNQueryParams extends HashMap<String, Object> {
    public GetTeamByFQNQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetTeamByFQNQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a team
   * Get a team by &#x60;id&#x60;.
   * @param id  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return Team
   */
  @RequestLine("GET /v1/teams/{id}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  Team getTeamByID(@Param("id") UUID id, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a team
   * Get a team by &#x60;id&#x60;.
   * Note, this is equivalent to the other <code>getTeamByID</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetTeamByIDQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return Team

   */
  @RequestLine("GET /v1/teams/{id}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  Team getTeamByID(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getTeamByID</code> method in a fluent style.
   */
  public static class GetTeamByIDQueryParams extends HashMap<String, Object> {
    public GetTeamByIDQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetTeamByIDQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * List team versions
   * Get a list of all the versions of a team identified by &#x60;id&#x60;
   * @param id team Id (required)
   * @return EntityHistory
   */
  @RequestLine("GET /v1/teams/{id}/versions")
  @Headers({
      "Accept: application/json",
  })
  EntityHistory listAllTeamVersion(@Param("id") String id);
  /**
   * List teams
   * Get a list of teams. Use &#x60;fields&#x60; parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * @param fields Fields requested in the returned resource (optional)
   * @param limit Limit the number of teams returned. (1 to 1000000, default &#x3D; 10) (optional)
   * @param before Returns list of teams before this cursor (optional)
   * @param after Returns list of teams after this cursor (optional)
   * @param parentTeam Filter the results by parent team name (optional)
   * @param isJoinable Filter the results by whether the team can be joined by any user or not (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return TeamList
   */
  @RequestLine("GET /v1/teams?fields={fields}&limit={limit}&before={before}&after={after}&parentTeam={parentTeam}&isJoinable={isJoinable}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  TeamList listTeams(@Param("fields") String fields, @Param("limit") Integer limit, @Param("before") String before, @Param("after") String after, @Param("parentTeam") String parentTeam, @Param("isJoinable") Boolean isJoinable, @Param("include") String include);

  /**
   * List teams
   * Get a list of teams. Use &#x60;fields&#x60; parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * Note, this is equivalent to the other <code>listTeams</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListTeamsQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>limit - Limit the number of teams returned. (1 to 1000000, default &#x3D; 10) (optional)</li>
   *   <li>before - Returns list of teams before this cursor (optional)</li>
   *   <li>after - Returns list of teams after this cursor (optional)</li>
   *   <li>parentTeam - Filter the results by parent team name (optional)</li>
   *   <li>isJoinable - Filter the results by whether the team can be joined by any user or not (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return TeamList

   */
  @RequestLine("GET /v1/teams?fields={fields}&limit={limit}&before={before}&after={after}&parentTeam={parentTeam}&isJoinable={isJoinable}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  TeamList listTeams(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listTeams</code> method in a fluent style.
   */
  public static class ListTeamsQueryParams extends HashMap<String, Object> {
    public ListTeamsQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public ListTeamsQueryParams limit(final Integer value) {
      put("limit", EncodingUtils.encode(value));
      return this;
    }
    public ListTeamsQueryParams before(final String value) {
      put("before", EncodingUtils.encode(value));
      return this;
    }
    public ListTeamsQueryParams after(final String value) {
      put("after", EncodingUtils.encode(value));
      return this;
    }
    public ListTeamsQueryParams parentTeam(final String value) {
      put("parentTeam", EncodingUtils.encode(value));
      return this;
    }
    public ListTeamsQueryParams isJoinable(final Boolean value) {
      put("isJoinable", EncodingUtils.encode(value));
      return this;
    }
    public ListTeamsQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * List teams with hierarchy
   * Get a list of teams with hierarchy.
   * @param limit Limit the number of teams returned. (1 to 1000000, default &#x3D; 10) (optional)
   * @param isJoinable Filter the results by whether the team can be joined by any user or not (optional)
   * @return TeamList
   */
  @RequestLine("GET /v1/teams/hierarchy?limit={limit}&isJoinable={isJoinable}")
  @Headers({
      "Accept: application/json",
  })
  TeamList listTeamsHierarchy(@Param("limit") Integer limit, @Param("isJoinable") Boolean isJoinable);

  /**
   * List teams with hierarchy
   * Get a list of teams with hierarchy.
   * Note, this is equivalent to the other <code>listTeamsHierarchy</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListTeamsHierarchyQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>limit - Limit the number of teams returned. (1 to 1000000, default &#x3D; 10) (optional)</li>
   *   <li>isJoinable - Filter the results by whether the team can be joined by any user or not (optional)</li>
   *   </ul>
   * @return TeamList

   */
  @RequestLine("GET /v1/teams/hierarchy?limit={limit}&isJoinable={isJoinable}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  TeamList listTeamsHierarchy(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listTeamsHierarchy</code> method in a fluent style.
   */
  public static class ListTeamsHierarchyQueryParams extends HashMap<String, Object> {
    public ListTeamsHierarchyQueryParams limit(final Integer value) {
      put("limit", EncodingUtils.encode(value));
      return this;
    }
    public ListTeamsHierarchyQueryParams isJoinable(final Boolean value) {
      put("isJoinable", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Update a team
   * Update an existing team with JsonPatch.
   * @param id  (required)
   * @param body JsonPatch with array of operations (optional)
   * JsonPatch RFC
   * @see <a href="https://tools.ietf.org/html/rfc6902">Update a team Documentation</a>
   */
  @RequestLine("PATCH /v1/teams/{id}")
  @Headers({
      "Content-Type: application/json-patch+json",
      "Accept: application/json",
  })
  void patchTeam(@Param("id") UUID id, Object body);
  /**
   * Restore a soft deleted Team.
   * Restore a soft deleted Team.
   * @param body  (optional)
   * @return Team
   */
  @RequestLine("PUT /v1/teams/restore")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Team restore27(RestoreEntity body);
}
