package org.openmetadata.client.api;

import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;

import java.math.BigDecimal;
import org.openmetadata.client.model.CreateTestCase;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.TestCase;
import org.openmetadata.client.model.TestCaseList;
import org.openmetadata.client.model.TestCaseResult;
import org.openmetadata.client.model.TestCaseResultList;
import java.util.UUID;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")public interface TestCasesApi extends ApiClient.Api {

  /**
   * Add test case result data
   * Add test case result data to the testCase.
   * @param fqn fqn of the testCase (required)
   * @param body  (optional)
   * @return TestCase
   */
  @RequestLine("PUT /v1/testCase/{fqn}/testCaseResult")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  TestCase addTestCaseResult(@Param("fqn") String fqn, TestCaseResult body);
  /**
   * Update testCase
   * Create a TestCase, it it does not exist or update an existing TestCase.
   * @param body  (optional)
   * @return TestCase
   */
  @RequestLine("PUT /v1/testCase")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  TestCase createOrUpdateTest(CreateTestCase body);
  /**
   * Create a TestCase
   * Create a TestCase
   * @param body  (optional)
   * @return TestCase
   */
  @RequestLine("POST /v1/testCase")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  TestCase createTestCase(CreateTestCase body);
  /**
   * Delete a testCase
   * Delete a testCase by &#x60;id&#x60;.
   * @param id Topic Id (required)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/testCase/{id}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteTestCase(@Param("id") UUID id, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a testCase
   * Delete a testCase by &#x60;id&#x60;.
   * Note, this is equivalent to the other <code>deleteTestCase</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteTestCaseQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id Topic Id (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/testCase/{id}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteTestCase(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteTestCase</code> method in a fluent style.
   */
  public static class DeleteTestCaseQueryParams extends HashMap<String, Object> {
    public DeleteTestCaseQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Delete a testCase
   * Delete a testCase by &#x60;name&#x60;.
   * @param name Name of the TestCase (required)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/testCase/name/{name}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteTestCaseByName(@Param("name") String name, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a testCase
   * Delete a testCase by &#x60;name&#x60;.
   * Note, this is equivalent to the other <code>deleteTestCaseByName</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteTestCaseByNameQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param name Name of the TestCase (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/testCase/name/{name}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteTestCaseByName(@Param("name") String name, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteTestCaseByName</code> method in a fluent style.
   */
  public static class DeleteTestCaseByNameQueryParams extends HashMap<String, Object> {
    public DeleteTestCaseByNameQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a TestCase
   * Get a TestCase by &#x60;id&#x60;.
   * @param id  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return TestCase
   */
  @RequestLine("GET /v1/testCase/{id}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  TestCase get(@Param("id") UUID id, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a TestCase
   * Get a TestCase by &#x60;id&#x60;.
   * Note, this is equivalent to the other <code>get</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return TestCase

   */
  @RequestLine("GET /v1/testCase/{id}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  TestCase get(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>get</code> method in a fluent style.
   */
  public static class GetQueryParams extends HashMap<String, Object> {
    public GetQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a version of the TestCase
   * Get a version of the TestCase by given &#x60;id&#x60;
   * @param id Test Id (required)
   * @param version Test version number in the form &#x60;major&#x60;.&#x60;minor&#x60; (required)
   * @return TestCase
   */
  @RequestLine("GET /v1/testCase/{id}/versions/{version}")
  @Headers({
      "Accept: application/json",
  })
  TestCase getSpecificTestCaseVersion(@Param("id") String id, @Param("version") String version);
  /**
   * Get a testCase by name
   * Get a testCase by &#x60;name&#x60;.
   * @param name  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return TestCase
   */
  @RequestLine("GET /v1/testCase/name/{name}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  TestCase getTestCaseByName(@Param("name") String name, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a testCase by name
   * Get a testCase by &#x60;name&#x60;.
   * Note, this is equivalent to the other <code>getTestCaseByName</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetTestCaseByNameQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param name  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return TestCase

   */
  @RequestLine("GET /v1/testCase/name/{name}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  TestCase getTestCaseByName(@Param("name") String name, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getTestCaseByName</code> method in a fluent style.
   */
  public static class GetTestCaseByNameQueryParams extends HashMap<String, Object> {
    public GetTestCaseByNameQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetTestCaseByNameQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * List testCase versions
   * Get a list of all the versions of a testCases identified by &#x60;id&#x60;
   * @param id Test Id (required)
   * @return EntityHistory
   */
  @RequestLine("GET /v1/testCase/{id}/versions")
  @Headers({
      "Accept: application/json",
  })
  EntityHistory listAllTestCaseVersion(@Param("id") String id);
  /**
   * List of testCase results
   * Get a list of all the test case results for the given testCase id, optionally filtered by  &#x60;startTs&#x60; and &#x60;endTs&#x60; of the profile. Use cursor-based pagination to limit the number of entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * @param fqn fqn of the testCase (required)
   * @param startTs Filter testCase results after the given start timestamp (optional)
   * @param endTs Filter testCase results before the given end timestamp (optional)
   * @return TestCaseResultList
   */
  @RequestLine("GET /v1/testCase/{fqn}/testCaseResult?startTs={startTs}&endTs={endTs}")
  @Headers({
      "Accept: application/json",
  })
  TestCaseResultList listTestCaseResults(@Param("fqn") String fqn, @Param("startTs") BigDecimal startTs, @Param("endTs") BigDecimal endTs);

  /**
   * List of testCase results
   * Get a list of all the test case results for the given testCase id, optionally filtered by  &#x60;startTs&#x60; and &#x60;endTs&#x60; of the profile. Use cursor-based pagination to limit the number of entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * Note, this is equivalent to the other <code>listTestCaseResults</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListTestCaseResultsQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param fqn fqn of the testCase (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>startTs - Filter testCase results after the given start timestamp (optional)</li>
   *   <li>endTs - Filter testCase results before the given end timestamp (optional)</li>
   *   </ul>
   * @return TestCaseResultList

   */
  @RequestLine("GET /v1/testCase/{fqn}/testCaseResult?startTs={startTs}&endTs={endTs}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  TestCaseResultList listTestCaseResults(@Param("fqn") String fqn, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listTestCaseResults</code> method in a fluent style.
   */
  public static class ListTestCaseResultsQueryParams extends HashMap<String, Object> {
    public ListTestCaseResultsQueryParams startTs(final BigDecimal value) {
      put("startTs", EncodingUtils.encode(value));
      return this;
    }
    public ListTestCaseResultsQueryParams endTs(final BigDecimal value) {
      put("endTs", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * List testCases
   * Get a list of test. Use &#x60;fields&#x60; parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * @param fields Fields requested in the returned resource (optional)
   * @param limit Limit the number tests returned. (1 to 1000000, default &#x3D; 10) (optional)
   * @param before Returns list of tests before this cursor (optional)
   * @param after Returns list of tests after this cursor (optional)
   * @param entityLink Return list of tests by entity link (optional)
   * @param testSuiteId Returns list of tests filtered by the testSuite id (optional)
   * @param includeAllTests Include all the tests at the entity level (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return TestCaseList
   */
  @RequestLine("GET /v1/testCase?fields={fields}&limit={limit}&before={before}&after={after}&entityLink={entityLink}&testSuiteId={testSuiteId}&includeAllTests={includeAllTests}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  TestCaseList listTestCases(@Param("fields") String fields, @Param("limit") Integer limit, @Param("before") String before, @Param("after") String after, @Param("entityLink") String entityLink, @Param("testSuiteId") String testSuiteId, @Param("includeAllTests") Boolean includeAllTests, @Param("include") String include);

  /**
   * List testCases
   * Get a list of test. Use &#x60;fields&#x60; parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * Note, this is equivalent to the other <code>listTestCases</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListTestCasesQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>limit - Limit the number tests returned. (1 to 1000000, default &#x3D; 10) (optional)</li>
   *   <li>before - Returns list of tests before this cursor (optional)</li>
   *   <li>after - Returns list of tests after this cursor (optional)</li>
   *   <li>entityLink - Return list of tests by entity link (optional)</li>
   *   <li>testSuiteId - Returns list of tests filtered by the testSuite id (optional)</li>
   *   <li>includeAllTests - Include all the tests at the entity level (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return TestCaseList

   */
  @RequestLine("GET /v1/testCase?fields={fields}&limit={limit}&before={before}&after={after}&entityLink={entityLink}&testSuiteId={testSuiteId}&includeAllTests={includeAllTests}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  TestCaseList listTestCases(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listTestCases</code> method in a fluent style.
   */
  public static class ListTestCasesQueryParams extends HashMap<String, Object> {
    public ListTestCasesQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public ListTestCasesQueryParams limit(final Integer value) {
      put("limit", EncodingUtils.encode(value));
      return this;
    }
    public ListTestCasesQueryParams before(final String value) {
      put("before", EncodingUtils.encode(value));
      return this;
    }
    public ListTestCasesQueryParams after(final String value) {
      put("after", EncodingUtils.encode(value));
      return this;
    }
    public ListTestCasesQueryParams entityLink(final String value) {
      put("entityLink", EncodingUtils.encode(value));
      return this;
    }
    public ListTestCasesQueryParams testSuiteId(final String value) {
      put("testSuiteId", EncodingUtils.encode(value));
      return this;
    }
    public ListTestCasesQueryParams includeAllTests(final Boolean value) {
      put("includeAllTests", EncodingUtils.encode(value));
      return this;
    }
    public ListTestCasesQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Update a testCase
   * Update an existing test using JsonPatch.
   * @param id  (required)
   * @param body JsonPatch with array of operations (optional)
   * JsonPatch RFC
   * @see <a href="https://tools.ietf.org/html/rfc6902">Update a testCase Documentation</a>
   */
  @RequestLine("PATCH /v1/testCase/{id}")
  @Headers({
      "Content-Type: application/json-patch+json",
      "Accept: application/json",
  })
  void patchTest(@Param("id") UUID id, Object body);
  /**
   * Restore a soft deleted TestCase.
   * Restore a soft deleted TestCase.
   * @param body  (optional)
   * @return TestCase
   */
  @RequestLine("PUT /v1/testCase/restore")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  TestCase restore8(RestoreEntity body);
}
