package org.openmetadata.client.api;

import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;

import org.openmetadata.client.model.CreateTestDefinition;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.TestDefinition;
import org.openmetadata.client.model.TestDefinitionList;
import java.util.UUID;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")public interface TestDefinitionsApi extends ApiClient.Api {

  /**
   * Update test definition
   * Create a definition, it it does not exist or update an existing test definition.
   * @param body  (optional)
   * @return TestDefinition
   */
  @RequestLine("PUT /v1/testDefinition")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  TestDefinition createOrUpdateTestDefinition(CreateTestDefinition body);
  /**
   * Create a Test Definition
   * Create a Test definition.
   * @param body  (optional)
   * @return TestDefinition
   */
  @RequestLine("POST /v1/testDefinition")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  TestDefinition createTestDefinition(CreateTestDefinition body);
  /**
   * Delete a test definition
   * Delete a test definition by &#x60;id&#x60;.
   * @param id Topic Id (required)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/testDefinition/{id}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteTestDefinition(@Param("id") UUID id, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a test definition
   * Delete a test definition by &#x60;id&#x60;.
   * Note, this is equivalent to the other <code>deleteTestDefinition</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteTestDefinitionQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id Topic Id (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/testDefinition/{id}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteTestDefinition(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteTestDefinition</code> method in a fluent style.
   */
  public static class DeleteTestDefinitionQueryParams extends HashMap<String, Object> {
    public DeleteTestDefinitionQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Delete a test definition
   * Delete a test definition by &#x60;name&#x60;.
   * @param name Name of the TestDefinition (required)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/testDefinition/name/{name}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteTestDefinitionByName(@Param("name") String name, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a test definition
   * Delete a test definition by &#x60;name&#x60;.
   * Note, this is equivalent to the other <code>deleteTestDefinitionByName</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteTestDefinitionByNameQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param name Name of the TestDefinition (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/testDefinition/name/{name}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteTestDefinitionByName(@Param("name") String name, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteTestDefinitionByName</code> method in a fluent style.
   */
  public static class DeleteTestDefinitionByNameQueryParams extends HashMap<String, Object> {
    public DeleteTestDefinitionByNameQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a Test Definition
   * Get a Test Definition by &#x60;id&#x60;.
   * @param id  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return TestDefinition
   */
  @RequestLine("GET /v1/testDefinition/{id}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  TestDefinition get1(@Param("id") UUID id, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a Test Definition
   * Get a Test Definition by &#x60;id&#x60;.
   * Note, this is equivalent to the other <code>get1</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link Get1QueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return TestDefinition

   */
  @RequestLine("GET /v1/testDefinition/{id}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  TestDefinition get1(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>get1</code> method in a fluent style.
   */
  public static class Get1QueryParams extends HashMap<String, Object> {
    public Get1QueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public Get1QueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a version of the TestDefinition
   * Get a version of the test definition by given &#x60;id&#x60;
   * @param id Test Definition Id (required)
   * @param version Test Definition version number in the form &#x60;major&#x60;.&#x60;minor&#x60; (required)
   * @return TestDefinition
   */
  @RequestLine("GET /v1/testDefinition/{id}/versions/{version}")
  @Headers({
      "Accept: application/json",
  })
  TestDefinition getSpecificTestDefinitionVersion(@Param("id") String id, @Param("version") String version);
  /**
   * Get a test definition by name
   * Get a test definition by &#x60;name&#x60;.
   * @param name  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return TestDefinition
   */
  @RequestLine("GET /v1/testDefinition/name/{name}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  TestDefinition getTestDefinitionByName(@Param("name") String name, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a test definition by name
   * Get a test definition by &#x60;name&#x60;.
   * Note, this is equivalent to the other <code>getTestDefinitionByName</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetTestDefinitionByNameQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param name  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return TestDefinition

   */
  @RequestLine("GET /v1/testDefinition/name/{name}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  TestDefinition getTestDefinitionByName(@Param("name") String name, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getTestDefinitionByName</code> method in a fluent style.
   */
  public static class GetTestDefinitionByNameQueryParams extends HashMap<String, Object> {
    public GetTestDefinitionByNameQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetTestDefinitionByNameQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * List test definition versions
   * Get a list of all the versions of a test definition identified by &#x60;id&#x60;
   * @param id Test Definition Id (required)
   * @return EntityHistory
   */
  @RequestLine("GET /v1/testDefinition/{id}/versions")
  @Headers({
      "Accept: application/json",
  })
  EntityHistory listAllTestDefinitionVersion(@Param("id") String id);
  /**
   * List test definitions
   * Get a list of test definitions, optionally filtered by &#x60;service&#x60; it belongs to. Use &#x60;fields&#x60; parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * @param fields Fields requested in the returned resource (optional)
   * @param limit Limit the number test definitions returned. (1 to 1000000, default &#x3D; 10) (optional)
   * @param before Returns list of test definitions before this cursor (optional)
   * @param after Returns list of test definitions after this cursor (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @param entityType Filter by entityType. (optional)
   * @param testPlatform Filter by a test platform (optional)
   * @param supportedDataType Filter tests definition by supported data type (optional)
   * @return TestDefinitionList
   */
  @RequestLine("GET /v1/testDefinition?fields={fields}&limit={limit}&before={before}&after={after}&include={include}&entityType={entityType}&testPlatform={testPlatform}&supportedDataType={supportedDataType}")
  @Headers({
      "Accept: application/json",
  })
  TestDefinitionList listTestDefinitions(@Param("fields") String fields, @Param("limit") Integer limit, @Param("before") String before, @Param("after") String after, @Param("include") String include, @Param("entityType") String entityType, @Param("testPlatform") String testPlatform, @Param("supportedDataType") String supportedDataType);

  /**
   * List test definitions
   * Get a list of test definitions, optionally filtered by &#x60;service&#x60; it belongs to. Use &#x60;fields&#x60; parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * Note, this is equivalent to the other <code>listTestDefinitions</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListTestDefinitionsQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>limit - Limit the number test definitions returned. (1 to 1000000, default &#x3D; 10) (optional)</li>
   *   <li>before - Returns list of test definitions before this cursor (optional)</li>
   *   <li>after - Returns list of test definitions after this cursor (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   <li>entityType - Filter by entityType. (optional)</li>
   *   <li>testPlatform - Filter by a test platform (optional)</li>
   *   <li>supportedDataType - Filter tests definition by supported data type (optional)</li>
   *   </ul>
   * @return TestDefinitionList

   */
  @RequestLine("GET /v1/testDefinition?fields={fields}&limit={limit}&before={before}&after={after}&include={include}&entityType={entityType}&testPlatform={testPlatform}&supportedDataType={supportedDataType}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  TestDefinitionList listTestDefinitions(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listTestDefinitions</code> method in a fluent style.
   */
  public static class ListTestDefinitionsQueryParams extends HashMap<String, Object> {
    public ListTestDefinitionsQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public ListTestDefinitionsQueryParams limit(final Integer value) {
      put("limit", EncodingUtils.encode(value));
      return this;
    }
    public ListTestDefinitionsQueryParams before(final String value) {
      put("before", EncodingUtils.encode(value));
      return this;
    }
    public ListTestDefinitionsQueryParams after(final String value) {
      put("after", EncodingUtils.encode(value));
      return this;
    }
    public ListTestDefinitionsQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
    public ListTestDefinitionsQueryParams entityType(final String value) {
      put("entityType", EncodingUtils.encode(value));
      return this;
    }
    public ListTestDefinitionsQueryParams testPlatform(final String value) {
      put("testPlatform", EncodingUtils.encode(value));
      return this;
    }
    public ListTestDefinitionsQueryParams supportedDataType(final String value) {
      put("supportedDataType", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Update a test definition
   * Update an existing topic using JsonPatch.
   * @param id  (required)
   * @param body JsonPatch with array of operations (optional)
   * JsonPatch RFC
   * @see <a href="https://tools.ietf.org/html/rfc6902">Update a test definition Documentation</a>
   */
  @RequestLine("PATCH /v1/testDefinition/{id}")
  @Headers({
      "Content-Type: application/json-patch+json",
      "Accept: application/json",
  })
  void patchTestDefinition(@Param("id") UUID id, Object body);
  /**
   * Restore a soft deleted TestDefinition.
   * Restore a soft deleted TestDefinition.
   * @param body  (optional)
   * @return TestDefinition
   */
  @RequestLine("PUT /v1/testDefinition/restore")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  TestDefinition restore9(RestoreEntity body);
}
