package org.openmetadata.client.api;

import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;

import org.openmetadata.client.model.CreateTestSuite;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.TestSuite;
import org.openmetadata.client.model.TestSuiteList;
import java.util.UUID;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")public interface TestSuitesApi extends ApiClient.Api {

  /**
   * Update test suite
   * Create a TestSuite, it it does not exist or update an existing test suite.
   * @param body  (optional)
   * @return TestSuite
   */
  @RequestLine("PUT /v1/testSuite")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  TestSuite createOrUpdateTestSuite(CreateTestSuite body);
  /**
   * Create a Test Suite
   * Create a Test suite.
   * @param body  (optional)
   * @return TestSuite
   */
  @RequestLine("POST /v1/testSuite")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  TestSuite createTestSuite(CreateTestSuite body);
  /**
   * Delete a test suite
   * Delete a test suite by &#x60;id&#x60;.
   * @param id TestSuite Id (required)
   * @param recursive Recursively delete this entity and it&#x27;s children. (Default &#x60;false&#x60;) (optional)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/testSuite/{id}?recursive={recursive}&hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteTestSuite(@Param("id") UUID id, @Param("recursive") Boolean recursive, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a test suite
   * Delete a test suite by &#x60;id&#x60;.
   * Note, this is equivalent to the other <code>deleteTestSuite</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteTestSuiteQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id TestSuite Id (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>recursive - Recursively delete this entity and it&#x27;s children. (Default &#x60;false&#x60;) (optional)</li>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/testSuite/{id}?recursive={recursive}&hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteTestSuite(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteTestSuite</code> method in a fluent style.
   */
  public static class DeleteTestSuiteQueryParams extends HashMap<String, Object> {
    public DeleteTestSuiteQueryParams recursive(final Boolean value) {
      put("recursive", EncodingUtils.encode(value));
      return this;
    }
    public DeleteTestSuiteQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Delete a test suite
   * Delete a test suite by &#x60;name&#x60;.
   * @param name Name of the TestSuite (required)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/testSuite/name/{name}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteTestSuiteByName(@Param("name") String name, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a test suite
   * Delete a test suite by &#x60;name&#x60;.
   * Note, this is equivalent to the other <code>deleteTestSuiteByName</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteTestSuiteByNameQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param name Name of the TestSuite (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/testSuite/name/{name}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteTestSuiteByName(@Param("name") String name, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteTestSuiteByName</code> method in a fluent style.
   */
  public static class DeleteTestSuiteByNameQueryParams extends HashMap<String, Object> {
    public DeleteTestSuiteByNameQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a Test Suite
   * Get a Test Suite by &#x60;id&#x60;.
   * @param id  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return TestSuite
   */
  @RequestLine("GET /v1/testSuite/{id}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  TestSuite get2(@Param("id") UUID id, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a Test Suite
   * Get a Test Suite by &#x60;id&#x60;.
   * Note, this is equivalent to the other <code>get2</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link Get2QueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return TestSuite

   */
  @RequestLine("GET /v1/testSuite/{id}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  TestSuite get2(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>get2</code> method in a fluent style.
   */
  public static class Get2QueryParams extends HashMap<String, Object> {
    public Get2QueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public Get2QueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a version of the TestSuite
   * Get a version of the test suite by given &#x60;id&#x60;
   * @param id Test Suite Id (required)
   * @param version Test Suite version number in the form &#x60;major&#x60;.&#x60;minor&#x60; (required)
   * @return TestSuite
   */
  @RequestLine("GET /v1/testSuite/{id}/versions/{version}")
  @Headers({
      "Accept: application/json",
  })
  TestSuite getSpecificTestSuiteVersion(@Param("id") String id, @Param("version") String version);
  /**
   * Get a test suite by name
   * Get a test suite by  name.
   * @param name  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return TestSuite
   */
  @RequestLine("GET /v1/testSuite/name/{name}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  TestSuite getTestSuiteByName(@Param("name") String name, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a test suite by name
   * Get a test suite by  name.
   * Note, this is equivalent to the other <code>getTestSuiteByName</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetTestSuiteByNameQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param name  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return TestSuite

   */
  @RequestLine("GET /v1/testSuite/name/{name}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  TestSuite getTestSuiteByName(@Param("name") String name, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getTestSuiteByName</code> method in a fluent style.
   */
  public static class GetTestSuiteByNameQueryParams extends HashMap<String, Object> {
    public GetTestSuiteByNameQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetTestSuiteByNameQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * List test suite versions
   * Get a list of all the versions of a test suite identified by &#x60;id&#x60;
   * @param id Test Suite Id (required)
   * @return EntityHistory
   */
  @RequestLine("GET /v1/testSuite/{id}/versions")
  @Headers({
      "Accept: application/json",
  })
  EntityHistory listAllTestSuiteVersion(@Param("id") String id);
  /**
   * List test suites
   * Get a list of test suites. Use &#x60;fields&#x60; parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * @param fields Fields requested in the returned resource (optional)
   * @param limit Limit the number test definitions returned. (1 to 1000000, default &#x3D; 10) (optional)
   * @param before Returns list of test definitions before this cursor (optional)
   * @param after Returns list of test definitions after this cursor (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return TestSuiteList
   */
  @RequestLine("GET /v1/testSuite?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  TestSuiteList listTestSuites(@Param("fields") String fields, @Param("limit") Integer limit, @Param("before") String before, @Param("after") String after, @Param("include") String include);

  /**
   * List test suites
   * Get a list of test suites. Use &#x60;fields&#x60; parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * Note, this is equivalent to the other <code>listTestSuites</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListTestSuitesQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>limit - Limit the number test definitions returned. (1 to 1000000, default &#x3D; 10) (optional)</li>
   *   <li>before - Returns list of test definitions before this cursor (optional)</li>
   *   <li>after - Returns list of test definitions after this cursor (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return TestSuiteList

   */
  @RequestLine("GET /v1/testSuite?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  TestSuiteList listTestSuites(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listTestSuites</code> method in a fluent style.
   */
  public static class ListTestSuitesQueryParams extends HashMap<String, Object> {
    public ListTestSuitesQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public ListTestSuitesQueryParams limit(final Integer value) {
      put("limit", EncodingUtils.encode(value));
      return this;
    }
    public ListTestSuitesQueryParams before(final String value) {
      put("before", EncodingUtils.encode(value));
      return this;
    }
    public ListTestSuitesQueryParams after(final String value) {
      put("after", EncodingUtils.encode(value));
      return this;
    }
    public ListTestSuitesQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Update a test suite
   * Update an existing testSuite using JsonPatch.
   * @param id  (required)
   * @param body JsonPatch with array of operations (optional)
   * JsonPatch RFC
   * @see <a href="https://tools.ietf.org/html/rfc6902">Update a test suite Documentation</a>
   */
  @RequestLine("PATCH /v1/testSuite/{id}")
  @Headers({
      "Content-Type: application/json-patch+json",
      "Accept: application/json",
  })
  void patchTestSuite(@Param("id") UUID id, Object body);
  /**
   * Restore a soft deleted TestSuite.
   * Restore a soft deleted TestSuite.
   * @param body  (optional)
   * @return TestSuite
   */
  @RequestLine("PUT /v1/testSuite/restore")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  TestSuite restore10(RestoreEntity body);
}
