package org.openmetadata.client.api;

import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;

import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateTopic;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.Topic;
import org.openmetadata.client.model.TopicList;
import org.openmetadata.client.model.TopicSampleData;
import java.util.UUID;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")public interface TopicsApi extends ApiClient.Api {

  /**
   * Add a follower
   * Add a user identified by &#x60;userId&#x60; as followed of this topic
   * @param id Id of the topic (required)
   * @param body Id of the user to be added as follower (optional)
   * @return ChangeEvent
   */
  @RequestLine("PUT /v1/topics/{id}/followers")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  ChangeEvent addFollower3(@Param("id") UUID id, UUID body);
  /**
   * Add sample data
   * Add sample data to the topic.
   * @param id Id of the topic (required)
   * @param body  (optional)
   * @return Topic
   */
  @RequestLine("PUT /v1/topics/{id}/sampleData")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Topic addSampleData1(@Param("id") String id, TopicSampleData body);
  /**
   * Update topic
   * Create a topic, it it does not exist or update an existing topic.
   * @param body  (optional)
   * @return Topic
   */
  @RequestLine("PUT /v1/topics")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Topic createOrUpdateTopic(CreateTopic body);
  /**
   * Create a topic
   * Create a topic under an existing &#x60;service&#x60;.
   * @param body  (optional)
   * @return Topic
   */
  @RequestLine("POST /v1/topics")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Topic createTopic(CreateTopic body);
  /**
   * Remove a follower
   * Remove the user identified &#x60;userId&#x60; as a follower of the topic.
   * @param id Id of the topic (required)
   * @param userId Id of the user being removed as follower (required)
   * @return ChangeEvent
   */
  @RequestLine("DELETE /v1/topics/{id}/followers/{userId}")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  ChangeEvent deleteFollower4(@Param("id") String id, @Param("userId") String userId);
  /**
   * Delete a topic
   * Delete a topic by &#x60;id&#x60;.
   * @param id Topic Id (required)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/topics/{id}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteTopic(@Param("id") UUID id, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a topic
   * Delete a topic by &#x60;id&#x60;.
   * Note, this is equivalent to the other <code>deleteTopic</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteTopicQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id Topic Id (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/topics/{id}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteTopic(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteTopic</code> method in a fluent style.
   */
  public static class DeleteTopicQueryParams extends HashMap<String, Object> {
    public DeleteTopicQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Delete a topic
   * Delete a topic by &#x60;fullyQualifiedName&#x60;.
   * @param fqn Name of the topic (required)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/topics/name/{fqn}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteTopicByFQN(@Param("fqn") String fqn, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a topic
   * Delete a topic by &#x60;fullyQualifiedName&#x60;.
   * Note, this is equivalent to the other <code>deleteTopicByFQN</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteTopicByFQNQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param fqn Name of the topic (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/topics/name/{fqn}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteTopicByFQN(@Param("fqn") String fqn, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteTopicByFQN</code> method in a fluent style.
   */
  public static class DeleteTopicByFQNQueryParams extends HashMap<String, Object> {
    public DeleteTopicByFQNQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a topic
   * Get a topic by &#x60;id&#x60;.
   * @param id  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return Topic
   */
  @RequestLine("GET /v1/topics/{id}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  Topic get4(@Param("id") UUID id, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a topic
   * Get a topic by &#x60;id&#x60;.
   * Note, this is equivalent to the other <code>get4</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link Get4QueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return Topic

   */
  @RequestLine("GET /v1/topics/{id}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  Topic get4(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>get4</code> method in a fluent style.
   */
  public static class Get4QueryParams extends HashMap<String, Object> {
    public Get4QueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public Get4QueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a version of the topic
   * Get a version of the topic by given &#x60;id&#x60;
   * @param id Topic Id (required)
   * @param version Topic version number in the form &#x60;major&#x60;.&#x60;minor&#x60; (required)
   * @return Topic
   */
  @RequestLine("GET /v1/topics/{id}/versions/{version}")
  @Headers({
      "Accept: application/json",
  })
  Topic getSpecificTopicVersion(@Param("id") String id, @Param("version") String version);
  /**
   * Get a topic by name
   * Get a topic by fully qualified name.
   * @param fqn  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return Topic
   */
  @RequestLine("GET /v1/topics/name/{fqn}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  Topic getTopicByFQN(@Param("fqn") String fqn, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a topic by name
   * Get a topic by fully qualified name.
   * Note, this is equivalent to the other <code>getTopicByFQN</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetTopicByFQNQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param fqn  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return Topic

   */
  @RequestLine("GET /v1/topics/name/{fqn}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  Topic getTopicByFQN(@Param("fqn") String fqn, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getTopicByFQN</code> method in a fluent style.
   */
  public static class GetTopicByFQNQueryParams extends HashMap<String, Object> {
    public GetTopicByFQNQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetTopicByFQNQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * List topic versions
   * Get a list of all the versions of a topic identified by &#x60;id&#x60;
   * @param id Topic Id (required)
   * @return EntityHistory
   */
  @RequestLine("GET /v1/topics/{id}/versions")
  @Headers({
      "Accept: application/json",
  })
  EntityHistory listAllTopicVersion(@Param("id") String id);
  /**
   * List topics
   * Get a list of topics, optionally filtered by &#x60;service&#x60; it belongs to. Use &#x60;fields&#x60; parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * @param fields Fields requested in the returned resource (optional)
   * @param service Filter topics by service name (optional)
   * @param limit Limit the number topics returned. (1 to 1000000, default &#x3D; 10) (optional)
   * @param before Returns list of topics before this cursor (optional)
   * @param after Returns list of topics after this cursor (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return TopicList
   */
  @RequestLine("GET /v1/topics?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  TopicList listTopics(@Param("fields") String fields, @Param("service") String service, @Param("limit") Integer limit, @Param("before") String before, @Param("after") String after, @Param("include") String include);

  /**
   * List topics
   * Get a list of topics, optionally filtered by &#x60;service&#x60; it belongs to. Use &#x60;fields&#x60; parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * Note, this is equivalent to the other <code>listTopics</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListTopicsQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>service - Filter topics by service name (optional)</li>
   *   <li>limit - Limit the number topics returned. (1 to 1000000, default &#x3D; 10) (optional)</li>
   *   <li>before - Returns list of topics before this cursor (optional)</li>
   *   <li>after - Returns list of topics after this cursor (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return TopicList

   */
  @RequestLine("GET /v1/topics?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  TopicList listTopics(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listTopics</code> method in a fluent style.
   */
  public static class ListTopicsQueryParams extends HashMap<String, Object> {
    public ListTopicsQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public ListTopicsQueryParams service(final String value) {
      put("service", EncodingUtils.encode(value));
      return this;
    }
    public ListTopicsQueryParams limit(final Integer value) {
      put("limit", EncodingUtils.encode(value));
      return this;
    }
    public ListTopicsQueryParams before(final String value) {
      put("before", EncodingUtils.encode(value));
      return this;
    }
    public ListTopicsQueryParams after(final String value) {
      put("after", EncodingUtils.encode(value));
      return this;
    }
    public ListTopicsQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Update a topic
   * Update an existing topic using JsonPatch.
   * @param id  (required)
   * @param body JsonPatch with array of operations (optional)
   * JsonPatch RFC
   * @see <a href="https://tools.ietf.org/html/rfc6902">Update a topic Documentation</a>
   */
  @RequestLine("PATCH /v1/topics/{id}")
  @Headers({
      "Content-Type: application/json-patch+json",
      "Accept: application/json",
  })
  void patchTopic(@Param("id") UUID id, Object body);
  /**
   * Restore a soft deleted topic.
   * Restore a soft deleted topic.
   * @param body  (optional)
   * @return Topic
   */
  @RequestLine("PUT /v1/topics/restore")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Topic restore29(RestoreEntity body);
}
