package org.openmetadata.client.api;

import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;

import org.openmetadata.client.model.AuthenticationMechanism;
import org.openmetadata.client.model.ChangePasswordRequest;
import org.openmetadata.client.model.CreateUser;
import org.openmetadata.client.model.EmailRequest;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.GenerateTokenRequest;
import org.openmetadata.client.model.JWTAuthMechanism;
import org.openmetadata.client.model.LoginRequest;
import org.openmetadata.client.model.LogoutRequest;
import org.openmetadata.client.model.PasswordResetRequest;
import org.openmetadata.client.model.RegistrationRequest;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.RevokeTokenRequest;
import org.openmetadata.client.model.TokenRefreshRequest;
import java.util.UUID;
import org.openmetadata.client.model.User;
import org.openmetadata.client.model.UserList;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")public interface UsersApi extends ApiClient.Api {

  /**
   * Change Password For User
   * Create a new user.
   * @param body  (optional)
   * @return User
   */
  @RequestLine("PUT /v1/users/changePassword")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  User changeUserPassword(ChangePasswordRequest body);
  /**
   * Check if a mail is already in use
   * Check if a mail is already in use
   * @param body  (optional)
   * @return Boolean
   */
  @RequestLine("POST /v1/users/checkEmailInUse")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Boolean checkEmailInUse(EmailRequest body);
  /**
   * Check if a mail is verified
   * Check if a mail is already in use
   * @param body  (optional)
   * @return Boolean
   */
  @RequestLine("POST /v1/users/checkEmailVerified")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Boolean checkEmailIsVerified(EmailRequest body);
  /**
   * Confirm User Email
   * Confirm User Email
   * @param token Token sent for Email Confirmation (optional)
   */
  @RequestLine("PUT /v1/users/registrationConfirmation?token={token}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void confirmUserEmail(@Param("token") String token);

  /**
   * Confirm User Email
   * Confirm User Email
   * Note, this is equivalent to the other <code>confirmUserEmail</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ConfirmUserEmailQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>token - Token sent for Email Confirmation (optional)</li>
   *   </ul>

   */
  @RequestLine("PUT /v1/users/registrationConfirmation?token={token}")
  @Headers({
      "Content-Type: application/json",
  })
  void confirmUserEmail(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>confirmUserEmail</code> method in a fluent style.
   */
  public static class ConfirmUserEmailQueryParams extends HashMap<String, Object> {
    public ConfirmUserEmailQueryParams token(final String value) {
      put("token", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Update user
   * Create or Update a user.
   * @param body  (optional)
   * @return CreateUser
   */
  @RequestLine("PUT /v1/users")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  CreateUser createOrUpdateUser(CreateUser body);
  /**
   * Create a user
   * Create a new user.
   * @param body  (optional)
   * @return User
   */
  @RequestLine("POST /v1/users")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  User createUser(CreateUser body);
  /**
   * Delete a user
   * Users can&#x27;t be deleted but are soft-deleted.
   * @param id User Id (required)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/users/{id}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteUser(@Param("id") UUID id, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a user
   * Users can&#x27;t be deleted but are soft-deleted.
   * Note, this is equivalent to the other <code>deleteUser</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteUserQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id User Id (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/users/{id}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteUser(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteUser</code> method in a fluent style.
   */
  public static class DeleteUserQueryParams extends HashMap<String, Object> {
    public DeleteUserQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Delete a user
   * Users can&#x27;t be deleted but are soft-deleted.
   * @param name Name of the user (required)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/users/name/{name}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteUserByName(@Param("name") String name, @Param("hardDelete") Boolean hardDelete);

  /**
   * Delete a user
   * Users can&#x27;t be deleted but are soft-deleted.
   * Note, this is equivalent to the other <code>deleteUserByName</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteUserByNameQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param name Name of the user (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/users/name/{name}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteUserByName(@Param("name") String name, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteUserByName</code> method in a fluent style.
   */
  public static class DeleteUserByNameQueryParams extends HashMap<String, Object> {
    public DeleteUserByNameQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Generate JWT Token for a Bot User
   * Generate JWT Token for a Bot User.
   * @param id  (required)
   * @param body  (optional)
   * @return String
   */
  @RequestLine("PUT /v1/users/generateToken/{id}")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  String generateJWTTokenForBotUser(@Param("id") UUID id, GenerateTokenRequest body);
  /**
   * Generate Password Reset Link
   * Generate Password Reset Link
   * @param body  (optional)
   */
  @RequestLine("POST /v1/users/generatePasswordResetLink")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void generatePasswordResetLink(EmailRequest body);
  /**
   * generateRandomPwd
   * Generate a random pwd
   */
  @RequestLine("GET /v1/users/generateRandomPwd")
  @Headers({
      "Accept: */*",
  })
  void generateRandomPwd();
  /**
   * Get Authentication Mechanism for a Bot User
   * Get Authentication Mechanism for a Bot User.
   * @param id  (required)
   * @return AuthenticationMechanism
   */
  @RequestLine("GET /v1/users/auth-mechanism/{id}")
  @Headers({
      "Accept: application/json",
  })
  AuthenticationMechanism getAuthenticationMechanismBotUser(@Param("id") UUID id);
  /**
   * Get current logged in user
   * Get the user who is authenticated and is currently logged in.
   * @param fields Fields requested in the returned resource (optional)
   * @return User
   */
  @RequestLine("GET /v1/users/loggedInUser?fields={fields}")
  @Headers({
      "Accept: application/json",
  })
  User getCurrentLoggedInUser(@Param("fields") String fields);

  /**
   * Get current logged in user
   * Get the user who is authenticated and is currently logged in.
   * Note, this is equivalent to the other <code>getCurrentLoggedInUser</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetCurrentLoggedInUserQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   </ul>
   * @return User

   */
  @RequestLine("GET /v1/users/loggedInUser?fields={fields}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  User getCurrentLoggedInUser(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getCurrentLoggedInUser</code> method in a fluent style.
   */
  public static class GetCurrentLoggedInUserQueryParams extends HashMap<String, Object> {
    public GetCurrentLoggedInUserQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get group type of teams for current logged in user
   * Get the group type of teams of user who is authenticated and is currently logged in.
   * @return List&lt;EntityReference&gt;
   */
  @RequestLine("GET /v1/users/loggedInUser/groupTeams")
  @Headers({
      "Accept: application/json",
  })
  List<EntityReference> getCurrentLoggedInUserGroupTeams();
  /**
   * Get JWT Token for a Bot User
   * Get JWT Token for a Bot User.
   * @param id  (required)
   * @return JWTAuthMechanism
   */
  @RequestLine("GET /v1/users/token/{id}")
  @Headers({
      "Accept: application/json",
  })
  JWTAuthMechanism getJWTTokenForBotUser(@Param("id") UUID id);
  /**
   * Get a version of the user
   * Get a version of the user by given &#x60;id&#x60;
   * @param id User Id (required)
   * @param version User version number in the form &#x60;major&#x60;.&#x60;minor&#x60; (required)
   * @return User
   */
  @RequestLine("GET /v1/users/{id}/versions/{version}")
  @Headers({
      "Accept: application/json",
  })
  User getSpecificUserVersion(@Param("id") String id, @Param("version") String version);
  /**
   * Get a user by name
   * Get a user by &#x60;name&#x60;.
   * @param name  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return User
   */
  @RequestLine("GET /v1/users/name/{name}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  User getUserByFQN(@Param("name") String name, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a user by name
   * Get a user by &#x60;name&#x60;.
   * Note, this is equivalent to the other <code>getUserByFQN</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetUserByFQNQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param name  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return User

   */
  @RequestLine("GET /v1/users/name/{name}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  User getUserByFQN(@Param("name") String name, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getUserByFQN</code> method in a fluent style.
   */
  public static class GetUserByFQNQueryParams extends HashMap<String, Object> {
    public GetUserByFQNQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetUserByFQNQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a user
   * Get a user by &#x60;id&#x60;
   * @param id  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return User
   */
  @RequestLine("GET /v1/users/{id}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  User getUserByID(@Param("id") UUID id, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a user
   * Get a user by &#x60;id&#x60;
   * Note, this is equivalent to the other <code>getUserByID</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetUserByIDQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return User

   */
  @RequestLine("GET /v1/users/{id}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  User getUserByID(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getUserByID</code> method in a fluent style.
   */
  public static class GetUserByIDQueryParams extends HashMap<String, Object> {
    public GetUserByIDQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetUserByIDQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * List user versions
   * Get a list of all the versions of a user identified by &#x60;id&#x60;
   * @param id user Id (required)
   * @return EntityHistory
   */
  @RequestLine("GET /v1/users/{id}/versions")
  @Headers({
      "Accept: application/json",
  })
  EntityHistory listAllUserVersion(@Param("id") String id);
  /**
   * List users
   * Get a list of users. Use &#x60;fields&#x60; parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * @param fields Fields requested in the returned resource (optional)
   * @param team Filter users by team (optional)
   * @param limit Limit the number users returned. (1 to 1000000, default &#x3D; 10) (optional)
   * @param before Returns list of users before this cursor (optional)
   * @param after Returns list of users after this cursor (optional)
   * @param isAdmin Returns list of admin users if set to true (optional)
   * @param isBot Returns list of bot users if set to true (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return UserList
   */
  @RequestLine("GET /v1/users?fields={fields}&team={team}&limit={limit}&before={before}&after={after}&isAdmin={isAdmin}&isBot={isBot}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  UserList listUsers(@Param("fields") String fields, @Param("team") String team, @Param("limit") Integer limit, @Param("before") String before, @Param("after") String after, @Param("isAdmin") Boolean isAdmin, @Param("isBot") Boolean isBot, @Param("include") String include);

  /**
   * List users
   * Get a list of users. Use &#x60;fields&#x60; parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * Note, this is equivalent to the other <code>listUsers</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListUsersQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>team - Filter users by team (optional)</li>
   *   <li>limit - Limit the number users returned. (1 to 1000000, default &#x3D; 10) (optional)</li>
   *   <li>before - Returns list of users before this cursor (optional)</li>
   *   <li>after - Returns list of users after this cursor (optional)</li>
   *   <li>isAdmin - Returns list of admin users if set to true (optional)</li>
   *   <li>isBot - Returns list of bot users if set to true (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return UserList

   */
  @RequestLine("GET /v1/users?fields={fields}&team={team}&limit={limit}&before={before}&after={after}&isAdmin={isAdmin}&isBot={isBot}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  UserList listUsers(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listUsers</code> method in a fluent style.
   */
  public static class ListUsersQueryParams extends HashMap<String, Object> {
    public ListUsersQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public ListUsersQueryParams team(final String value) {
      put("team", EncodingUtils.encode(value));
      return this;
    }
    public ListUsersQueryParams limit(final Integer value) {
      put("limit", EncodingUtils.encode(value));
      return this;
    }
    public ListUsersQueryParams before(final String value) {
      put("before", EncodingUtils.encode(value));
      return this;
    }
    public ListUsersQueryParams after(final String value) {
      put("after", EncodingUtils.encode(value));
      return this;
    }
    public ListUsersQueryParams isAdmin(final Boolean value) {
      put("isAdmin", EncodingUtils.encode(value));
      return this;
    }
    public ListUsersQueryParams isBot(final Boolean value) {
      put("isBot", EncodingUtils.encode(value));
      return this;
    }
    public ListUsersQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Login User by Password
   * Login a user with Password
   * @param body  (optional)
   * @return String
   */
  @RequestLine("POST /v1/users/login")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  String loginUserWithPwd(LoginRequest body);
  /**
   * Logout a User(Only called for saml and basic Auth)
   * Logout a User(Only called for saml and basic Auth)
   * @param body  (optional)
   */
  @RequestLine("POST /v1/users/logout")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void logoutUser(LogoutRequest body);
  /**
   * Update a user
   * Update an existing user using JsonPatch.
   * @param id  (required)
   * @param body JsonPatch with array of operations (optional)
   * JsonPatch RFC
   * @see <a href="https://tools.ietf.org/html/rfc6902">Update a user Documentation</a>
   */
  @RequestLine("PATCH /v1/users/{id}")
  @Headers({
      "Content-Type: application/json-patch+json",
      "Accept: application/json",
  })
  void patchUser(@Param("id") UUID id, Object body);
  /**
   * Provide access token to User with refresh token
   * Provide access token to User with refresh token
   * @param body  (optional)
   * @return String
   */
  @RequestLine("POST /v1/users/refresh")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  String refreshToken(TokenRefreshRequest body);
  /**
   * Register User
   * Register a new User
   * @param body  (optional)
   */
  @RequestLine("POST /v1/users/signup")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void registerUser(RegistrationRequest body);
  /**
   * Resend Registration Token
   * Resend Registration Token
   * @param user Token sent for Email Confirmation Earlier (optional)
   */
  @RequestLine("PUT /v1/users/resendRegistrationToken?user={user}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void resendRegistrationToken(@Param("user") String user);

  /**
   * Resend Registration Token
   * Resend Registration Token
   * Note, this is equivalent to the other <code>resendRegistrationToken</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ResendRegistrationTokenQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>user - Token sent for Email Confirmation Earlier (optional)</li>
   *   </ul>

   */
  @RequestLine("PUT /v1/users/resendRegistrationToken?user={user}")
  @Headers({
      "Content-Type: application/json",
  })
  void resendRegistrationToken(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>resendRegistrationToken</code> method in a fluent style.
   */
  public static class ResendRegistrationTokenQueryParams extends HashMap<String, Object> {
    public ResendRegistrationTokenQueryParams user(final String value) {
      put("user", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Reset Password For User
   * Reset User Password
   * @param body  (optional)
   * @return User
   */
  @RequestLine("POST /v1/users/password/reset")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  User resetUserPassword(PasswordResetRequest body);
  /**
   * Restore a soft deleted User.
   * Restore a soft deleted User.
   * @param body  (optional)
   * @return User
   */
  @RequestLine("PUT /v1/users/restore")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  User restore28(RestoreEntity body);
  /**
   * Revoke JWT Token for a Bot User
   * Revoke JWT Token for a Bot User.
   * @param body  (optional)
   * @return JWTAuthMechanism
   */
  @RequestLine("PUT /v1/users/revokeToken")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  JWTAuthMechanism revokeJWTTokenForBotUser(RevokeTokenRequest body);
}
