package org.openmetadata.client.api;

import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;

import org.openmetadata.client.model.EntitiesCount;
import org.openmetadata.client.model.ServicesCount;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")public interface UtilApi extends ApiClient.Api {

  /**
   * List All Entities Counts
   * Get a List of all Entities Count
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return EntitiesCount
   */
  @RequestLine("GET /v1/util/entities/count?include={include}")
  @Headers({
      "Accept: application/json",
  })
  EntitiesCount listEntitiesCount(@Param("include") String include);

  /**
   * List All Entities Counts
   * Get a List of all Entities Count
   * Note, this is equivalent to the other <code>listEntitiesCount</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListEntitiesCountQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return EntitiesCount

   */
  @RequestLine("GET /v1/util/entities/count?include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  EntitiesCount listEntitiesCount(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listEntitiesCount</code> method in a fluent style.
   */
  public static class ListEntitiesCountQueryParams extends HashMap<String, Object> {
    public ListEntitiesCountQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * List All Services Counts
   * Get a List of all Entities Count
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return ServicesCount
   */
  @RequestLine("GET /v1/util/services/count?include={include}")
  @Headers({
      "Accept: application/json",
  })
  ServicesCount listServicesCount(@Param("include") String include);

  /**
   * List All Services Counts
   * Get a List of all Entities Count
   * Note, this is equivalent to the other <code>listServicesCount</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListServicesCountQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return ServicesCount

   */
  @RequestLine("GET /v1/util/services/count?include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  ServicesCount listServicesCount(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listServicesCount</code> method in a fluent style.
   */
  public static class ListServicesCountQueryParams extends HashMap<String, Object> {
    public ListServicesCountQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
}
