package org.openmetadata.client.api;

import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;

import java.math.BigDecimal;
import org.openmetadata.client.model.CreateWebAnalyticEvent;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import java.util.UUID;
import org.openmetadata.client.model.WebAnalyticEvent;
import org.openmetadata.client.model.WebAnalyticEventData;
import org.openmetadata.client.model.WebAnalyticEventDataList;
import org.openmetadata.client.model.WebAnalyticEventList;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")public interface WebAnalyticEventApi extends ApiClient.Api {

  /**
   * Add web analytic event data
   * Add web analytic event data
   * @param body  (optional)
   * @return WebAnalyticEventData
   */
  @RequestLine("PUT /v1/analytics/webAnalyticEvent/collect")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  WebAnalyticEventData addWebAnalyticEventData(WebAnalyticEventData body);
  /**
   * Update a web analytic event type
   * Update web analytic event type.
   * @param body  (optional)
   * @return WebAnalyticEvent
   */
  @RequestLine("PUT /v1/analytics/webAnalyticEvent")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  WebAnalyticEvent createOrUpdateWebAnalyticEventType(CreateWebAnalyticEvent body);
  /**
   * Create a web analytic event type
   * Create a web analytic event type
   * @param body  (optional)
   * @return WebAnalyticEvent
   */
  @RequestLine("POST /v1/analytics/webAnalyticEvent")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  WebAnalyticEvent createWebAnalyticEventType(CreateWebAnalyticEvent body);
  /**
   * delete web analytic event data before a timestamp
   * Delete web analytic event data before a timestamp.
   * @param name Web Analytic Event type Name (required)
   * @param timestamp Timestamp of the event. Event before the timestamp will be deleted (required)
   */
  @RequestLine("DELETE /v1/analytics/webAnalyticEvent/{name}/{timestamp}/collect")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteWebAnalyticEventData(@Param("name") String name, @Param("timestamp") Long timestamp);
  /**
   * delete a web analytic event type
   * Delete a web analytic event type by id.
   * @param id Web Analytic event Id (required)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/analytics/webAnalyticEvent/{id}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteWebAnalyticEventTypeById(@Param("id") UUID id, @Param("hardDelete") Boolean hardDelete);

  /**
   * delete a web analytic event type
   * Delete a web analytic event type by id.
   * Note, this is equivalent to the other <code>deleteWebAnalyticEventTypeById</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteWebAnalyticEventTypeByIdQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id Web Analytic event Id (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/analytics/webAnalyticEvent/{id}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteWebAnalyticEventTypeById(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteWebAnalyticEventTypeById</code> method in a fluent style.
   */
  public static class DeleteWebAnalyticEventTypeByIdQueryParams extends HashMap<String, Object> {
    public DeleteWebAnalyticEventTypeByIdQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * delete a web analytic event type
   * Delete a web analytic event type by &#x60;name&#x60;.
   * @param name Web Analytic name (required)
   * @param hardDelete Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)
   */
  @RequestLine("DELETE /v1/analytics/webAnalyticEvent/name/{name}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*",
  })
  void deleteWebAnalyticEventTypeByName(@Param("name") String name, @Param("hardDelete") Boolean hardDelete);

  /**
   * delete a web analytic event type
   * Delete a web analytic event type by &#x60;name&#x60;.
   * Note, this is equivalent to the other <code>deleteWebAnalyticEventTypeByName</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link DeleteWebAnalyticEventTypeByNameQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param name Web Analytic name (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>hardDelete - Hard delete the entity. (Default &#x3D; &#x60;false&#x60;) (optional)</li>
   *   </ul>

   */
  @RequestLine("DELETE /v1/analytics/webAnalyticEvent/name/{name}?hardDelete={hardDelete}")
  @Headers({
      "Content-Type: application/json",
  })
  void deleteWebAnalyticEventTypeByName(@Param("name") String name, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>deleteWebAnalyticEventTypeByName</code> method in a fluent style.
   */
  public static class DeleteWebAnalyticEventTypeByNameQueryParams extends HashMap<String, Object> {
    public DeleteWebAnalyticEventTypeByNameQueryParams hardDelete(final Boolean value) {
      put("hardDelete", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a version of the report definition
   * Get a version of the web analytic event type by &#x60;id&#x60;
   * @param id Web Analytic Event type Id (required)
   * @param version Web Analytic Event type version number in the form &#x60;major&#x60;.&#x60;minor&#x60; (required)
   * @return WebAnalyticEvent
   */
  @RequestLine("GET /v1/analytics/webAnalyticEvent/{id}/versions/{version}")
  @Headers({
      "Accept: application/json",
  })
  WebAnalyticEvent getSpecificWebAnalyticEventTypeVersion(@Param("id") String id, @Param("version") String version);
  /**
   * Retrieve web analytic data
   * Retrieve web analytic data.
   * @param eventType Filter web analytic events for a particular event type (optional)
   * @param startTs Filter web analytic events after the given start timestamp (optional)
   * @param endTs Filter web analytic events before the given end timestamp (optional)
   * @return WebAnalyticEventDataList
   */
  @RequestLine("GET /v1/analytics/webAnalyticEvent/collect?eventType={eventType}&startTs={startTs}&endTs={endTs}")
  @Headers({
      "Accept: application/json",
  })
  WebAnalyticEventDataList getWebAnalyticEventData(@Param("eventType") String eventType, @Param("startTs") BigDecimal startTs, @Param("endTs") BigDecimal endTs);

  /**
   * Retrieve web analytic data
   * Retrieve web analytic data.
   * Note, this is equivalent to the other <code>getWebAnalyticEventData</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetWebAnalyticEventDataQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>eventType - Filter web analytic events for a particular event type (optional)</li>
   *   <li>startTs - Filter web analytic events after the given start timestamp (optional)</li>
   *   <li>endTs - Filter web analytic events before the given end timestamp (optional)</li>
   *   </ul>
   * @return WebAnalyticEventDataList

   */
  @RequestLine("GET /v1/analytics/webAnalyticEvent/collect?eventType={eventType}&startTs={startTs}&endTs={endTs}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  WebAnalyticEventDataList getWebAnalyticEventData(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getWebAnalyticEventData</code> method in a fluent style.
   */
  public static class GetWebAnalyticEventDataQueryParams extends HashMap<String, Object> {
    public GetWebAnalyticEventDataQueryParams eventType(final String value) {
      put("eventType", EncodingUtils.encode(value));
      return this;
    }
    public GetWebAnalyticEventDataQueryParams startTs(final BigDecimal value) {
      put("startTs", EncodingUtils.encode(value));
      return this;
    }
    public GetWebAnalyticEventDataQueryParams endTs(final BigDecimal value) {
      put("endTs", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a web analytic event type by id
   * Get a web analytic event type by &#x60;ID&#x60;.
   * @param id  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return WebAnalyticEvent
   */
  @RequestLine("GET /v1/analytics/webAnalyticEvent/{id}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  WebAnalyticEvent getWebAnalyticEventTypeById(@Param("id") UUID id, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a web analytic event type by id
   * Get a web analytic event type by &#x60;ID&#x60;.
   * Note, this is equivalent to the other <code>getWebAnalyticEventTypeById</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetWebAnalyticEventTypeByIdQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param id  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return WebAnalyticEvent

   */
  @RequestLine("GET /v1/analytics/webAnalyticEvent/{id}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  WebAnalyticEvent getWebAnalyticEventTypeById(@Param("id") UUID id, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getWebAnalyticEventTypeById</code> method in a fluent style.
   */
  public static class GetWebAnalyticEventTypeByIdQueryParams extends HashMap<String, Object> {
    public GetWebAnalyticEventTypeByIdQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetWebAnalyticEventTypeByIdQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Get a web analytic event type by Name
   * Get a web analytic event type by Name.
   * @param name  (required)
   * @param fields Fields requested in the returned resource (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return WebAnalyticEvent
   */
  @RequestLine("GET /v1/analytics/webAnalyticEvent/name/{name}?fields={fields}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  WebAnalyticEvent getWebAnalyticEventTypeByName(@Param("name") String name, @Param("fields") String fields, @Param("include") String include);

  /**
   * Get a web analytic event type by Name
   * Get a web analytic event type by Name.
   * Note, this is equivalent to the other <code>getWebAnalyticEventTypeByName</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetWebAnalyticEventTypeByNameQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param name  (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return WebAnalyticEvent

   */
  @RequestLine("GET /v1/analytics/webAnalyticEvent/name/{name}?fields={fields}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  WebAnalyticEvent getWebAnalyticEventTypeByName(@Param("name") String name, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getWebAnalyticEventTypeByName</code> method in a fluent style.
   */
  public static class GetWebAnalyticEventTypeByNameQueryParams extends HashMap<String, Object> {
    public GetWebAnalyticEventTypeByNameQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public GetWebAnalyticEventTypeByNameQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * List web analytic event type versions
   * Get a list of all the version of a web analytic event type by &#x60;id&#x60;.
   * @param id Web Analytic event type Id (required)
   * @return EntityHistory
   */
  @RequestLine("GET /v1/analytics/webAnalyticEvent/{id}/versions")
  @Headers({
      "Accept: application/json",
  })
  EntityHistory listAllWebAnalyticEventTypeVersion(@Param("id") String id);
  /**
   * List web analytic event types
   * Get a list of web analytics event types.Use field parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * @param fields Fields requested in the returned resource (optional)
   * @param limit Limit the number report Definition returned. (1 to 1000000, default &#x3D; 10) (optional)
   * @param before Returns list of report definitions before this cursor (optional)
   * @param after Returns list of report definitions after this cursor (optional)
   * @param include Include all, deleted, or non-deleted entities. (optional)
   * @return WebAnalyticEventList
   */
  @RequestLine("GET /v1/analytics/webAnalyticEvent?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Accept: application/json",
  })
  WebAnalyticEventList listWebAnalyticEventTypes(@Param("fields") String fields, @Param("limit") Integer limit, @Param("before") String before, @Param("after") String after, @Param("include") String include);

  /**
   * List web analytic event types
   * Get a list of web analytics event types.Use field parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using &#x60;limit&#x60; and &#x60;before&#x60; or &#x60;after&#x60; query params.
   * Note, this is equivalent to the other <code>listWebAnalyticEventTypes</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link ListWebAnalyticEventTypesQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>fields - Fields requested in the returned resource (optional)</li>
   *   <li>limit - Limit the number report Definition returned. (1 to 1000000, default &#x3D; 10) (optional)</li>
   *   <li>before - Returns list of report definitions before this cursor (optional)</li>
   *   <li>after - Returns list of report definitions after this cursor (optional)</li>
   *   <li>include - Include all, deleted, or non-deleted entities. (optional)</li>
   *   </ul>
   * @return WebAnalyticEventList

   */
  @RequestLine("GET /v1/analytics/webAnalyticEvent?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  WebAnalyticEventList listWebAnalyticEventTypes(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>listWebAnalyticEventTypes</code> method in a fluent style.
   */
  public static class ListWebAnalyticEventTypesQueryParams extends HashMap<String, Object> {
    public ListWebAnalyticEventTypesQueryParams fields(final String value) {
      put("fields", EncodingUtils.encode(value));
      return this;
    }
    public ListWebAnalyticEventTypesQueryParams limit(final Integer value) {
      put("limit", EncodingUtils.encode(value));
      return this;
    }
    public ListWebAnalyticEventTypesQueryParams before(final String value) {
      put("before", EncodingUtils.encode(value));
      return this;
    }
    public ListWebAnalyticEventTypesQueryParams after(final String value) {
      put("after", EncodingUtils.encode(value));
      return this;
    }
    public ListWebAnalyticEventTypesQueryParams include(final String value) {
      put("include", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * Update a web analytic event type
   * Update a web analytic event type.
   * @param id  (required)
   * @param body JsonPatch with array of operations (optional)
   * JsonPatch RFC
   * @see <a href="https://tools.ietf.org/html/rfc6902">Update a web analytic event type Documentation</a>
   */
  @RequestLine("PATCH /v1/analytics/webAnalyticEvent/{id}")
  @Headers({
      "Content-Type: application/json-patch+json",
      "Accept: application/json",
  })
  void patchWebAnalyticEventTypeById(@Param("id") UUID id, Object body);
  /**
   * Restore a soft deleted WebAnalyticEvent.
   * Restore a soft deleted WebAnalyticEvent.
   * @param body  (optional)
   * @return WebAnalyticEvent
   */
  @RequestLine("PUT /v1/analytics/webAnalyticEvent/restore")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  WebAnalyticEvent restore(RestoreEntity body);
}
