/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata system. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.    Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`. Resource URI for an entity    instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  Data Asset APIs - These API endpoints support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  Service APIs - These API endpoints support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes transactional databases - MySQL, Postgres, MSSQL, Oracle, and data warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to dashboard services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messaingService` - APIs related to messaging services. This includes Apache Kafka and Apache Pulsar (work in progress).  Teams & Users APIs - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  Search & Suggest APIs - These API endpoints support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  Other APIs - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities  ## Implementation Notes  We use the [Dropwizard](https://www.dropwizard.io/en/latest/) Java framework for developing Restful web services.  APIs are documented using [Swagger/OpenAPI 3.x](https://swagger.io/specification/). We take schema first approach and define metadata entities and types in [JSON schema](https://json-schema.org/)  specification version [Draft-07 to 2019-09](https://json-schema.org/draft/2019-09/release-notes.html). Java code is  generated from the JSON schema using [JSON schema 2 pojo](https://www.jsonschema2pojo.org/) tool and Python code is  generated using the [Data model code generator](https://github.com/koxudaxi/datamodel-code-generator) tool.
 *
 * OpenAPI spec version: 0.13.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import org.threeten.bp.OffsetDateTime;
/**
 * AirflowConfig
 */

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")
public class AirflowConfig {
  @JsonProperty("concurrency")
  private Integer concurrency = null;

  @JsonProperty("email")
  private String email = null;

  @JsonProperty("endDate")
  private OffsetDateTime endDate = null;

  @JsonProperty("maxActiveRuns")
  private Integer maxActiveRuns = null;

  @JsonProperty("pausePipeline")
  private Boolean pausePipeline = null;

  @JsonProperty("pipelineCatchup")
  private Boolean pipelineCatchup = null;

  @JsonProperty("pipelineTimezone")
  private String pipelineTimezone = null;

  @JsonProperty("retries")
  private Integer retries = null;

  @JsonProperty("retryDelay")
  private Integer retryDelay = null;

  @JsonProperty("scheduleInterval")
  private String scheduleInterval = null;

  @JsonProperty("startDate")
  private OffsetDateTime startDate = null;

  @JsonProperty("workflowDefaultView")
  private String workflowDefaultView = null;

  @JsonProperty("workflowDefaultViewOrientation")
  private String workflowDefaultViewOrientation = null;

  @JsonProperty("workflowTimeout")
  private Integer workflowTimeout = null;

  public AirflowConfig concurrency(Integer concurrency) {
    this.concurrency = concurrency;
    return this;
  }

   /**
   * Get concurrency
   * @return concurrency
  **/
  @Schema(description = "")
  public Integer getConcurrency() {
    return concurrency;
  }

  public void setConcurrency(Integer concurrency) {
    this.concurrency = concurrency;
  }

  public AirflowConfig email(String email) {
    this.email = email;
    return this;
  }

   /**
   * Get email
   * @return email
  **/
  @Schema(description = "")
  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  public AirflowConfig endDate(OffsetDateTime endDate) {
    this.endDate = endDate;
    return this;
  }

   /**
   * Get endDate
   * @return endDate
  **/
  @Schema(description = "")
  public OffsetDateTime getEndDate() {
    return endDate;
  }

  public void setEndDate(OffsetDateTime endDate) {
    this.endDate = endDate;
  }

  public AirflowConfig maxActiveRuns(Integer maxActiveRuns) {
    this.maxActiveRuns = maxActiveRuns;
    return this;
  }

   /**
   * Get maxActiveRuns
   * @return maxActiveRuns
  **/
  @Schema(description = "")
  public Integer getMaxActiveRuns() {
    return maxActiveRuns;
  }

  public void setMaxActiveRuns(Integer maxActiveRuns) {
    this.maxActiveRuns = maxActiveRuns;
  }

  public AirflowConfig pausePipeline(Boolean pausePipeline) {
    this.pausePipeline = pausePipeline;
    return this;
  }

   /**
   * Get pausePipeline
   * @return pausePipeline
  **/
  @Schema(description = "")
  public Boolean isPausePipeline() {
    return pausePipeline;
  }

  public void setPausePipeline(Boolean pausePipeline) {
    this.pausePipeline = pausePipeline;
  }

  public AirflowConfig pipelineCatchup(Boolean pipelineCatchup) {
    this.pipelineCatchup = pipelineCatchup;
    return this;
  }

   /**
   * Get pipelineCatchup
   * @return pipelineCatchup
  **/
  @Schema(description = "")
  public Boolean isPipelineCatchup() {
    return pipelineCatchup;
  }

  public void setPipelineCatchup(Boolean pipelineCatchup) {
    this.pipelineCatchup = pipelineCatchup;
  }

  public AirflowConfig pipelineTimezone(String pipelineTimezone) {
    this.pipelineTimezone = pipelineTimezone;
    return this;
  }

   /**
   * Get pipelineTimezone
   * @return pipelineTimezone
  **/
  @Schema(description = "")
  public String getPipelineTimezone() {
    return pipelineTimezone;
  }

  public void setPipelineTimezone(String pipelineTimezone) {
    this.pipelineTimezone = pipelineTimezone;
  }

  public AirflowConfig retries(Integer retries) {
    this.retries = retries;
    return this;
  }

   /**
   * Get retries
   * @return retries
  **/
  @Schema(description = "")
  public Integer getRetries() {
    return retries;
  }

  public void setRetries(Integer retries) {
    this.retries = retries;
  }

  public AirflowConfig retryDelay(Integer retryDelay) {
    this.retryDelay = retryDelay;
    return this;
  }

   /**
   * Get retryDelay
   * @return retryDelay
  **/
  @Schema(description = "")
  public Integer getRetryDelay() {
    return retryDelay;
  }

  public void setRetryDelay(Integer retryDelay) {
    this.retryDelay = retryDelay;
  }

  public AirflowConfig scheduleInterval(String scheduleInterval) {
    this.scheduleInterval = scheduleInterval;
    return this;
  }

   /**
   * Get scheduleInterval
   * @return scheduleInterval
  **/
  @Schema(description = "")
  public String getScheduleInterval() {
    return scheduleInterval;
  }

  public void setScheduleInterval(String scheduleInterval) {
    this.scheduleInterval = scheduleInterval;
  }

  public AirflowConfig startDate(OffsetDateTime startDate) {
    this.startDate = startDate;
    return this;
  }

   /**
   * Get startDate
   * @return startDate
  **/
  @Schema(description = "")
  public OffsetDateTime getStartDate() {
    return startDate;
  }

  public void setStartDate(OffsetDateTime startDate) {
    this.startDate = startDate;
  }

  public AirflowConfig workflowDefaultView(String workflowDefaultView) {
    this.workflowDefaultView = workflowDefaultView;
    return this;
  }

   /**
   * Get workflowDefaultView
   * @return workflowDefaultView
  **/
  @Schema(description = "")
  public String getWorkflowDefaultView() {
    return workflowDefaultView;
  }

  public void setWorkflowDefaultView(String workflowDefaultView) {
    this.workflowDefaultView = workflowDefaultView;
  }

  public AirflowConfig workflowDefaultViewOrientation(String workflowDefaultViewOrientation) {
    this.workflowDefaultViewOrientation = workflowDefaultViewOrientation;
    return this;
  }

   /**
   * Get workflowDefaultViewOrientation
   * @return workflowDefaultViewOrientation
  **/
  @Schema(description = "")
  public String getWorkflowDefaultViewOrientation() {
    return workflowDefaultViewOrientation;
  }

  public void setWorkflowDefaultViewOrientation(String workflowDefaultViewOrientation) {
    this.workflowDefaultViewOrientation = workflowDefaultViewOrientation;
  }

  public AirflowConfig workflowTimeout(Integer workflowTimeout) {
    this.workflowTimeout = workflowTimeout;
    return this;
  }

   /**
   * Get workflowTimeout
   * @return workflowTimeout
  **/
  @Schema(description = "")
  public Integer getWorkflowTimeout() {
    return workflowTimeout;
  }

  public void setWorkflowTimeout(Integer workflowTimeout) {
    this.workflowTimeout = workflowTimeout;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AirflowConfig airflowConfig = (AirflowConfig) o;
    return Objects.equals(this.concurrency, airflowConfig.concurrency) &&
        Objects.equals(this.email, airflowConfig.email) &&
        Objects.equals(this.endDate, airflowConfig.endDate) &&
        Objects.equals(this.maxActiveRuns, airflowConfig.maxActiveRuns) &&
        Objects.equals(this.pausePipeline, airflowConfig.pausePipeline) &&
        Objects.equals(this.pipelineCatchup, airflowConfig.pipelineCatchup) &&
        Objects.equals(this.pipelineTimezone, airflowConfig.pipelineTimezone) &&
        Objects.equals(this.retries, airflowConfig.retries) &&
        Objects.equals(this.retryDelay, airflowConfig.retryDelay) &&
        Objects.equals(this.scheduleInterval, airflowConfig.scheduleInterval) &&
        Objects.equals(this.startDate, airflowConfig.startDate) &&
        Objects.equals(this.workflowDefaultView, airflowConfig.workflowDefaultView) &&
        Objects.equals(this.workflowDefaultViewOrientation, airflowConfig.workflowDefaultViewOrientation) &&
        Objects.equals(this.workflowTimeout, airflowConfig.workflowTimeout);
  }

  @Override
  public int hashCode() {
    return Objects.hash(concurrency, email, endDate, maxActiveRuns, pausePipeline, pipelineCatchup, pipelineTimezone, retries, retryDelay, scheduleInterval, startDate, workflowDefaultView, workflowDefaultViewOrientation, workflowTimeout);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AirflowConfig {\n");
    
    sb.append("    concurrency: ").append(toIndentedString(concurrency)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    maxActiveRuns: ").append(toIndentedString(maxActiveRuns)).append("\n");
    sb.append("    pausePipeline: ").append(toIndentedString(pausePipeline)).append("\n");
    sb.append("    pipelineCatchup: ").append(toIndentedString(pipelineCatchup)).append("\n");
    sb.append("    pipelineTimezone: ").append(toIndentedString(pipelineTimezone)).append("\n");
    sb.append("    retries: ").append(toIndentedString(retries)).append("\n");
    sb.append("    retryDelay: ").append(toIndentedString(retryDelay)).append("\n");
    sb.append("    scheduleInterval: ").append(toIndentedString(scheduleInterval)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    workflowDefaultView: ").append(toIndentedString(workflowDefaultView)).append("\n");
    sb.append("    workflowDefaultViewOrientation: ").append(toIndentedString(workflowDefaultViewOrientation)).append("\n");
    sb.append("    workflowTimeout: ").append(toIndentedString(workflowTimeout)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
