/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata system. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.    Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`. Resource URI for an entity    instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  Data Asset APIs - These API endpoints support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  Service APIs - These API endpoints support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes transactional databases - MySQL, Postgres, MSSQL, Oracle, and data warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to dashboard services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messaingService` - APIs related to messaging services. This includes Apache Kafka and Apache Pulsar (work in progress).  Teams & Users APIs - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  Search & Suggest APIs - These API endpoints support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  Other APIs - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities  ## Implementation Notes  We use the [Dropwizard](https://www.dropwizard.io/en/latest/) Java framework for developing Restful web services.  APIs are documented using [Swagger/OpenAPI 3.x](https://swagger.io/specification/). We take schema first approach and define metadata entities and types in [JSON schema](https://json-schema.org/)  specification version [Draft-07 to 2019-09](https://json-schema.org/draft/2019-09/release-notes.html). Java code is  generated from the JSON schema using [JSON schema 2 pojo](https://www.jsonschema2pojo.org/) tool and Python code is  generated using the [Data model code generator](https://github.com/koxudaxi/datamodel-code-generator) tool.
 *
 * OpenAPI spec version: 0.13.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.openmetadata.client.model.AlertActionStatus;
import org.openmetadata.client.model.ChangeDescription;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.TagLabel;
/**
 * AlertAction
 */

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")
public class AlertAction {
  @JsonProperty("alertActionConfig")
  private Object alertActionConfig = null;

  /**
   * Gets or Sets alertActionType
   */
  public enum AlertActionTypeEnum {
    GENERICWEBHOOK("GenericWebhook"),
    SLACKWEBHOOK("SlackWebhook"),
    MSTEAMSWEBHOOK("MsTeamsWebhook"),
    EMAIL("Email"),
    ACTIVITYFEED("ActivityFeed");

    private String value;

    AlertActionTypeEnum(String value) {
      this.value = value;
    }
    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    @JsonCreator
    public static AlertActionTypeEnum fromValue(String text) {
      for (AlertActionTypeEnum b : AlertActionTypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

  }  @JsonProperty("alertActionType")
  private AlertActionTypeEnum alertActionType = null;

  @JsonProperty("batchSize")
  private Integer batchSize = null;

  @JsonProperty("changeDescription")
  private ChangeDescription changeDescription = null;

  @JsonProperty("deleted")
  private Boolean deleted = null;

  @JsonProperty("description")
  private String description = null;

  @JsonProperty("displayName")
  private String displayName = null;

  @JsonProperty("enabled")
  private Boolean enabled = null;

  @JsonProperty("extension")
  private Object extension = null;

  @JsonProperty("followers")
  private List<EntityReference> followers = null;

  @JsonProperty("fullyQualifiedName")
  private String fullyQualifiedName = null;

  @JsonProperty("href")
  private String href = null;

  @JsonProperty("id")
  private UUID id = null;

  @JsonProperty("name")
  private String name = null;

  @JsonProperty("owner")
  private EntityReference owner = null;

  /**
   * Gets or Sets provider
   */
  public enum ProviderEnum {
    SYSTEM("system"),
    USER("user");

    private String value;

    ProviderEnum(String value) {
      this.value = value;
    }
    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    @JsonCreator
    public static ProviderEnum fromValue(String text) {
      for (ProviderEnum b : ProviderEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

  }  @JsonProperty("provider")
  private ProviderEnum provider = null;

  @JsonProperty("readTimeout")
  private Integer readTimeout = null;

  @JsonProperty("statusDetails")
  private AlertActionStatus statusDetails = null;

  @JsonProperty("tags")
  private List<TagLabel> tags = null;

  @JsonProperty("timeout")
  private Integer timeout = null;

  @JsonProperty("updatedAt")
  private Long updatedAt = null;

  @JsonProperty("updatedBy")
  private String updatedBy = null;

  @JsonProperty("version")
  private Double version = null;

  public AlertAction alertActionConfig(Object alertActionConfig) {
    this.alertActionConfig = alertActionConfig;
    return this;
  }

   /**
   * Get alertActionConfig
   * @return alertActionConfig
  **/
  @Schema(required = true, description = "")
  public Object getAlertActionConfig() {
    return alertActionConfig;
  }

  public void setAlertActionConfig(Object alertActionConfig) {
    this.alertActionConfig = alertActionConfig;
  }

  public AlertAction alertActionType(AlertActionTypeEnum alertActionType) {
    this.alertActionType = alertActionType;
    return this;
  }

   /**
   * Get alertActionType
   * @return alertActionType
  **/
  @Schema(required = true, description = "")
  public AlertActionTypeEnum getAlertActionType() {
    return alertActionType;
  }

  public void setAlertActionType(AlertActionTypeEnum alertActionType) {
    this.alertActionType = alertActionType;
  }

  public AlertAction batchSize(Integer batchSize) {
    this.batchSize = batchSize;
    return this;
  }

   /**
   * Get batchSize
   * @return batchSize
  **/
  @Schema(description = "")
  public Integer getBatchSize() {
    return batchSize;
  }

  public void setBatchSize(Integer batchSize) {
    this.batchSize = batchSize;
  }

  public AlertAction changeDescription(ChangeDescription changeDescription) {
    this.changeDescription = changeDescription;
    return this;
  }

   /**
   * Get changeDescription
   * @return changeDescription
  **/
  @Schema(description = "")
  public ChangeDescription getChangeDescription() {
    return changeDescription;
  }

  public void setChangeDescription(ChangeDescription changeDescription) {
    this.changeDescription = changeDescription;
  }

  public AlertAction deleted(Boolean deleted) {
    this.deleted = deleted;
    return this;
  }

   /**
   * Get deleted
   * @return deleted
  **/
  @Schema(description = "")
  public Boolean isDeleted() {
    return deleted;
  }

  public void setDeleted(Boolean deleted) {
    this.deleted = deleted;
  }

  public AlertAction description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @Schema(description = "")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public AlertAction displayName(String displayName) {
    this.displayName = displayName;
    return this;
  }

   /**
   * Get displayName
   * @return displayName
  **/
  @Schema(description = "")
  public String getDisplayName() {
    return displayName;
  }

  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }

  public AlertAction enabled(Boolean enabled) {
    this.enabled = enabled;
    return this;
  }

   /**
   * Get enabled
   * @return enabled
  **/
  @Schema(description = "")
  public Boolean isEnabled() {
    return enabled;
  }

  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }

  public AlertAction extension(Object extension) {
    this.extension = extension;
    return this;
  }

   /**
   * Get extension
   * @return extension
  **/
  @Schema(description = "")
  public Object getExtension() {
    return extension;
  }

  public void setExtension(Object extension) {
    this.extension = extension;
  }

  public AlertAction followers(List<EntityReference> followers) {
    this.followers = followers;
    return this;
  }

  public AlertAction addFollowersItem(EntityReference followersItem) {
    if (this.followers == null) {
      this.followers = new ArrayList<EntityReference>();
    }
    this.followers.add(followersItem);
    return this;
  }

   /**
   * Get followers
   * @return followers
  **/
  @Schema(description = "")
  public List<EntityReference> getFollowers() {
    return followers;
  }

  public void setFollowers(List<EntityReference> followers) {
    this.followers = followers;
  }

  public AlertAction fullyQualifiedName(String fullyQualifiedName) {
    this.fullyQualifiedName = fullyQualifiedName;
    return this;
  }

   /**
   * Get fullyQualifiedName
   * @return fullyQualifiedName
  **/
  @Schema(description = "")
  public String getFullyQualifiedName() {
    return fullyQualifiedName;
  }

  public void setFullyQualifiedName(String fullyQualifiedName) {
    this.fullyQualifiedName = fullyQualifiedName;
  }

  public AlertAction href(String href) {
    this.href = href;
    return this;
  }

   /**
   * Get href
   * @return href
  **/
  @Schema(description = "")
  public String getHref() {
    return href;
  }

  public void setHref(String href) {
    this.href = href;
  }

  public AlertAction id(UUID id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @Schema(description = "")
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public AlertAction name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @Schema(required = true, description = "")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public AlertAction owner(EntityReference owner) {
    this.owner = owner;
    return this;
  }

   /**
   * Get owner
   * @return owner
  **/
  @Schema(description = "")
  public EntityReference getOwner() {
    return owner;
  }

  public void setOwner(EntityReference owner) {
    this.owner = owner;
  }

  public AlertAction provider(ProviderEnum provider) {
    this.provider = provider;
    return this;
  }

   /**
   * Get provider
   * @return provider
  **/
  @Schema(description = "")
  public ProviderEnum getProvider() {
    return provider;
  }

  public void setProvider(ProviderEnum provider) {
    this.provider = provider;
  }

  public AlertAction readTimeout(Integer readTimeout) {
    this.readTimeout = readTimeout;
    return this;
  }

   /**
   * Get readTimeout
   * @return readTimeout
  **/
  @Schema(description = "")
  public Integer getReadTimeout() {
    return readTimeout;
  }

  public void setReadTimeout(Integer readTimeout) {
    this.readTimeout = readTimeout;
  }

  public AlertAction statusDetails(AlertActionStatus statusDetails) {
    this.statusDetails = statusDetails;
    return this;
  }

   /**
   * Get statusDetails
   * @return statusDetails
  **/
  @Schema(description = "")
  public AlertActionStatus getStatusDetails() {
    return statusDetails;
  }

  public void setStatusDetails(AlertActionStatus statusDetails) {
    this.statusDetails = statusDetails;
  }

  public AlertAction tags(List<TagLabel> tags) {
    this.tags = tags;
    return this;
  }

  public AlertAction addTagsItem(TagLabel tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<TagLabel>();
    }
    this.tags.add(tagsItem);
    return this;
  }

   /**
   * Get tags
   * @return tags
  **/
  @Schema(description = "")
  public List<TagLabel> getTags() {
    return tags;
  }

  public void setTags(List<TagLabel> tags) {
    this.tags = tags;
  }

  public AlertAction timeout(Integer timeout) {
    this.timeout = timeout;
    return this;
  }

   /**
   * Get timeout
   * @return timeout
  **/
  @Schema(description = "")
  public Integer getTimeout() {
    return timeout;
  }

  public void setTimeout(Integer timeout) {
    this.timeout = timeout;
  }

  public AlertAction updatedAt(Long updatedAt) {
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * Get updatedAt
   * @return updatedAt
  **/
  @Schema(description = "")
  public Long getUpdatedAt() {
    return updatedAt;
  }

  public void setUpdatedAt(Long updatedAt) {
    this.updatedAt = updatedAt;
  }

  public AlertAction updatedBy(String updatedBy) {
    this.updatedBy = updatedBy;
    return this;
  }

   /**
   * Get updatedBy
   * @return updatedBy
  **/
  @Schema(description = "")
  public String getUpdatedBy() {
    return updatedBy;
  }

  public void setUpdatedBy(String updatedBy) {
    this.updatedBy = updatedBy;
  }

  public AlertAction version(Double version) {
    this.version = version;
    return this;
  }

   /**
   * Get version
   * @return version
  **/
  @Schema(description = "")
  public Double getVersion() {
    return version;
  }

  public void setVersion(Double version) {
    this.version = version;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AlertAction alertAction = (AlertAction) o;
    return Objects.equals(this.alertActionConfig, alertAction.alertActionConfig) &&
        Objects.equals(this.alertActionType, alertAction.alertActionType) &&
        Objects.equals(this.batchSize, alertAction.batchSize) &&
        Objects.equals(this.changeDescription, alertAction.changeDescription) &&
        Objects.equals(this.deleted, alertAction.deleted) &&
        Objects.equals(this.description, alertAction.description) &&
        Objects.equals(this.displayName, alertAction.displayName) &&
        Objects.equals(this.enabled, alertAction.enabled) &&
        Objects.equals(this.extension, alertAction.extension) &&
        Objects.equals(this.followers, alertAction.followers) &&
        Objects.equals(this.fullyQualifiedName, alertAction.fullyQualifiedName) &&
        Objects.equals(this.href, alertAction.href) &&
        Objects.equals(this.id, alertAction.id) &&
        Objects.equals(this.name, alertAction.name) &&
        Objects.equals(this.owner, alertAction.owner) &&
        Objects.equals(this.provider, alertAction.provider) &&
        Objects.equals(this.readTimeout, alertAction.readTimeout) &&
        Objects.equals(this.statusDetails, alertAction.statusDetails) &&
        Objects.equals(this.tags, alertAction.tags) &&
        Objects.equals(this.timeout, alertAction.timeout) &&
        Objects.equals(this.updatedAt, alertAction.updatedAt) &&
        Objects.equals(this.updatedBy, alertAction.updatedBy) &&
        Objects.equals(this.version, alertAction.version);
  }

  @Override
  public int hashCode() {
    return Objects.hash(alertActionConfig, alertActionType, batchSize, changeDescription, deleted, description, displayName, enabled, extension, followers, fullyQualifiedName, href, id, name, owner, provider, readTimeout, statusDetails, tags, timeout, updatedAt, updatedBy, version);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AlertAction {\n");
    
    sb.append("    alertActionConfig: ").append(toIndentedString(alertActionConfig)).append("\n");
    sb.append("    alertActionType: ").append(toIndentedString(alertActionType)).append("\n");
    sb.append("    batchSize: ").append(toIndentedString(batchSize)).append("\n");
    sb.append("    changeDescription: ").append(toIndentedString(changeDescription)).append("\n");
    sb.append("    deleted: ").append(toIndentedString(deleted)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    extension: ").append(toIndentedString(extension)).append("\n");
    sb.append("    followers: ").append(toIndentedString(followers)).append("\n");
    sb.append("    fullyQualifiedName: ").append(toIndentedString(fullyQualifiedName)).append("\n");
    sb.append("    href: ").append(toIndentedString(href)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    provider: ").append(toIndentedString(provider)).append("\n");
    sb.append("    readTimeout: ").append(toIndentedString(readTimeout)).append("\n");
    sb.append("    statusDetails: ").append(toIndentedString(statusDetails)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    timeout: ").append(toIndentedString(timeout)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    updatedBy: ").append(toIndentedString(updatedBy)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
