/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata system. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.    Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`. Resource URI for an entity    instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  Data Asset APIs - These API endpoints support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  Service APIs - These API endpoints support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes transactional databases - MySQL, Postgres, MSSQL, Oracle, and data warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to dashboard services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messaingService` - APIs related to messaging services. This includes Apache Kafka and Apache Pulsar (work in progress).  Teams & Users APIs - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  Search & Suggest APIs - These API endpoints support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  Other APIs - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities  ## Implementation Notes  We use the [Dropwizard](https://www.dropwizard.io/en/latest/) Java framework for developing Restful web services.  APIs are documented using [Swagger/OpenAPI 3.x](https://swagger.io/specification/). We take schema first approach and define metadata entities and types in [JSON schema](https://json-schema.org/)  specification version [Draft-07 to 2019-09](https://json-schema.org/draft/2019-09/release-notes.html). Java code is  generated from the JSON schema using [JSON schema 2 pojo](https://www.jsonschema2pojo.org/) tool and Python code is  generated using the [Data model code generator](https://github.com/koxudaxi/datamodel-code-generator) tool.
 *
 * OpenAPI spec version: 0.13.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import org.openmetadata.client.model.LdapConfiguration;
/**
 * AuthenticationConfiguration
 */

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")
public class AuthenticationConfiguration {
  @JsonProperty("authority")
  private String authority = null;

  @JsonProperty("callbackUrl")
  private String callbackUrl = null;

  @JsonProperty("clientId")
  private String clientId = null;

  @JsonProperty("enableSelfSignup")
  private Boolean enableSelfSignup = null;

  @JsonProperty("jwtPrincipalClaims")
  private List<String> jwtPrincipalClaims = new ArrayList<String>();

  @JsonProperty("ldapConfiguration")
  private LdapConfiguration ldapConfiguration = null;

  @JsonProperty("provider")
  private String provider = null;

  @JsonProperty("providerName")
  private String providerName = null;

  @JsonProperty("publicKeyUrls")
  private List<String> publicKeyUrls = new ArrayList<String>();

  public AuthenticationConfiguration authority(String authority) {
    this.authority = authority;
    return this;
  }

   /**
   * Get authority
   * @return authority
  **/
  @Schema(required = true, description = "")
  public String getAuthority() {
    return authority;
  }

  public void setAuthority(String authority) {
    this.authority = authority;
  }

  public AuthenticationConfiguration callbackUrl(String callbackUrl) {
    this.callbackUrl = callbackUrl;
    return this;
  }

   /**
   * Get callbackUrl
   * @return callbackUrl
  **/
  @Schema(required = true, description = "")
  public String getCallbackUrl() {
    return callbackUrl;
  }

  public void setCallbackUrl(String callbackUrl) {
    this.callbackUrl = callbackUrl;
  }

  public AuthenticationConfiguration clientId(String clientId) {
    this.clientId = clientId;
    return this;
  }

   /**
   * Get clientId
   * @return clientId
  **/
  @Schema(required = true, description = "")
  public String getClientId() {
    return clientId;
  }

  public void setClientId(String clientId) {
    this.clientId = clientId;
  }

  public AuthenticationConfiguration enableSelfSignup(Boolean enableSelfSignup) {
    this.enableSelfSignup = enableSelfSignup;
    return this;
  }

   /**
   * Get enableSelfSignup
   * @return enableSelfSignup
  **/
  @Schema(description = "")
  public Boolean isEnableSelfSignup() {
    return enableSelfSignup;
  }

  public void setEnableSelfSignup(Boolean enableSelfSignup) {
    this.enableSelfSignup = enableSelfSignup;
  }

  public AuthenticationConfiguration jwtPrincipalClaims(List<String> jwtPrincipalClaims) {
    this.jwtPrincipalClaims = jwtPrincipalClaims;
    return this;
  }

  public AuthenticationConfiguration addJwtPrincipalClaimsItem(String jwtPrincipalClaimsItem) {
    this.jwtPrincipalClaims.add(jwtPrincipalClaimsItem);
    return this;
  }

   /**
   * Get jwtPrincipalClaims
   * @return jwtPrincipalClaims
  **/
  @Schema(required = true, description = "")
  public List<String> getJwtPrincipalClaims() {
    return jwtPrincipalClaims;
  }

  public void setJwtPrincipalClaims(List<String> jwtPrincipalClaims) {
    this.jwtPrincipalClaims = jwtPrincipalClaims;
  }

  public AuthenticationConfiguration ldapConfiguration(LdapConfiguration ldapConfiguration) {
    this.ldapConfiguration = ldapConfiguration;
    return this;
  }

   /**
   * Get ldapConfiguration
   * @return ldapConfiguration
  **/
  @Schema(description = "")
  public LdapConfiguration getLdapConfiguration() {
    return ldapConfiguration;
  }

  public void setLdapConfiguration(LdapConfiguration ldapConfiguration) {
    this.ldapConfiguration = ldapConfiguration;
  }

  public AuthenticationConfiguration provider(String provider) {
    this.provider = provider;
    return this;
  }

   /**
   * Get provider
   * @return provider
  **/
  @Schema(required = true, description = "")
  public String getProvider() {
    return provider;
  }

  public void setProvider(String provider) {
    this.provider = provider;
  }

  public AuthenticationConfiguration providerName(String providerName) {
    this.providerName = providerName;
    return this;
  }

   /**
   * Get providerName
   * @return providerName
  **/
  @Schema(required = true, description = "")
  public String getProviderName() {
    return providerName;
  }

  public void setProviderName(String providerName) {
    this.providerName = providerName;
  }

  public AuthenticationConfiguration publicKeyUrls(List<String> publicKeyUrls) {
    this.publicKeyUrls = publicKeyUrls;
    return this;
  }

  public AuthenticationConfiguration addPublicKeyUrlsItem(String publicKeyUrlsItem) {
    this.publicKeyUrls.add(publicKeyUrlsItem);
    return this;
  }

   /**
   * Get publicKeyUrls
   * @return publicKeyUrls
  **/
  @Schema(required = true, description = "")
  public List<String> getPublicKeyUrls() {
    return publicKeyUrls;
  }

  public void setPublicKeyUrls(List<String> publicKeyUrls) {
    this.publicKeyUrls = publicKeyUrls;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AuthenticationConfiguration authenticationConfiguration = (AuthenticationConfiguration) o;
    return Objects.equals(this.authority, authenticationConfiguration.authority) &&
        Objects.equals(this.callbackUrl, authenticationConfiguration.callbackUrl) &&
        Objects.equals(this.clientId, authenticationConfiguration.clientId) &&
        Objects.equals(this.enableSelfSignup, authenticationConfiguration.enableSelfSignup) &&
        Objects.equals(this.jwtPrincipalClaims, authenticationConfiguration.jwtPrincipalClaims) &&
        Objects.equals(this.ldapConfiguration, authenticationConfiguration.ldapConfiguration) &&
        Objects.equals(this.provider, authenticationConfiguration.provider) &&
        Objects.equals(this.providerName, authenticationConfiguration.providerName) &&
        Objects.equals(this.publicKeyUrls, authenticationConfiguration.publicKeyUrls);
  }

  @Override
  public int hashCode() {
    return Objects.hash(authority, callbackUrl, clientId, enableSelfSignup, jwtPrincipalClaims, ldapConfiguration, provider, providerName, publicKeyUrls);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AuthenticationConfiguration {\n");
    
    sb.append("    authority: ").append(toIndentedString(authority)).append("\n");
    sb.append("    callbackUrl: ").append(toIndentedString(callbackUrl)).append("\n");
    sb.append("    clientId: ").append(toIndentedString(clientId)).append("\n");
    sb.append("    enableSelfSignup: ").append(toIndentedString(enableSelfSignup)).append("\n");
    sb.append("    jwtPrincipalClaims: ").append(toIndentedString(jwtPrincipalClaims)).append("\n");
    sb.append("    ldapConfiguration: ").append(toIndentedString(ldapConfiguration)).append("\n");
    sb.append("    provider: ").append(toIndentedString(provider)).append("\n");
    sb.append("    providerName: ").append(toIndentedString(providerName)).append("\n");
    sb.append("    publicKeyUrls: ").append(toIndentedString(publicKeyUrls)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
