/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata system. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.    Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`. Resource URI for an entity    instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  Data Asset APIs - These API endpoints support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  Service APIs - These API endpoints support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes transactional databases - MySQL, Postgres, MSSQL, Oracle, and data warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to dashboard services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messaingService` - APIs related to messaging services. This includes Apache Kafka and Apache Pulsar (work in progress).  Teams & Users APIs - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  Search & Suggest APIs - These API endpoints support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  Other APIs - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities  ## Implementation Notes  We use the [Dropwizard](https://www.dropwizard.io/en/latest/) Java framework for developing Restful web services.  APIs are documented using [Swagger/OpenAPI 3.x](https://swagger.io/specification/). We take schema first approach and define metadata entities and types in [JSON schema](https://json-schema.org/)  specification version [Draft-07 to 2019-09](https://json-schema.org/draft/2019-09/release-notes.html). Java code is  generated from the JSON schema using [JSON schema 2 pojo](https://www.jsonschema2pojo.org/) tool and Python code is  generated using the [Data model code generator](https://github.com/koxudaxi/datamodel-code-generator) tool.
 *
 * OpenAPI spec version: 0.13.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
/**
 * AuthorizerConfiguration
 */

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")
public class AuthorizerConfiguration {
  @JsonProperty("adminPrincipals")
  private List<String> adminPrincipals = new ArrayList<String>();

  @JsonProperty("allowedEmailRegistrationDomains")
  private List<String> allowedEmailRegistrationDomains = null;

  @JsonProperty("botPrincipals")
  private List<String> botPrincipals = null;

  @JsonProperty("className")
  private String className = null;

  @JsonProperty("containerRequestFilter")
  private String containerRequestFilter = null;

  @JsonProperty("enableSecureSocketConnection")
  private Boolean enableSecureSocketConnection = null;

  @JsonProperty("enforcePrincipalDomain")
  private Boolean enforcePrincipalDomain = null;

  @JsonProperty("principalDomain")
  private String principalDomain = null;

  @JsonProperty("testPrincipals")
  private List<String> testPrincipals = null;

  public AuthorizerConfiguration adminPrincipals(List<String> adminPrincipals) {
    this.adminPrincipals = adminPrincipals;
    return this;
  }

  public AuthorizerConfiguration addAdminPrincipalsItem(String adminPrincipalsItem) {
    this.adminPrincipals.add(adminPrincipalsItem);
    return this;
  }

   /**
   * Get adminPrincipals
   * @return adminPrincipals
  **/
  @Schema(required = true, description = "")
  public List<String> getAdminPrincipals() {
    return adminPrincipals;
  }

  public void setAdminPrincipals(List<String> adminPrincipals) {
    this.adminPrincipals = adminPrincipals;
  }

  public AuthorizerConfiguration allowedEmailRegistrationDomains(List<String> allowedEmailRegistrationDomains) {
    this.allowedEmailRegistrationDomains = allowedEmailRegistrationDomains;
    return this;
  }

  public AuthorizerConfiguration addAllowedEmailRegistrationDomainsItem(String allowedEmailRegistrationDomainsItem) {
    if (this.allowedEmailRegistrationDomains == null) {
      this.allowedEmailRegistrationDomains = new ArrayList<String>();
    }
    this.allowedEmailRegistrationDomains.add(allowedEmailRegistrationDomainsItem);
    return this;
  }

   /**
   * Get allowedEmailRegistrationDomains
   * @return allowedEmailRegistrationDomains
  **/
  @Schema(description = "")
  public List<String> getAllowedEmailRegistrationDomains() {
    return allowedEmailRegistrationDomains;
  }

  public void setAllowedEmailRegistrationDomains(List<String> allowedEmailRegistrationDomains) {
    this.allowedEmailRegistrationDomains = allowedEmailRegistrationDomains;
  }

  public AuthorizerConfiguration botPrincipals(List<String> botPrincipals) {
    this.botPrincipals = botPrincipals;
    return this;
  }

  public AuthorizerConfiguration addBotPrincipalsItem(String botPrincipalsItem) {
    if (this.botPrincipals == null) {
      this.botPrincipals = new ArrayList<String>();
    }
    this.botPrincipals.add(botPrincipalsItem);
    return this;
  }

   /**
   * Get botPrincipals
   * @return botPrincipals
  **/
  @Schema(description = "")
  public List<String> getBotPrincipals() {
    return botPrincipals;
  }

  public void setBotPrincipals(List<String> botPrincipals) {
    this.botPrincipals = botPrincipals;
  }

  public AuthorizerConfiguration className(String className) {
    this.className = className;
    return this;
  }

   /**
   * Get className
   * @return className
  **/
  @Schema(required = true, description = "")
  public String getClassName() {
    return className;
  }

  public void setClassName(String className) {
    this.className = className;
  }

  public AuthorizerConfiguration containerRequestFilter(String containerRequestFilter) {
    this.containerRequestFilter = containerRequestFilter;
    return this;
  }

   /**
   * Get containerRequestFilter
   * @return containerRequestFilter
  **/
  @Schema(required = true, description = "")
  public String getContainerRequestFilter() {
    return containerRequestFilter;
  }

  public void setContainerRequestFilter(String containerRequestFilter) {
    this.containerRequestFilter = containerRequestFilter;
  }

  public AuthorizerConfiguration enableSecureSocketConnection(Boolean enableSecureSocketConnection) {
    this.enableSecureSocketConnection = enableSecureSocketConnection;
    return this;
  }

   /**
   * Get enableSecureSocketConnection
   * @return enableSecureSocketConnection
  **/
  @Schema(required = true, description = "")
  public Boolean isEnableSecureSocketConnection() {
    return enableSecureSocketConnection;
  }

  public void setEnableSecureSocketConnection(Boolean enableSecureSocketConnection) {
    this.enableSecureSocketConnection = enableSecureSocketConnection;
  }

  public AuthorizerConfiguration enforcePrincipalDomain(Boolean enforcePrincipalDomain) {
    this.enforcePrincipalDomain = enforcePrincipalDomain;
    return this;
  }

   /**
   * Get enforcePrincipalDomain
   * @return enforcePrincipalDomain
  **/
  @Schema(required = true, description = "")
  public Boolean isEnforcePrincipalDomain() {
    return enforcePrincipalDomain;
  }

  public void setEnforcePrincipalDomain(Boolean enforcePrincipalDomain) {
    this.enforcePrincipalDomain = enforcePrincipalDomain;
  }

  public AuthorizerConfiguration principalDomain(String principalDomain) {
    this.principalDomain = principalDomain;
    return this;
  }

   /**
   * Get principalDomain
   * @return principalDomain
  **/
  @Schema(required = true, description = "")
  public String getPrincipalDomain() {
    return principalDomain;
  }

  public void setPrincipalDomain(String principalDomain) {
    this.principalDomain = principalDomain;
  }

  public AuthorizerConfiguration testPrincipals(List<String> testPrincipals) {
    this.testPrincipals = testPrincipals;
    return this;
  }

  public AuthorizerConfiguration addTestPrincipalsItem(String testPrincipalsItem) {
    if (this.testPrincipals == null) {
      this.testPrincipals = new ArrayList<String>();
    }
    this.testPrincipals.add(testPrincipalsItem);
    return this;
  }

   /**
   * Get testPrincipals
   * @return testPrincipals
  **/
  @Schema(description = "")
  public List<String> getTestPrincipals() {
    return testPrincipals;
  }

  public void setTestPrincipals(List<String> testPrincipals) {
    this.testPrincipals = testPrincipals;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AuthorizerConfiguration authorizerConfiguration = (AuthorizerConfiguration) o;
    return Objects.equals(this.adminPrincipals, authorizerConfiguration.adminPrincipals) &&
        Objects.equals(this.allowedEmailRegistrationDomains, authorizerConfiguration.allowedEmailRegistrationDomains) &&
        Objects.equals(this.botPrincipals, authorizerConfiguration.botPrincipals) &&
        Objects.equals(this.className, authorizerConfiguration.className) &&
        Objects.equals(this.containerRequestFilter, authorizerConfiguration.containerRequestFilter) &&
        Objects.equals(this.enableSecureSocketConnection, authorizerConfiguration.enableSecureSocketConnection) &&
        Objects.equals(this.enforcePrincipalDomain, authorizerConfiguration.enforcePrincipalDomain) &&
        Objects.equals(this.principalDomain, authorizerConfiguration.principalDomain) &&
        Objects.equals(this.testPrincipals, authorizerConfiguration.testPrincipals);
  }

  @Override
  public int hashCode() {
    return Objects.hash(adminPrincipals, allowedEmailRegistrationDomains, botPrincipals, className, containerRequestFilter, enableSecureSocketConnection, enforcePrincipalDomain, principalDomain, testPrincipals);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AuthorizerConfiguration {\n");
    
    sb.append("    adminPrincipals: ").append(toIndentedString(adminPrincipals)).append("\n");
    sb.append("    allowedEmailRegistrationDomains: ").append(toIndentedString(allowedEmailRegistrationDomains)).append("\n");
    sb.append("    botPrincipals: ").append(toIndentedString(botPrincipals)).append("\n");
    sb.append("    className: ").append(toIndentedString(className)).append("\n");
    sb.append("    containerRequestFilter: ").append(toIndentedString(containerRequestFilter)).append("\n");
    sb.append("    enableSecureSocketConnection: ").append(toIndentedString(enableSecureSocketConnection)).append("\n");
    sb.append("    enforcePrincipalDomain: ").append(toIndentedString(enforcePrincipalDomain)).append("\n");
    sb.append("    principalDomain: ").append(toIndentedString(principalDomain)).append("\n");
    sb.append("    testPrincipals: ").append(toIndentedString(testPrincipals)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
