/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata system. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.    Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`. Resource URI for an entity    instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  Data Asset APIs - These API endpoints support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  Service APIs - These API endpoints support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes transactional databases - MySQL, Postgres, MSSQL, Oracle, and data warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to dashboard services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messaingService` - APIs related to messaging services. This includes Apache Kafka and Apache Pulsar (work in progress).  Teams & Users APIs - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  Search & Suggest APIs - These API endpoints support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  Other APIs - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities  ## Implementation Notes  We use the [Dropwizard](https://www.dropwizard.io/en/latest/) Java framework for developing Restful web services.  APIs are documented using [Swagger/OpenAPI 3.x](https://swagger.io/specification/). We take schema first approach and define metadata entities and types in [JSON schema](https://json-schema.org/)  specification version [Draft-07 to 2019-09](https://json-schema.org/draft/2019-09/release-notes.html). Java code is  generated from the JSON schema using [JSON schema 2 pojo](https://www.jsonschema2pojo.org/) tool and Python code is  generated using the [Data model code generator](https://github.com/koxudaxi/datamodel-code-generator) tool.
 *
 * OpenAPI spec version: 0.13.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.UUID;
import org.openmetadata.client.model.ChangeDescription;
/**
 * ChangeEvent
 */

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")
public class ChangeEvent {
  @JsonProperty("changeDescription")
  private ChangeDescription changeDescription = null;

  @JsonProperty("currentVersion")
  private Double currentVersion = null;

  @JsonProperty("entity")
  private Object entity = null;

  @JsonProperty("entityFullyQualifiedName")
  private String entityFullyQualifiedName = null;

  @JsonProperty("entityId")
  private UUID entityId = null;

  @JsonProperty("entityType")
  private String entityType = null;

  /**
   * Gets or Sets eventType
   */
  public enum EventTypeEnum {
    ENTITYCREATED("entityCreated"),
    ENTITYUPDATED("entityUpdated"),
    ENTITYSOFTDELETED("entitySoftDeleted"),
    ENTITYDELETED("entityDeleted");

    private String value;

    EventTypeEnum(String value) {
      this.value = value;
    }
    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    @JsonCreator
    public static EventTypeEnum fromValue(String text) {
      for (EventTypeEnum b : EventTypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

  }  @JsonProperty("eventType")
  private EventTypeEnum eventType = null;

  @JsonProperty("previousVersion")
  private Double previousVersion = null;

  @JsonProperty("timestamp")
  private Long timestamp = null;

  @JsonProperty("userName")
  private String userName = null;

  public ChangeEvent changeDescription(ChangeDescription changeDescription) {
    this.changeDescription = changeDescription;
    return this;
  }

   /**
   * Get changeDescription
   * @return changeDescription
  **/
  @Schema(description = "")
  public ChangeDescription getChangeDescription() {
    return changeDescription;
  }

  public void setChangeDescription(ChangeDescription changeDescription) {
    this.changeDescription = changeDescription;
  }

  public ChangeEvent currentVersion(Double currentVersion) {
    this.currentVersion = currentVersion;
    return this;
  }

   /**
   * Get currentVersion
   * @return currentVersion
  **/
  @Schema(description = "")
  public Double getCurrentVersion() {
    return currentVersion;
  }

  public void setCurrentVersion(Double currentVersion) {
    this.currentVersion = currentVersion;
  }

  public ChangeEvent entity(Object entity) {
    this.entity = entity;
    return this;
  }

   /**
   * Get entity
   * @return entity
  **/
  @Schema(description = "")
  public Object getEntity() {
    return entity;
  }

  public void setEntity(Object entity) {
    this.entity = entity;
  }

  public ChangeEvent entityFullyQualifiedName(String entityFullyQualifiedName) {
    this.entityFullyQualifiedName = entityFullyQualifiedName;
    return this;
  }

   /**
   * Get entityFullyQualifiedName
   * @return entityFullyQualifiedName
  **/
  @Schema(description = "")
  public String getEntityFullyQualifiedName() {
    return entityFullyQualifiedName;
  }

  public void setEntityFullyQualifiedName(String entityFullyQualifiedName) {
    this.entityFullyQualifiedName = entityFullyQualifiedName;
  }

  public ChangeEvent entityId(UUID entityId) {
    this.entityId = entityId;
    return this;
  }

   /**
   * Get entityId
   * @return entityId
  **/
  @Schema(required = true, description = "")
  public UUID getEntityId() {
    return entityId;
  }

  public void setEntityId(UUID entityId) {
    this.entityId = entityId;
  }

  public ChangeEvent entityType(String entityType) {
    this.entityType = entityType;
    return this;
  }

   /**
   * Get entityType
   * @return entityType
  **/
  @Schema(required = true, description = "")
  public String getEntityType() {
    return entityType;
  }

  public void setEntityType(String entityType) {
    this.entityType = entityType;
  }

  public ChangeEvent eventType(EventTypeEnum eventType) {
    this.eventType = eventType;
    return this;
  }

   /**
   * Get eventType
   * @return eventType
  **/
  @Schema(required = true, description = "")
  public EventTypeEnum getEventType() {
    return eventType;
  }

  public void setEventType(EventTypeEnum eventType) {
    this.eventType = eventType;
  }

  public ChangeEvent previousVersion(Double previousVersion) {
    this.previousVersion = previousVersion;
    return this;
  }

   /**
   * Get previousVersion
   * @return previousVersion
  **/
  @Schema(description = "")
  public Double getPreviousVersion() {
    return previousVersion;
  }

  public void setPreviousVersion(Double previousVersion) {
    this.previousVersion = previousVersion;
  }

  public ChangeEvent timestamp(Long timestamp) {
    this.timestamp = timestamp;
    return this;
  }

   /**
   * Get timestamp
   * @return timestamp
  **/
  @Schema(required = true, description = "")
  public Long getTimestamp() {
    return timestamp;
  }

  public void setTimestamp(Long timestamp) {
    this.timestamp = timestamp;
  }

  public ChangeEvent userName(String userName) {
    this.userName = userName;
    return this;
  }

   /**
   * Get userName
   * @return userName
  **/
  @Schema(description = "")
  public String getUserName() {
    return userName;
  }

  public void setUserName(String userName) {
    this.userName = userName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ChangeEvent changeEvent = (ChangeEvent) o;
    return Objects.equals(this.changeDescription, changeEvent.changeDescription) &&
        Objects.equals(this.currentVersion, changeEvent.currentVersion) &&
        Objects.equals(this.entity, changeEvent.entity) &&
        Objects.equals(this.entityFullyQualifiedName, changeEvent.entityFullyQualifiedName) &&
        Objects.equals(this.entityId, changeEvent.entityId) &&
        Objects.equals(this.entityType, changeEvent.entityType) &&
        Objects.equals(this.eventType, changeEvent.eventType) &&
        Objects.equals(this.previousVersion, changeEvent.previousVersion) &&
        Objects.equals(this.timestamp, changeEvent.timestamp) &&
        Objects.equals(this.userName, changeEvent.userName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(changeDescription, currentVersion, entity, entityFullyQualifiedName, entityId, entityType, eventType, previousVersion, timestamp, userName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ChangeEvent {\n");
    
    sb.append("    changeDescription: ").append(toIndentedString(changeDescription)).append("\n");
    sb.append("    currentVersion: ").append(toIndentedString(currentVersion)).append("\n");
    sb.append("    entity: ").append(toIndentedString(entity)).append("\n");
    sb.append("    entityFullyQualifiedName: ").append(toIndentedString(entityFullyQualifiedName)).append("\n");
    sb.append("    entityId: ").append(toIndentedString(entityId)).append("\n");
    sb.append("    entityType: ").append(toIndentedString(entityType)).append("\n");
    sb.append("    eventType: ").append(toIndentedString(eventType)).append("\n");
    sb.append("    previousVersion: ").append(toIndentedString(previousVersion)).append("\n");
    sb.append("    timestamp: ").append(toIndentedString(timestamp)).append("\n");
    sb.append("    userName: ").append(toIndentedString(userName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
