/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata system. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.    Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`. Resource URI for an entity    instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  Data Asset APIs - These API endpoints support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  Service APIs - These API endpoints support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes transactional databases - MySQL, Postgres, MSSQL, Oracle, and data warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to dashboard services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messaingService` - APIs related to messaging services. This includes Apache Kafka and Apache Pulsar (work in progress).  Teams & Users APIs - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  Search & Suggest APIs - These API endpoints support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  Other APIs - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities  ## Implementation Notes  We use the [Dropwizard](https://www.dropwizard.io/en/latest/) Java framework for developing Restful web services.  APIs are documented using [Swagger/OpenAPI 3.x](https://swagger.io/specification/). We take schema first approach and define metadata entities and types in [JSON schema](https://json-schema.org/)  specification version [Draft-07 to 2019-09](https://json-schema.org/draft/2019-09/release-notes.html). Java code is  generated from the JSON schema using [JSON schema 2 pojo](https://www.jsonschema2pojo.org/) tool and Python code is  generated using the [Data model code generator](https://github.com/koxudaxi/datamodel-code-generator) tool.
 *
 * OpenAPI spec version: 0.13.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import org.openmetadata.client.model.Column;
import org.openmetadata.client.model.ColumnProfile;
import org.openmetadata.client.model.CustomMetric;
import org.openmetadata.client.model.TagLabel;
/**
 * Column
 */

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")
public class Column {
  /**
   * Gets or Sets arrayDataType
   */
  public enum ArrayDataTypeEnum {
    NUMBER("NUMBER"),
    TINYINT("TINYINT"),
    SMALLINT("SMALLINT"),
    INT("INT"),
    BIGINT("BIGINT"),
    BYTEINT("BYTEINT"),
    BYTES("BYTES"),
    FLOAT("FLOAT"),
    DOUBLE("DOUBLE"),
    DECIMAL("DECIMAL"),
    NUMERIC("NUMERIC"),
    TIMESTAMP("TIMESTAMP"),
    TIMESTAMPZ("TIMESTAMPZ"),
    TIME("TIME"),
    DATE("DATE"),
    DATETIME("DATETIME"),
    INTERVAL("INTERVAL"),
    STRING("STRING"),
    MEDIUMTEXT("MEDIUMTEXT"),
    TEXT("TEXT"),
    CHAR("CHAR"),
    LONG("LONG"),
    VARCHAR("VARCHAR"),
    BOOLEAN("BOOLEAN"),
    BINARY("BINARY"),
    VARBINARY("VARBINARY"),
    ARRAY("ARRAY"),
    BLOB("BLOB"),
    LONGBLOB("LONGBLOB"),
    MEDIUMBLOB("MEDIUMBLOB"),
    MAP("MAP"),
    STRUCT("STRUCT"),
    UNION("UNION"),
    SET("SET"),
    GEOGRAPHY("GEOGRAPHY"),
    ENUM("ENUM"),
    JSON("JSON"),
    UUID("UUID"),
    VARIANT("VARIANT"),
    GEOMETRY("GEOMETRY"),
    POINT("POINT"),
    POLYGON("POLYGON"),
    BYTEA("BYTEA"),
    AGGREGATEFUNCTION("AGGREGATEFUNCTION");

    private String value;

    ArrayDataTypeEnum(String value) {
      this.value = value;
    }
    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    @JsonCreator
    public static ArrayDataTypeEnum fromValue(String text) {
      for (ArrayDataTypeEnum b : ArrayDataTypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

  }  @JsonProperty("arrayDataType")
  private ArrayDataTypeEnum arrayDataType = null;

  @JsonProperty("children")
  private List<Column> children = null;

  /**
   * Gets or Sets constraint
   */
  public enum ConstraintEnum {
    NULL("NULL"),
    NOT_NULL("NOT_NULL"),
    UNIQUE("UNIQUE"),
    PRIMARY_KEY("PRIMARY_KEY");

    private String value;

    ConstraintEnum(String value) {
      this.value = value;
    }
    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    @JsonCreator
    public static ConstraintEnum fromValue(String text) {
      for (ConstraintEnum b : ConstraintEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

  }  @JsonProperty("constraint")
  private ConstraintEnum constraint = null;

  @JsonProperty("customMetrics")
  private List<CustomMetric> customMetrics = null;

  @JsonProperty("dataLength")
  private Integer dataLength = null;

  /**
   * Gets or Sets dataType
   */
  public enum DataTypeEnum {
    NUMBER("NUMBER"),
    TINYINT("TINYINT"),
    SMALLINT("SMALLINT"),
    INT("INT"),
    BIGINT("BIGINT"),
    BYTEINT("BYTEINT"),
    BYTES("BYTES"),
    FLOAT("FLOAT"),
    DOUBLE("DOUBLE"),
    DECIMAL("DECIMAL"),
    NUMERIC("NUMERIC"),
    TIMESTAMP("TIMESTAMP"),
    TIMESTAMPZ("TIMESTAMPZ"),
    TIME("TIME"),
    DATE("DATE"),
    DATETIME("DATETIME"),
    INTERVAL("INTERVAL"),
    STRING("STRING"),
    MEDIUMTEXT("MEDIUMTEXT"),
    TEXT("TEXT"),
    CHAR("CHAR"),
    LONG("LONG"),
    VARCHAR("VARCHAR"),
    BOOLEAN("BOOLEAN"),
    BINARY("BINARY"),
    VARBINARY("VARBINARY"),
    ARRAY("ARRAY"),
    BLOB("BLOB"),
    LONGBLOB("LONGBLOB"),
    MEDIUMBLOB("MEDIUMBLOB"),
    MAP("MAP"),
    STRUCT("STRUCT"),
    UNION("UNION"),
    SET("SET"),
    GEOGRAPHY("GEOGRAPHY"),
    ENUM("ENUM"),
    JSON("JSON"),
    UUID("UUID"),
    VARIANT("VARIANT"),
    GEOMETRY("GEOMETRY"),
    POINT("POINT"),
    POLYGON("POLYGON"),
    BYTEA("BYTEA"),
    AGGREGATEFUNCTION("AGGREGATEFUNCTION");

    private String value;

    DataTypeEnum(String value) {
      this.value = value;
    }
    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    @JsonCreator
    public static DataTypeEnum fromValue(String text) {
      for (DataTypeEnum b : DataTypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

  }  @JsonProperty("dataType")
  private DataTypeEnum dataType = null;

  @JsonProperty("dataTypeDisplay")
  private String dataTypeDisplay = null;

  @JsonProperty("description")
  private String description = null;

  @JsonProperty("displayName")
  private String displayName = null;

  @JsonProperty("fullyQualifiedName")
  private String fullyQualifiedName = null;

  @JsonProperty("jsonSchema")
  private String jsonSchema = null;

  @JsonProperty("name")
  private String name = null;

  @JsonProperty("ordinalPosition")
  private Integer ordinalPosition = null;

  @JsonProperty("precision")
  private Integer precision = null;

  @JsonProperty("profile")
  private ColumnProfile profile = null;

  @JsonProperty("scale")
  private Integer scale = null;

  @JsonProperty("tags")
  private List<TagLabel> tags = null;

  public Column arrayDataType(ArrayDataTypeEnum arrayDataType) {
    this.arrayDataType = arrayDataType;
    return this;
  }

   /**
   * Get arrayDataType
   * @return arrayDataType
  **/
  @Schema(description = "")
  public ArrayDataTypeEnum getArrayDataType() {
    return arrayDataType;
  }

  public void setArrayDataType(ArrayDataTypeEnum arrayDataType) {
    this.arrayDataType = arrayDataType;
  }

  public Column children(List<Column> children) {
    this.children = children;
    return this;
  }

  public Column addChildrenItem(Column childrenItem) {
    if (this.children == null) {
      this.children = new ArrayList<Column>();
    }
    this.children.add(childrenItem);
    return this;
  }

   /**
   * Get children
   * @return children
  **/
  @Schema(description = "")
  public List<Column> getChildren() {
    return children;
  }

  public void setChildren(List<Column> children) {
    this.children = children;
  }

  public Column constraint(ConstraintEnum constraint) {
    this.constraint = constraint;
    return this;
  }

   /**
   * Get constraint
   * @return constraint
  **/
  @Schema(description = "")
  public ConstraintEnum getConstraint() {
    return constraint;
  }

  public void setConstraint(ConstraintEnum constraint) {
    this.constraint = constraint;
  }

  public Column customMetrics(List<CustomMetric> customMetrics) {
    this.customMetrics = customMetrics;
    return this;
  }

  public Column addCustomMetricsItem(CustomMetric customMetricsItem) {
    if (this.customMetrics == null) {
      this.customMetrics = new ArrayList<CustomMetric>();
    }
    this.customMetrics.add(customMetricsItem);
    return this;
  }

   /**
   * Get customMetrics
   * @return customMetrics
  **/
  @Schema(description = "")
  public List<CustomMetric> getCustomMetrics() {
    return customMetrics;
  }

  public void setCustomMetrics(List<CustomMetric> customMetrics) {
    this.customMetrics = customMetrics;
  }

  public Column dataLength(Integer dataLength) {
    this.dataLength = dataLength;
    return this;
  }

   /**
   * Get dataLength
   * @return dataLength
  **/
  @Schema(description = "")
  public Integer getDataLength() {
    return dataLength;
  }

  public void setDataLength(Integer dataLength) {
    this.dataLength = dataLength;
  }

  public Column dataType(DataTypeEnum dataType) {
    this.dataType = dataType;
    return this;
  }

   /**
   * Get dataType
   * @return dataType
  **/
  @Schema(required = true, description = "")
  public DataTypeEnum getDataType() {
    return dataType;
  }

  public void setDataType(DataTypeEnum dataType) {
    this.dataType = dataType;
  }

  public Column dataTypeDisplay(String dataTypeDisplay) {
    this.dataTypeDisplay = dataTypeDisplay;
    return this;
  }

   /**
   * Get dataTypeDisplay
   * @return dataTypeDisplay
  **/
  @Schema(description = "")
  public String getDataTypeDisplay() {
    return dataTypeDisplay;
  }

  public void setDataTypeDisplay(String dataTypeDisplay) {
    this.dataTypeDisplay = dataTypeDisplay;
  }

  public Column description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @Schema(description = "")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public Column displayName(String displayName) {
    this.displayName = displayName;
    return this;
  }

   /**
   * Get displayName
   * @return displayName
  **/
  @Schema(description = "")
  public String getDisplayName() {
    return displayName;
  }

  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }

  public Column fullyQualifiedName(String fullyQualifiedName) {
    this.fullyQualifiedName = fullyQualifiedName;
    return this;
  }

   /**
   * Get fullyQualifiedName
   * @return fullyQualifiedName
  **/
  @Schema(description = "")
  public String getFullyQualifiedName() {
    return fullyQualifiedName;
  }

  public void setFullyQualifiedName(String fullyQualifiedName) {
    this.fullyQualifiedName = fullyQualifiedName;
  }

  public Column jsonSchema(String jsonSchema) {
    this.jsonSchema = jsonSchema;
    return this;
  }

   /**
   * Get jsonSchema
   * @return jsonSchema
  **/
  @Schema(description = "")
  public String getJsonSchema() {
    return jsonSchema;
  }

  public void setJsonSchema(String jsonSchema) {
    this.jsonSchema = jsonSchema;
  }

  public Column name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @Schema(required = true, description = "")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public Column ordinalPosition(Integer ordinalPosition) {
    this.ordinalPosition = ordinalPosition;
    return this;
  }

   /**
   * Get ordinalPosition
   * @return ordinalPosition
  **/
  @Schema(description = "")
  public Integer getOrdinalPosition() {
    return ordinalPosition;
  }

  public void setOrdinalPosition(Integer ordinalPosition) {
    this.ordinalPosition = ordinalPosition;
  }

  public Column precision(Integer precision) {
    this.precision = precision;
    return this;
  }

   /**
   * Get precision
   * @return precision
  **/
  @Schema(description = "")
  public Integer getPrecision() {
    return precision;
  }

  public void setPrecision(Integer precision) {
    this.precision = precision;
  }

  public Column profile(ColumnProfile profile) {
    this.profile = profile;
    return this;
  }

   /**
   * Get profile
   * @return profile
  **/
  @Schema(description = "")
  public ColumnProfile getProfile() {
    return profile;
  }

  public void setProfile(ColumnProfile profile) {
    this.profile = profile;
  }

  public Column scale(Integer scale) {
    this.scale = scale;
    return this;
  }

   /**
   * Get scale
   * @return scale
  **/
  @Schema(description = "")
  public Integer getScale() {
    return scale;
  }

  public void setScale(Integer scale) {
    this.scale = scale;
  }

  public Column tags(List<TagLabel> tags) {
    this.tags = tags;
    return this;
  }

  public Column addTagsItem(TagLabel tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<TagLabel>();
    }
    this.tags.add(tagsItem);
    return this;
  }

   /**
   * Get tags
   * @return tags
  **/
  @Schema(description = "")
  public List<TagLabel> getTags() {
    return tags;
  }

  public void setTags(List<TagLabel> tags) {
    this.tags = tags;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Column column = (Column) o;
    return Objects.equals(this.arrayDataType, column.arrayDataType) &&
        Objects.equals(this.children, column.children) &&
        Objects.equals(this.constraint, column.constraint) &&
        Objects.equals(this.customMetrics, column.customMetrics) &&
        Objects.equals(this.dataLength, column.dataLength) &&
        Objects.equals(this.dataType, column.dataType) &&
        Objects.equals(this.dataTypeDisplay, column.dataTypeDisplay) &&
        Objects.equals(this.description, column.description) &&
        Objects.equals(this.displayName, column.displayName) &&
        Objects.equals(this.fullyQualifiedName, column.fullyQualifiedName) &&
        Objects.equals(this.jsonSchema, column.jsonSchema) &&
        Objects.equals(this.name, column.name) &&
        Objects.equals(this.ordinalPosition, column.ordinalPosition) &&
        Objects.equals(this.precision, column.precision) &&
        Objects.equals(this.profile, column.profile) &&
        Objects.equals(this.scale, column.scale) &&
        Objects.equals(this.tags, column.tags);
  }

  @Override
  public int hashCode() {
    return Objects.hash(arrayDataType, children, constraint, customMetrics, dataLength, dataType, dataTypeDisplay, description, displayName, fullyQualifiedName, jsonSchema, name, ordinalPosition, precision, profile, scale, tags);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Column {\n");
    
    sb.append("    arrayDataType: ").append(toIndentedString(arrayDataType)).append("\n");
    sb.append("    children: ").append(toIndentedString(children)).append("\n");
    sb.append("    constraint: ").append(toIndentedString(constraint)).append("\n");
    sb.append("    customMetrics: ").append(toIndentedString(customMetrics)).append("\n");
    sb.append("    dataLength: ").append(toIndentedString(dataLength)).append("\n");
    sb.append("    dataType: ").append(toIndentedString(dataType)).append("\n");
    sb.append("    dataTypeDisplay: ").append(toIndentedString(dataTypeDisplay)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    fullyQualifiedName: ").append(toIndentedString(fullyQualifiedName)).append("\n");
    sb.append("    jsonSchema: ").append(toIndentedString(jsonSchema)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    ordinalPosition: ").append(toIndentedString(ordinalPosition)).append("\n");
    sb.append("    precision: ").append(toIndentedString(precision)).append("\n");
    sb.append("    profile: ").append(toIndentedString(profile)).append("\n");
    sb.append("    scale: ").append(toIndentedString(scale)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
