/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata system. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.    Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`. Resource URI for an entity    instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  Data Asset APIs - These API endpoints support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  Service APIs - These API endpoints support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes transactional databases - MySQL, Postgres, MSSQL, Oracle, and data warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to dashboard services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messaingService` - APIs related to messaging services. This includes Apache Kafka and Apache Pulsar (work in progress).  Teams & Users APIs - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  Search & Suggest APIs - These API endpoints support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  Other APIs - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities  ## Implementation Notes  We use the [Dropwizard](https://www.dropwizard.io/en/latest/) Java framework for developing Restful web services.  APIs are documented using [Swagger/OpenAPI 3.x](https://swagger.io/specification/). We take schema first approach and define metadata entities and types in [JSON schema](https://json-schema.org/)  specification version [Draft-07 to 2019-09](https://json-schema.org/draft/2019-09/release-notes.html). Java code is  generated from the JSON schema using [JSON schema 2 pojo](https://www.jsonschema2pojo.org/) tool and Python code is  generated using the [Data model code generator](https://github.com/koxudaxi/datamodel-code-generator) tool.
 *
 * OpenAPI spec version: 0.13.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import org.openmetadata.client.model.CustomMetricProfile;
import org.openmetadata.client.model.Histogram;
/**
 * ColumnProfile
 */

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")
public class ColumnProfile {
  @JsonProperty("customMetricsProfile")
  private List<CustomMetricProfile> customMetricsProfile = null;

  @JsonProperty("distinctCount")
  private Double distinctCount = null;

  @JsonProperty("distinctProportion")
  private Double distinctProportion = null;

  @JsonProperty("duplicateCount")
  private Double duplicateCount = null;

  @JsonProperty("histogram")
  private Histogram histogram = null;

  @JsonProperty("max")
  private Object max = null;

  @JsonProperty("maxLength")
  private Double maxLength = null;

  @JsonProperty("mean")
  private Double mean = null;

  @JsonProperty("median")
  private Double median = null;

  @JsonProperty("min")
  private Object min = null;

  @JsonProperty("minLength")
  private Double minLength = null;

  @JsonProperty("missingCount")
  private Double missingCount = null;

  @JsonProperty("missingPercentage")
  private Double missingPercentage = null;

  @JsonProperty("name")
  private String name = null;

  @JsonProperty("nullCount")
  private Double nullCount = null;

  @JsonProperty("nullProportion")
  private Double nullProportion = null;

  @JsonProperty("stddev")
  private Double stddev = null;

  @JsonProperty("sum")
  private Double sum = null;

  @JsonProperty("timestamp")
  private Long timestamp = null;

  @JsonProperty("uniqueCount")
  private Double uniqueCount = null;

  @JsonProperty("uniqueProportion")
  private Double uniqueProportion = null;

  @JsonProperty("validCount")
  private Double validCount = null;

  @JsonProperty("valuesCount")
  private Double valuesCount = null;

  @JsonProperty("valuesPercentage")
  private Double valuesPercentage = null;

  @JsonProperty("variance")
  private Double variance = null;

  public ColumnProfile customMetricsProfile(List<CustomMetricProfile> customMetricsProfile) {
    this.customMetricsProfile = customMetricsProfile;
    return this;
  }

  public ColumnProfile addCustomMetricsProfileItem(CustomMetricProfile customMetricsProfileItem) {
    if (this.customMetricsProfile == null) {
      this.customMetricsProfile = new ArrayList<CustomMetricProfile>();
    }
    this.customMetricsProfile.add(customMetricsProfileItem);
    return this;
  }

   /**
   * Get customMetricsProfile
   * @return customMetricsProfile
  **/
  @Schema(description = "")
  public List<CustomMetricProfile> getCustomMetricsProfile() {
    return customMetricsProfile;
  }

  public void setCustomMetricsProfile(List<CustomMetricProfile> customMetricsProfile) {
    this.customMetricsProfile = customMetricsProfile;
  }

  public ColumnProfile distinctCount(Double distinctCount) {
    this.distinctCount = distinctCount;
    return this;
  }

   /**
   * Get distinctCount
   * @return distinctCount
  **/
  @Schema(description = "")
  public Double getDistinctCount() {
    return distinctCount;
  }

  public void setDistinctCount(Double distinctCount) {
    this.distinctCount = distinctCount;
  }

  public ColumnProfile distinctProportion(Double distinctProportion) {
    this.distinctProportion = distinctProportion;
    return this;
  }

   /**
   * Get distinctProportion
   * @return distinctProportion
  **/
  @Schema(description = "")
  public Double getDistinctProportion() {
    return distinctProportion;
  }

  public void setDistinctProportion(Double distinctProportion) {
    this.distinctProportion = distinctProportion;
  }

  public ColumnProfile duplicateCount(Double duplicateCount) {
    this.duplicateCount = duplicateCount;
    return this;
  }

   /**
   * Get duplicateCount
   * @return duplicateCount
  **/
  @Schema(description = "")
  public Double getDuplicateCount() {
    return duplicateCount;
  }

  public void setDuplicateCount(Double duplicateCount) {
    this.duplicateCount = duplicateCount;
  }

  public ColumnProfile histogram(Histogram histogram) {
    this.histogram = histogram;
    return this;
  }

   /**
   * Get histogram
   * @return histogram
  **/
  @Schema(description = "")
  public Histogram getHistogram() {
    return histogram;
  }

  public void setHistogram(Histogram histogram) {
    this.histogram = histogram;
  }

  public ColumnProfile max(Object max) {
    this.max = max;
    return this;
  }

   /**
   * Get max
   * @return max
  **/
  @Schema(description = "")
  public Object getMax() {
    return max;
  }

  public void setMax(Object max) {
    this.max = max;
  }

  public ColumnProfile maxLength(Double maxLength) {
    this.maxLength = maxLength;
    return this;
  }

   /**
   * Get maxLength
   * @return maxLength
  **/
  @Schema(description = "")
  public Double getMaxLength() {
    return maxLength;
  }

  public void setMaxLength(Double maxLength) {
    this.maxLength = maxLength;
  }

  public ColumnProfile mean(Double mean) {
    this.mean = mean;
    return this;
  }

   /**
   * Get mean
   * @return mean
  **/
  @Schema(description = "")
  public Double getMean() {
    return mean;
  }

  public void setMean(Double mean) {
    this.mean = mean;
  }

  public ColumnProfile median(Double median) {
    this.median = median;
    return this;
  }

   /**
   * Get median
   * @return median
  **/
  @Schema(description = "")
  public Double getMedian() {
    return median;
  }

  public void setMedian(Double median) {
    this.median = median;
  }

  public ColumnProfile min(Object min) {
    this.min = min;
    return this;
  }

   /**
   * Get min
   * @return min
  **/
  @Schema(description = "")
  public Object getMin() {
    return min;
  }

  public void setMin(Object min) {
    this.min = min;
  }

  public ColumnProfile minLength(Double minLength) {
    this.minLength = minLength;
    return this;
  }

   /**
   * Get minLength
   * @return minLength
  **/
  @Schema(description = "")
  public Double getMinLength() {
    return minLength;
  }

  public void setMinLength(Double minLength) {
    this.minLength = minLength;
  }

  public ColumnProfile missingCount(Double missingCount) {
    this.missingCount = missingCount;
    return this;
  }

   /**
   * Get missingCount
   * @return missingCount
  **/
  @Schema(description = "")
  public Double getMissingCount() {
    return missingCount;
  }

  public void setMissingCount(Double missingCount) {
    this.missingCount = missingCount;
  }

  public ColumnProfile missingPercentage(Double missingPercentage) {
    this.missingPercentage = missingPercentage;
    return this;
  }

   /**
   * Get missingPercentage
   * @return missingPercentage
  **/
  @Schema(description = "")
  public Double getMissingPercentage() {
    return missingPercentage;
  }

  public void setMissingPercentage(Double missingPercentage) {
    this.missingPercentage = missingPercentage;
  }

  public ColumnProfile name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @Schema(required = true, description = "")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public ColumnProfile nullCount(Double nullCount) {
    this.nullCount = nullCount;
    return this;
  }

   /**
   * Get nullCount
   * @return nullCount
  **/
  @Schema(description = "")
  public Double getNullCount() {
    return nullCount;
  }

  public void setNullCount(Double nullCount) {
    this.nullCount = nullCount;
  }

  public ColumnProfile nullProportion(Double nullProportion) {
    this.nullProportion = nullProportion;
    return this;
  }

   /**
   * Get nullProportion
   * @return nullProportion
  **/
  @Schema(description = "")
  public Double getNullProportion() {
    return nullProportion;
  }

  public void setNullProportion(Double nullProportion) {
    this.nullProportion = nullProportion;
  }

  public ColumnProfile stddev(Double stddev) {
    this.stddev = stddev;
    return this;
  }

   /**
   * Get stddev
   * @return stddev
  **/
  @Schema(description = "")
  public Double getStddev() {
    return stddev;
  }

  public void setStddev(Double stddev) {
    this.stddev = stddev;
  }

  public ColumnProfile sum(Double sum) {
    this.sum = sum;
    return this;
  }

   /**
   * Get sum
   * @return sum
  **/
  @Schema(description = "")
  public Double getSum() {
    return sum;
  }

  public void setSum(Double sum) {
    this.sum = sum;
  }

  public ColumnProfile timestamp(Long timestamp) {
    this.timestamp = timestamp;
    return this;
  }

   /**
   * Get timestamp
   * @return timestamp
  **/
  @Schema(required = true, description = "")
  public Long getTimestamp() {
    return timestamp;
  }

  public void setTimestamp(Long timestamp) {
    this.timestamp = timestamp;
  }

  public ColumnProfile uniqueCount(Double uniqueCount) {
    this.uniqueCount = uniqueCount;
    return this;
  }

   /**
   * Get uniqueCount
   * @return uniqueCount
  **/
  @Schema(description = "")
  public Double getUniqueCount() {
    return uniqueCount;
  }

  public void setUniqueCount(Double uniqueCount) {
    this.uniqueCount = uniqueCount;
  }

  public ColumnProfile uniqueProportion(Double uniqueProportion) {
    this.uniqueProportion = uniqueProportion;
    return this;
  }

   /**
   * Get uniqueProportion
   * @return uniqueProportion
  **/
  @Schema(description = "")
  public Double getUniqueProportion() {
    return uniqueProportion;
  }

  public void setUniqueProportion(Double uniqueProportion) {
    this.uniqueProportion = uniqueProportion;
  }

  public ColumnProfile validCount(Double validCount) {
    this.validCount = validCount;
    return this;
  }

   /**
   * Get validCount
   * @return validCount
  **/
  @Schema(description = "")
  public Double getValidCount() {
    return validCount;
  }

  public void setValidCount(Double validCount) {
    this.validCount = validCount;
  }

  public ColumnProfile valuesCount(Double valuesCount) {
    this.valuesCount = valuesCount;
    return this;
  }

   /**
   * Get valuesCount
   * @return valuesCount
  **/
  @Schema(description = "")
  public Double getValuesCount() {
    return valuesCount;
  }

  public void setValuesCount(Double valuesCount) {
    this.valuesCount = valuesCount;
  }

  public ColumnProfile valuesPercentage(Double valuesPercentage) {
    this.valuesPercentage = valuesPercentage;
    return this;
  }

   /**
   * Get valuesPercentage
   * @return valuesPercentage
  **/
  @Schema(description = "")
  public Double getValuesPercentage() {
    return valuesPercentage;
  }

  public void setValuesPercentage(Double valuesPercentage) {
    this.valuesPercentage = valuesPercentage;
  }

  public ColumnProfile variance(Double variance) {
    this.variance = variance;
    return this;
  }

   /**
   * Get variance
   * @return variance
  **/
  @Schema(description = "")
  public Double getVariance() {
    return variance;
  }

  public void setVariance(Double variance) {
    this.variance = variance;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ColumnProfile columnProfile = (ColumnProfile) o;
    return Objects.equals(this.customMetricsProfile, columnProfile.customMetricsProfile) &&
        Objects.equals(this.distinctCount, columnProfile.distinctCount) &&
        Objects.equals(this.distinctProportion, columnProfile.distinctProportion) &&
        Objects.equals(this.duplicateCount, columnProfile.duplicateCount) &&
        Objects.equals(this.histogram, columnProfile.histogram) &&
        Objects.equals(this.max, columnProfile.max) &&
        Objects.equals(this.maxLength, columnProfile.maxLength) &&
        Objects.equals(this.mean, columnProfile.mean) &&
        Objects.equals(this.median, columnProfile.median) &&
        Objects.equals(this.min, columnProfile.min) &&
        Objects.equals(this.minLength, columnProfile.minLength) &&
        Objects.equals(this.missingCount, columnProfile.missingCount) &&
        Objects.equals(this.missingPercentage, columnProfile.missingPercentage) &&
        Objects.equals(this.name, columnProfile.name) &&
        Objects.equals(this.nullCount, columnProfile.nullCount) &&
        Objects.equals(this.nullProportion, columnProfile.nullProportion) &&
        Objects.equals(this.stddev, columnProfile.stddev) &&
        Objects.equals(this.sum, columnProfile.sum) &&
        Objects.equals(this.timestamp, columnProfile.timestamp) &&
        Objects.equals(this.uniqueCount, columnProfile.uniqueCount) &&
        Objects.equals(this.uniqueProportion, columnProfile.uniqueProportion) &&
        Objects.equals(this.validCount, columnProfile.validCount) &&
        Objects.equals(this.valuesCount, columnProfile.valuesCount) &&
        Objects.equals(this.valuesPercentage, columnProfile.valuesPercentage) &&
        Objects.equals(this.variance, columnProfile.variance);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customMetricsProfile, distinctCount, distinctProportion, duplicateCount, histogram, max, maxLength, mean, median, min, minLength, missingCount, missingPercentage, name, nullCount, nullProportion, stddev, sum, timestamp, uniqueCount, uniqueProportion, validCount, valuesCount, valuesPercentage, variance);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ColumnProfile {\n");
    
    sb.append("    customMetricsProfile: ").append(toIndentedString(customMetricsProfile)).append("\n");
    sb.append("    distinctCount: ").append(toIndentedString(distinctCount)).append("\n");
    sb.append("    distinctProportion: ").append(toIndentedString(distinctProportion)).append("\n");
    sb.append("    duplicateCount: ").append(toIndentedString(duplicateCount)).append("\n");
    sb.append("    histogram: ").append(toIndentedString(histogram)).append("\n");
    sb.append("    max: ").append(toIndentedString(max)).append("\n");
    sb.append("    maxLength: ").append(toIndentedString(maxLength)).append("\n");
    sb.append("    mean: ").append(toIndentedString(mean)).append("\n");
    sb.append("    median: ").append(toIndentedString(median)).append("\n");
    sb.append("    min: ").append(toIndentedString(min)).append("\n");
    sb.append("    minLength: ").append(toIndentedString(minLength)).append("\n");
    sb.append("    missingCount: ").append(toIndentedString(missingCount)).append("\n");
    sb.append("    missingPercentage: ").append(toIndentedString(missingPercentage)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    nullCount: ").append(toIndentedString(nullCount)).append("\n");
    sb.append("    nullProportion: ").append(toIndentedString(nullProportion)).append("\n");
    sb.append("    stddev: ").append(toIndentedString(stddev)).append("\n");
    sb.append("    sum: ").append(toIndentedString(sum)).append("\n");
    sb.append("    timestamp: ").append(toIndentedString(timestamp)).append("\n");
    sb.append("    uniqueCount: ").append(toIndentedString(uniqueCount)).append("\n");
    sb.append("    uniqueProportion: ").append(toIndentedString(uniqueProportion)).append("\n");
    sb.append("    validCount: ").append(toIndentedString(validCount)).append("\n");
    sb.append("    valuesCount: ").append(toIndentedString(valuesCount)).append("\n");
    sb.append("    valuesPercentage: ").append(toIndentedString(valuesPercentage)).append("\n");
    sb.append("    variance: ").append(toIndentedString(variance)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
