/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata system. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.    Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`. Resource URI for an entity    instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  Data Asset APIs - These API endpoints support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  Service APIs - These API endpoints support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes transactional databases - MySQL, Postgres, MSSQL, Oracle, and data warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to dashboard services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messaingService` - APIs related to messaging services. This includes Apache Kafka and Apache Pulsar (work in progress).  Teams & Users APIs - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  Search & Suggest APIs - These API endpoints support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  Other APIs - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities  ## Implementation Notes  We use the [Dropwizard](https://www.dropwizard.io/en/latest/) Java framework for developing Restful web services.  APIs are documented using [Swagger/OpenAPI 3.x](https://swagger.io/specification/). We take schema first approach and define metadata entities and types in [JSON schema](https://json-schema.org/)  specification version [Draft-07 to 2019-09](https://json-schema.org/draft/2019-09/release-notes.html). Java code is  generated from the JSON schema using [JSON schema 2 pojo](https://www.jsonschema2pojo.org/) tool and Python code is  generated using the [Data model code generator](https://github.com/koxudaxi/datamodel-code-generator) tool.
 *
 * OpenAPI spec version: 0.13.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
/**
 * CreateEventPublisherJob
 */

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")
public class CreateEventPublisherJob {
  @JsonProperty("batchSize")
  private Integer batchSize = null;

  @JsonProperty("entities")
  private List<String> entities = null;

  @JsonProperty("flushIntervalInSec")
  private Integer flushIntervalInSec = null;

  /**
   * Gets or Sets publisherType
   */
  public enum PublisherTypeEnum {
    ELASTICSEARCH("elasticSearch"),
    KAFKA("kafka");

    private String value;

    PublisherTypeEnum(String value) {
      this.value = value;
    }
    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    @JsonCreator
    public static PublisherTypeEnum fromValue(String text) {
      for (PublisherTypeEnum b : PublisherTypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

  }  @JsonProperty("publisherType")
  private PublisherTypeEnum publisherType = null;

  @JsonProperty("recreateIndex")
  private Boolean recreateIndex = null;

  /**
   * Gets or Sets runMode
   */
  public enum RunModeEnum {
    STREAM("stream"),
    BATCH("batch");

    private String value;

    RunModeEnum(String value) {
      this.value = value;
    }
    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    @JsonCreator
    public static RunModeEnum fromValue(String text) {
      for (RunModeEnum b : RunModeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

  }  @JsonProperty("runMode")
  private RunModeEnum runMode = null;

  public CreateEventPublisherJob batchSize(Integer batchSize) {
    this.batchSize = batchSize;
    return this;
  }

   /**
   * Get batchSize
   * @return batchSize
  **/
  @Schema(description = "")
  public Integer getBatchSize() {
    return batchSize;
  }

  public void setBatchSize(Integer batchSize) {
    this.batchSize = batchSize;
  }

  public CreateEventPublisherJob entities(List<String> entities) {
    this.entities = entities;
    return this;
  }

  public CreateEventPublisherJob addEntitiesItem(String entitiesItem) {
    if (this.entities == null) {
      this.entities = new ArrayList<String>();
    }
    this.entities.add(entitiesItem);
    return this;
  }

   /**
   * Get entities
   * @return entities
  **/
  @Schema(description = "")
  public List<String> getEntities() {
    return entities;
  }

  public void setEntities(List<String> entities) {
    this.entities = entities;
  }

  public CreateEventPublisherJob flushIntervalInSec(Integer flushIntervalInSec) {
    this.flushIntervalInSec = flushIntervalInSec;
    return this;
  }

   /**
   * Get flushIntervalInSec
   * @return flushIntervalInSec
  **/
  @Schema(description = "")
  public Integer getFlushIntervalInSec() {
    return flushIntervalInSec;
  }

  public void setFlushIntervalInSec(Integer flushIntervalInSec) {
    this.flushIntervalInSec = flushIntervalInSec;
  }

  public CreateEventPublisherJob publisherType(PublisherTypeEnum publisherType) {
    this.publisherType = publisherType;
    return this;
  }

   /**
   * Get publisherType
   * @return publisherType
  **/
  @Schema(required = true, description = "")
  public PublisherTypeEnum getPublisherType() {
    return publisherType;
  }

  public void setPublisherType(PublisherTypeEnum publisherType) {
    this.publisherType = publisherType;
  }

  public CreateEventPublisherJob recreateIndex(Boolean recreateIndex) {
    this.recreateIndex = recreateIndex;
    return this;
  }

   /**
   * Get recreateIndex
   * @return recreateIndex
  **/
  @Schema(description = "")
  public Boolean isRecreateIndex() {
    return recreateIndex;
  }

  public void setRecreateIndex(Boolean recreateIndex) {
    this.recreateIndex = recreateIndex;
  }

  public CreateEventPublisherJob runMode(RunModeEnum runMode) {
    this.runMode = runMode;
    return this;
  }

   /**
   * Get runMode
   * @return runMode
  **/
  @Schema(required = true, description = "")
  public RunModeEnum getRunMode() {
    return runMode;
  }

  public void setRunMode(RunModeEnum runMode) {
    this.runMode = runMode;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateEventPublisherJob createEventPublisherJob = (CreateEventPublisherJob) o;
    return Objects.equals(this.batchSize, createEventPublisherJob.batchSize) &&
        Objects.equals(this.entities, createEventPublisherJob.entities) &&
        Objects.equals(this.flushIntervalInSec, createEventPublisherJob.flushIntervalInSec) &&
        Objects.equals(this.publisherType, createEventPublisherJob.publisherType) &&
        Objects.equals(this.recreateIndex, createEventPublisherJob.recreateIndex) &&
        Objects.equals(this.runMode, createEventPublisherJob.runMode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(batchSize, entities, flushIntervalInSec, publisherType, recreateIndex, runMode);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateEventPublisherJob {\n");
    
    sb.append("    batchSize: ").append(toIndentedString(batchSize)).append("\n");
    sb.append("    entities: ").append(toIndentedString(entities)).append("\n");
    sb.append("    flushIntervalInSec: ").append(toIndentedString(flushIntervalInSec)).append("\n");
    sb.append("    publisherType: ").append(toIndentedString(publisherType)).append("\n");
    sb.append("    recreateIndex: ").append(toIndentedString(recreateIndex)).append("\n");
    sb.append("    runMode: ").append(toIndentedString(runMode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
